/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.javasci;

import java.io.File;
import java.io.FileNotFoundException;
import org.scilab.modules.javasci.Call_Scilab;
import org.scilab.modules.javasci.Call_ScilabJNI;
import org.scilab.modules.javasci.JavasciException;
import org.scilab.modules.javasci.ScilabVariablesJavasci;
import org.scilab.modules.types.ScilabBoolean;
import org.scilab.modules.types.ScilabBooleanSparse;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabInteger;
import org.scilab.modules.types.ScilabIntegerTypeEnum;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.types.ScilabMList;
import org.scilab.modules.types.ScilabPolynomial;
import org.scilab.modules.types.ScilabSparse;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabTList;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.types.ScilabTypeEnum;

public class Scilab {
    private static int notHandledError = -999;
    private String SCI = null;
    private boolean advancedMode = false;

    public Scilab() throws JavasciException.InitializationException {
        this(null, false);
    }

    public Scilab(String string) throws JavasciException.InitializationException {
        this(string, false);
    }

    public Scilab(boolean bl) throws JavasciException.InitializationException {
        this(null, bl);
    }

    public Scilab(String string, boolean bl) throws JavasciException.InitializationException {
        String string2 = string;
        if (!System.getProperty("os.name").toLowerCase().contains("windows") && string2 == null) {
            try {
                string2 = System.getProperty("SCI");
                if (!(string2 != null && string2.length() != 0 || (string2 = System.getenv("SCI")) != null && string2.length() != 0)) {
                    throw new JavasciException.InitializationException("Auto detection of SCI failed.\nSCI empty.");
                }
            }
            catch (Exception exception) {
                throw new JavasciException.InitializationException("Auto detection of SCI failed.\nCould not retrieve the variable SCI.", exception);
            }
        }
        this.advancedMode = bl;
        this.initScilab(string2);
    }

    private void initScilab(String string) throws JavasciException.InitializationException {
        Call_Scilab.SetFromJavaToON();
        if (!System.getProperty("os.name").toLowerCase().contains("windows")) {
            File file = new File(string);
            if (!file.isDirectory()) {
                throw new JavasciException.InitializationException("Could not find directory " + file.getAbsolutePath());
            }
            this.SCI = string;
        }
    }

    public boolean open() throws JavasciException {
        int n = Call_Scilab.Call_ScilabOpen(this.SCI, this.advancedMode, null, -1);
        switch (n) {
            case 0: {
                return true;
            }
            case -1: {
                throw new JavasciException.AlreadyRunningException("Javasci already running.");
            }
            case -2: {
                throw new JavasciException.InitializationException("Could not find SCI.");
            }
            case -3: {
                throw new JavasciException.InitializationException("No existing directory.");
            }
            case 10001: {
                throw new JavasciException.InitializationException("Stacksize failed (not enought memory ?).");
            }
        }
        throw new JavasciException.InitializationException("Unknown startup error: " + n);
    }

    public boolean open(String string) throws JavasciException {
        if (!this.open()) {
            return false;
        }
        return this.exec(string);
    }

    public boolean open(String[] stringArray) throws JavasciException {
        if (!this.open()) {
            return false;
        }
        return this.exec(stringArray);
    }

    public boolean open(File file) throws JavasciException, FileNotFoundException {
        if (!this.open()) {
            return false;
        }
        return this.exec(file);
    }

    public boolean exec(String string) {
        try {
            this.execException(string);
            return true;
        }
        catch (JavasciException.ScilabErrorException scilabErrorException) {
            return false;
        }
    }

    public void execException(String string) throws JavasciException.ScilabErrorException {
        int n = Call_Scilab.SendScilabJob(string);
        if (n != 0) {
            throw new JavasciException.ScilabErrorException("A Scilab error occurred: " + this.getLastErrorMessage(), this.getLastErrorCode());
        }
    }

    public boolean exec(String[] stringArray) {
        try {
            this.execException(stringArray);
            return true;
        }
        catch (JavasciException.ScilabErrorException scilabErrorException) {
            return false;
        }
    }

    public void execException(String[] stringArray) throws JavasciException.ScilabErrorException {
        int n = Call_Scilab.SendScilabJobs(stringArray, stringArray.length);
        if (n != 0) {
            throw new JavasciException.ScilabErrorException("A Scilab error occurred: " + this.getLastErrorMessage(), this.getLastErrorCode());
        }
    }

    public void execException(File file) throws FileNotFoundException, JavasciException.ScilabErrorException {
        if (!file.exists()) {
            throw new FileNotFoundException("Could not find " + String.valueOf(file));
        }
        this.execException("exec('" + String.valueOf(file) + "');");
    }

    public boolean exec(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("Could not find " + String.valueOf(file));
        }
        return this.exec("exec('" + String.valueOf(file) + "');");
    }

    public boolean isExistingVariable(String string) {
        return Call_Scilab.isExistingVariable(string);
    }

    public boolean close() {
        return Call_Scilab.TerminateScilab(null);
    }

    public int getLastErrorCode() {
        return Call_Scilab.GetLastErrorCode();
    }

    public String getLastErrorMessage() {
        return Call_Scilab.getLastErrorMessage();
    }

    public boolean isGraphicOpened() {
        return Call_Scilab.isGraphicOpened();
    }

    public ScilabTypeEnum getVariableType(String string) throws JavasciException {
        return Scilab.getVariableTypeInCurrentScilabSession(string);
    }

    public static ScilabTypeEnum getVariableTypeInCurrentScilabSession(String string) throws JavasciException {
        ScilabTypeEnum scilabTypeEnum = null;
        try {
            scilabTypeEnum = Call_Scilab.getVariableType(string);
            if (scilabTypeEnum == null) {
                throw new JavasciException.UndefinedVariableException("Could not find the type of the variable '" + string + "'");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string2 = illegalArgumentException.getMessage().substring(illegalArgumentException.getMessage().lastIndexOf(32) + 1);
            if (string2.equals("-2")) {
                throw new JavasciException.UndefinedVariableException("Could not find variable '" + string + "'");
            }
            throw new JavasciException.UnknownTypeException("Type of " + string + " unknown");
        }
        return scilabTypeEnum;
    }

    public ScilabType get(String string) throws JavasciException {
        return Scilab.getInCurrentScilabSession(string);
    }

    public ScilabType getByReference(String string) throws JavasciException {
        return Scilab.getInCurrentScilabSession(string, true);
    }

    public static ScilabType getInCurrentScilabSession(String string) throws JavasciException {
        return Scilab.getInCurrentScilabSession(string, false);
    }

    public static ScilabType getInCurrentScilabSession(String string, boolean bl) throws JavasciException {
        ScilabTypeEnum scilabTypeEnum = Scilab.getVariableTypeInCurrentScilabSession(string);
        switch (scilabTypeEnum) {
            case sci_matrix: 
            case sci_boolean: 
            case sci_strings: 
            case sci_poly: 
            case sci_sparse: 
            case sci_boolean_sparse: 
            case sci_list: 
            case sci_tlist: 
            case sci_mlist: {
                return ScilabVariablesJavasci.getScilabVariable(string, true, bl);
            }
            case sci_ints: {
                ScilabIntegerTypeEnum scilabIntegerTypeEnum = Call_Scilab.getIntegerPrecision(string);
                switch (scilabIntegerTypeEnum) {
                    case sci_int8: 
                    case sci_uint8: 
                    case sci_int16: 
                    case sci_uint16: 
                    case sci_int32: 
                    case sci_uint32: {
                        return ScilabVariablesJavasci.getScilabVariable(string, true, bl);
                    }
                    case sci_int64: 
                    case sci_uint64: {
                        throw new JavasciException.UnsupportedTypeException("64 bit (signed and unsigned) integer types not managed in Scilab 5.X");
                    }
                }
            }
        }
        throw new JavasciException.UnsupportedTypeException("Type not managed: " + String.valueOf(scilabTypeEnum));
    }

    public boolean put(String string, ScilabType scilabType) throws JavasciException {
        return Scilab.putInCurrentScilabSession(string, scilabType);
    }

    public static boolean putInCurrentScilabSession(String string, ScilabType scilabType) throws JavasciException {
        int n = notHandledError;
        block0 : switch (scilabType.getType()) {
            case sci_matrix: {
                ScilabDouble scilabDouble = (ScilabDouble)scilabType;
                if (scilabDouble.isReal()) {
                    n = Call_Scilab.putDouble(string, scilabDouble.getRealPart());
                    break;
                }
                n = Call_Scilab.putDoubleComplex(string, scilabDouble.getRealPart(), scilabDouble.getImaginaryPart());
                break;
            }
            case sci_poly: {
                ScilabPolynomial scilabPolynomial = (ScilabPolynomial)scilabType;
                if (scilabPolynomial.isReal()) {
                    n = Call_Scilab.putPolynomial(string, scilabPolynomial.getPolyVarName(), scilabPolynomial.getRealPart());
                    break;
                }
                n = Call_Scilab.putComplexPolynomial(string, scilabPolynomial.getPolyVarName(), scilabPolynomial.getRealPart(), scilabPolynomial.getImaginaryPart());
                break;
            }
            case sci_boolean: {
                ScilabBoolean scilabBoolean = (ScilabBoolean)scilabType;
                n = Call_Scilab.putBoolean(string, scilabBoolean.getData());
                break;
            }
            case sci_sparse: {
                ScilabSparse scilabSparse = (ScilabSparse)scilabType;
                if (scilabSparse.isReal()) {
                    n = Call_Scilab.putSparse(string, scilabSparse.getHeight(), scilabSparse.getWidth(), scilabSparse.getNbItemRow(), scilabSparse.getScilabColPos(), scilabSparse.getRealPart());
                    break;
                }
                n = Call_Scilab.putComplexSparse(string, scilabSparse.getHeight(), scilabSparse.getWidth(), scilabSparse.getNbItemRow(), scilabSparse.getScilabColPos(), scilabSparse.getRealPart(), scilabSparse.getImaginaryPart());
                break;
            }
            case sci_boolean_sparse: {
                ScilabBooleanSparse scilabBooleanSparse = (ScilabBooleanSparse)scilabType;
                n = Call_Scilab.putBooleanSparse(string, scilabBooleanSparse.getHeight(), scilabBooleanSparse.getWidth(), scilabBooleanSparse.getNbItemRow(), scilabBooleanSparse.getScilabColPos());
                break;
            }
            case sci_ints: {
                ScilabInteger scilabInteger = (ScilabInteger)scilabType;
                switch (scilabInteger.getPrec()) {
                    case sci_uint8: {
                        n = Call_Scilab.putUnsignedByte(string, scilabInteger.getDataAsByte());
                        break block0;
                    }
                    case sci_int8: {
                        n = Call_Scilab.putByte(string, scilabInteger.getDataAsByte());
                        break block0;
                    }
                    case sci_uint16: {
                        n = Call_Scilab.putUnsignedShort(string, scilabInteger.getDataAsShort());
                        break block0;
                    }
                    case sci_int16: {
                        n = Call_Scilab.putShort(string, scilabInteger.getDataAsShort());
                        break block0;
                    }
                    case sci_uint32: {
                        n = Call_Scilab.putUnsignedInt(string, scilabInteger.getDataAsInt());
                        break block0;
                    }
                    case sci_int32: {
                        n = Call_Scilab.putInt(string, scilabInteger.getDataAsInt());
                        break block0;
                    }
                }
                break;
            }
            case sci_strings: {
                ScilabString scilabString = (ScilabString)scilabType;
                n = Call_Scilab.putString(string, scilabString.getData());
                break;
            }
            case sci_list: {
                ScilabList scilabList = (ScilabList)scilabType;
                n = Call_ScilabJNI.putList(string, scilabList.getSerializedObject(), 'l');
                break;
            }
            case sci_tlist: {
                ScilabTList scilabTList = (ScilabTList)scilabType;
                n = Call_ScilabJNI.putList(string, scilabTList.getSerializedObject(), 't');
                break;
            }
            case sci_mlist: {
                ScilabMList scilabMList = (ScilabMList)scilabType;
                n = Call_ScilabJNI.putList(string, scilabMList.getSerializedObject(), 'm');
            }
        }
        if (n == notHandledError) {
            throw new JavasciException.UnsupportedTypeException("Type not managed: " + String.valueOf(scilabType.getClass()));
        }
        if (n != 0) {
            throw new JavasciException.ScilabInternalException("Storage of the variable '" + string + "' (" + String.valueOf(scilabType.getClass()) + ") failed.");
        }
        return true;
    }
}

