/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.graph.ScilabComponent;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.GraphActionManager;
import org.scilab.modules.graph.actions.base.OneBlockDependantAction;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.actions.StartAction;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class CompileAction
extends OneBlockDependantAction {
    public static final String NAME = XcosMessages.COMPILE;
    public static final String SMALL_ICON = "";
    public static final int MNEMONIC_KEY = 0;
    public static final int ACCELERATOR_KEY = 0;
    private int counter;
    private Timer displayTimer;

    public CompileAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
        char[] cArray = (XcosMessages.COMPILATION_IN_PROGRESS + "...").toCharArray();
        int n = XcosMessages.COMPILATION_IN_PROGRESS.length();
        this.counter = 0;
        this.displayTimer = new Timer(1000, actionEvent -> {
            this.counter = (this.counter + 1) % ("...".length() + 1);
            ((XcosDiagram)scilabGraph).info(new String(cArray, 0, n + this.counter));
        });
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return CompileAction.createMenu((ScilabGraph)scilabGraph, CompileAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        XcosDiagram xcosDiagram2 = (XcosDiagram)this.getGraph(actionEvent);
        ScilabComponent scilabComponent = (ScilabComponent)xcosDiagram2.getAsComponent();
        if (scilabComponent.isEditing()) {
            return;
        }
        ScicosObjectOwner scicosObjectOwner = Xcos.findRoot(xcosDiagram2);
        Xcos.getInstance().openedDiagrams(scicosObjectOwner).stream().forEach(xcosDiagram -> xcosDiagram.getAsComponent().clearCellOverlays());
        this.updateUI(true);
        this.displayTimer.start();
        String string = this.createCompilationCommand(scicosObjectOwner);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompileAction.this.displayTimer.stop();
                CompileAction.this.updateUI(false);
            }
        };
        try {
            ScilabInterpreterManagement.asynchronousScilabExec((ActionListener)actionListener, (String)string);
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
            Logger logger = Logger.getLogger(CompileAction.class.getName());
            logger.warning(interpreterException.getMessage());
        }
    }

    private String createCompilationCommand(ScicosObjectOwner scicosObjectOwner) {
        StringBuilder stringBuilder = new StringBuilder();
        Logger logger = Logger.getLogger(CompileAction.class.getName());
        logger.finest("start compilation");
        JavaController javaController = new JavaController();
        int[] nArray = new int[1];
        javaController.getObjectProperty(scicosObjectOwner.getUID(), scicosObjectOwner.getKind(), ObjectProperties.DEBUG_LEVEL, nArray);
        stringBuilder.append(ScilabInterpreterManagement.buildCall((String)"scicos_debug", (Object[])new Object[]{nArray[0]})).append("; ");
        stringBuilder.append("scs_m = scicos_new(\"0x").append(Long.toHexString(scicosObjectOwner.getUID())).append("\"); ");
        stringBuilder.append("cpr = xcos_compile(scs_m); ");
        String string = stringBuilder.toString();
        return string;
    }

    public void updateUI(boolean bl) {
        GraphActionManager.setEnable(StartAction.class, (!bl ? 1 : 0) != 0);
        ((XcosDiagram)this.getGraph(null)).setReadOnly(bl);
        if (bl) {
            ((XcosDiagram)this.getGraph(null)).info(XcosMessages.COMPILATION_IN_PROGRESS);
        } else {
            ((XcosDiagram)this.getGraph(null)).info(SMALL_ICON);
        }
    }
}

