/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.graph.utils.ScilabGraphRenderer;
import org.scilab.modules.gui.filechooser.FileChooser;
import org.scilab.modules.gui.filechooser.ScilabFileChooser;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.xcos.XcosTab;
import org.scilab.modules.xcos.configuration.ConfigurationManager;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.utils.XcosMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class ExportAction
extends DefaultAction {
    public static final String NAME = XcosMessages.EXPORT;
    public static final String SMALL_ICON = "";
    public static final int MNEMONIC_KEY = 69;
    public static final int ACCELERATOR_KEY = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String HTML = "html";
    private static final String VML = "vml";
    private static final String SVG = "svg";

    public ExportAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return ExportAction.createMenu((ScilabGraph)scilabGraph, ExportAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        XcosDiagram xcosDiagram = (XcosDiagram)this.getGraph(null);
        List<String> list = Arrays.asList(ImageIO.getWriterFileSuffixes());
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        treeSet.add(SVG);
        treeSet.add(HTML);
        treeSet.add(VML);
        treeSet.addAll(list);
        FileChooser fileChooser = ScilabFileChooser.createFileChooser();
        fileChooser.setTitle(XcosMessages.EXPORT);
        fileChooser.setUiDialogType(1);
        String[] stringArray = new String[treeSet.size()];
        treeSet.toArray(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "*." + stringArray[i];
        }
        fileChooser.addMask(stringArray, null);
        ConfigurationManager.configureCurrentDirectory(fileChooser);
        fileChooser.displayAndWait();
        String[] stringArray2 = fileChooser.getSelection();
        if (stringArray2.length != 0 && stringArray2[0] != SMALL_ICON) {
            String string = stringArray2[0];
            int n = string.lastIndexOf(46);
            String string2 = string.substring(n + 1);
            try {
                this.export(xcosDiagram, new File(string), string2);
            }
            catch (IOException iOException) {
                Logger.getLogger(ExportAction.class.getName()).severe(actionEvent.toString());
            }
        }
    }

    private void export(XcosDiagram xcosDiagram, File file, String string) throws IOException {
        if (string.equalsIgnoreCase(SVG)) {
            ScilabGraphRenderer.createSvgDocument((mxGraph)xcosDiagram, null, (double)1.0, null, null, (String)file.getCanonicalPath());
        } else if (string.equalsIgnoreCase(VML)) {
            Document document = mxCellRenderer.createVmlDocument((mxGraph)xcosDiagram, null, (double)1.0, null, null);
            if (document != null) {
                mxUtils.writeFile((String)mxXmlUtils.getXml((Node)document.getDocumentElement()), (String)file.getCanonicalPath());
            }
        } else if (string.equalsIgnoreCase(HTML)) {
            Document document = mxCellRenderer.createHtmlDocument((mxGraph)xcosDiagram, null, (double)1.0, null, null);
            if (document != null) {
                mxUtils.writeFile((String)mxXmlUtils.getXml((Node)document.getDocumentElement()), (String)file.getCanonicalPath());
            }
        } else {
            this.exportBufferedImage(xcosDiagram, file, string);
        }
    }

    private void exportBufferedImage(XcosDiagram xcosDiagram, File file, String string) throws IOException {
        BufferedImage bufferedImage;
        mxGraphComponent mxGraphComponent2 = xcosDiagram.getAsComponent();
        Color color = null;
        if (!string.equalsIgnoreCase("png") || ScilabModalDialog.show((SimpleTab)XcosTab.get(xcosDiagram), (String)XcosMessages.TRANSPARENT_BACKGROUND, (String)XcosMessages.XCOS, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO) != ScilabModalDialog.AnswerOption.YES_OPTION) {
            color = mxGraphComponent2.getBackground();
        }
        if ((bufferedImage = mxCellRenderer.createBufferedImage((mxGraph)xcosDiagram, null, (double)1.0, (Color)color, (boolean)mxGraphComponent2.isAntiAlias(), null, (mxGraphics2DCanvas)mxGraphComponent2.getCanvas())) != null) {
            ImageIO.write((RenderedImage)bufferedImage, string, file);
        } else {
            JOptionPane.showMessageDialog((Component)mxGraphComponent2, XcosMessages.NO_IMAGE_DATA);
        }
    }
}

