/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.gui.filechooser.FileChooser;
import org.scilab.modules.gui.filechooser.ScilabFileChooser;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.configuration.ConfigurationManager;
import org.scilab.modules.xcos.io.XcosFileType;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class OpenAction
extends DefaultAction {
    public static final String NAME = XcosMessages.OPEN;
    public static final String SMALL_ICON = "document-open";
    public static final int MNEMONIC_KEY = 79;
    public static final int ACCELERATOR_KEY = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public OpenAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return OpenAction.createMenu((ScilabGraph)scilabGraph, OpenAction.class);
    }

    public static JButton createButton(ScilabGraph scilabGraph) {
        return OpenAction.createButton((ScilabGraph)scilabGraph, OpenAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FileChooser fileChooser = OpenAction.createFileChooser();
        OpenAction.configureFileFilters(fileChooser);
        ConfigurationManager.configureCurrentDirectory(fileChooser);
        try {
            OpenAction.displayAndOpen(fileChooser, (Component)this.getGraph(actionEvent).getAsComponent());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static FileChooser createFileChooser() {
        FileChooser fileChooser = ScilabFileChooser.createFileChooser();
        fileChooser.setTitle(XcosMessages.OPEN);
        fileChooser.setUiDialogType(0);
        fileChooser.setMultipleSelection(true);
        return fileChooser;
    }

    public static void configureFileFilters(FileChooser fileChooser) {
        fileChooser.setAcceptAllFileFilterUsed(true);
        FileFilter[] fileFilterArray = XcosFileType.getLoadingFilters();
        String[] stringArray = new String[fileFilterArray.length];
        String[] stringArray2 = new String[fileFilterArray.length];
        for (int i = 0; i < fileFilterArray.length; ++i) {
            FileNameExtensionFilter fileNameExtensionFilter = (FileNameExtensionFilter)fileFilterArray[i];
            stringArray[i] = Arrays.stream(fileNameExtensionFilter.getExtensions()).map(string -> "*." + string).collect(Collectors.joining("|"));
            stringArray2[i] = fileNameExtensionFilter.getDescription();
        }
        fileChooser.addMask(stringArray, stringArray2);
    }

    protected static void displayAndOpen(FileChooser fileChooser, Component component) throws IOException {
        fileChooser.displayAndWait();
        String[] stringArray = fileChooser.getSelection();
        if (stringArray.length > 0 && stringArray[0] != "") {
            for (int i = 0; i < stringArray.length; ++i) {
                Xcos.getInstance().open(stringArray[i], 0L);
            }
        }
    }
}

