/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.gui.filechooser.FileChooser;
import org.scilab.modules.gui.filechooser.ScilabFileChooser;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.io.XcosFileType;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class SaveAsAction
extends DefaultAction {
    public static final String NAME = XcosMessages.SAVE_AS;
    public static final String SMALL_ICON = "document-save-as";
    public static final int MNEMONIC_KEY = 83;
    public static final int ACCELERATOR_KEY = 0x40 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public SaveAsAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return SaveAsAction.createMenu((ScilabGraph)scilabGraph, SaveAsAction.class);
    }

    public static JButton createButton(ScilabGraph scilabGraph) {
        return SaveAsAction.createButton((ScilabGraph)scilabGraph, SaveAsAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        XcosDiagram xcosDiagram = (XcosDiagram)this.getGraph(null);
        if (xcosDiagram.saveDiagramAs(null)) {
            xcosDiagram.setModified(false);
        }
    }

    public static FileChooser createFileChooser() {
        FileChooser fileChooser = ScilabFileChooser.createFileChooser();
        fileChooser.setTitle(XcosMessages.SAVE_AS);
        fileChooser.setUiDialogType(1);
        fileChooser.setMultipleSelection(false);
        return fileChooser;
    }

    public static void configureFileFilters(FileChooser fileChooser) {
        fileChooser.setAcceptAllFileFilterUsed(false);
        FileFilter[] fileFilterArray = XcosFileType.getSavingFilters();
        String[] stringArray = new String[fileFilterArray.length];
        String[] stringArray2 = new String[fileFilterArray.length];
        for (int i = 0; i < fileFilterArray.length; ++i) {
            FileNameExtensionFilter fileNameExtensionFilter = (FileNameExtensionFilter)fileFilterArray[i];
            stringArray[i] = Arrays.stream(fileNameExtensionFilter.getExtensions()).map(string -> "*." + string).collect(Collectors.joining("|"));
            stringArray2[i] = fileNameExtensionFilter.getDescription();
        }
        fileChooser.addMask(stringArray, stringArray2);
    }
}

