/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.Timer;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.graph.ScilabComponent;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.GraphActionManager;
import org.scilab.modules.graph.actions.base.OneBlockDependantAction;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.actions.StopAction;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class StartAction
extends OneBlockDependantAction {
    public static final String NAME = XcosMessages.START;
    public static final String SMALL_ICON = "media-playback-start";
    public static final int MNEMONIC_KEY = 0;
    public static final int ACCELERATOR_KEY = 0;
    private int counter;
    private Timer displayTimer;

    public StartAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
        this.setEnabled(GraphActionManager.getEnable(StartAction.class));
        char[] cArray = (XcosMessages.SIMULATION_IN_PROGRESS + "...").toCharArray();
        int n = XcosMessages.SIMULATION_IN_PROGRESS.length();
        this.counter = 0;
        this.displayTimer = new Timer(1000, actionEvent -> {
            this.counter = (this.counter + 1) % ("...".length() + 1);
            ((XcosDiagram)scilabGraph).info(new String(cArray, 0, n + this.counter));
        });
    }

    public static JButton createButton(ScilabGraph scilabGraph) {
        return StartAction.createButton((ScilabGraph)scilabGraph, StartAction.class);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return StartAction.createMenu((ScilabGraph)scilabGraph, StartAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        XcosDiagram xcosDiagram2 = (XcosDiagram)this.getGraph(actionEvent);
        ScilabComponent scilabComponent = (ScilabComponent)xcosDiagram2.getAsComponent();
        if (scilabComponent.isEditing()) {
            return;
        }
        ScicosObjectOwner scicosObjectOwner = Xcos.findRoot(xcosDiagram2);
        Xcos.getInstance().openedDiagrams(scicosObjectOwner).stream().forEach(xcosDiagram -> xcosDiagram.getAsComponent().clearCellOverlays());
        this.updateUI(true);
        this.displayTimer.start();
        String string = this.createSimulationCommand(scicosObjectOwner);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartAction.this.displayTimer.stop();
                StartAction.this.updateUI(false);
            }
        };
        try {
            ScilabInterpreterManagement.asynchronousScilabExec((ActionListener)actionListener, (String)string);
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
            Logger logger = Logger.getLogger(StartAction.class.getName());
            logger.warning(interpreterException.getMessage());
        }
    }

    private String createSimulationCommand(ScicosObjectOwner scicosObjectOwner) {
        StringBuilder stringBuilder = new StringBuilder();
        Logger logger = Logger.getLogger(StartAction.class.getName());
        logger.finest("start simulation");
        JavaController javaController = new JavaController();
        int[] nArray = new int[1];
        javaController.getObjectProperty(scicosObjectOwner.getUID(), scicosObjectOwner.getKind(), ObjectProperties.DEBUG_LEVEL, nArray);
        stringBuilder.append(ScilabInterpreterManagement.buildCall((String)"scicos_debug", (Object[])new Object[]{nArray[0]})).append("; ");
        stringBuilder.append("scs_m = scicos_new(\"0x").append(Long.toHexString(scicosObjectOwner.getUID())).append("\"); ");
        stringBuilder.append("xcos_simulate(scs_m, 4); ");
        String string = stringBuilder.toString();
        return string;
    }

    public void updateUI(boolean bl) {
        GraphActionManager.setEnable(StartAction.class, (!bl ? 1 : 0) != 0);
        GraphActionManager.setEnable(StopAction.class, (boolean)false);
        ((XcosDiagram)this.getGraph(null)).setReadOnly(bl);
        if (bl) {
            ((XcosDiagram)this.getGraph(null)).info(XcosMessages.SIMULATION_IN_PROGRESS);
        } else {
            ((XcosDiagram)this.getGraph(null)).info("");
        }
    }
}

