/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.block.actions;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxRectangle;
import java.awt.event.ActionEvent;
import java.nio.LongBuffer;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.graph.ScilabComponent;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.VertexSelectionDependantAction;
import org.scilab.modules.graph.utils.StyleMap;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfScicosID;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.block.SuperBlock;
import org.scilab.modules.xcos.block.io.ContextUpdate;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.graph.model.XcosCellFactory;
import org.scilab.modules.xcos.link.BasicLink;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.port.control.ControlPort;
import org.scilab.modules.xcos.port.input.InputPort;
import org.scilab.modules.xcos.port.output.OutputPort;
import org.scilab.modules.xcos.utils.BlockPositioning;
import org.scilab.modules.xcos.utils.XcosConstants;
import org.scilab.modules.xcos.utils.XcosMessages;

public class RegionToSuperblockAction
extends VertexSelectionDependantAction {
    public static final String NAME = XcosMessages.REGION_TO_SUPERBLOCK;
    public static final String SMALL_ICON = "object-group";
    public static final int MNEMONIC_KEY = 0;
    public static final int ACCELERATOR_KEY = 0;
    private static final String INTERFUNCTION_NAME = "SUPER_f";

    public RegionToSuperblockAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return RegionToSuperblockAction.createMenu((ScilabGraph)scilabGraph, RegionToSuperblockAction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        XcosDiagram xcosDiagram = (XcosDiagram)this.getGraph(actionEvent);
        ScilabComponent scilabComponent = (ScilabComponent)xcosDiagram.getAsComponent();
        if (scilabComponent.isEditing()) {
            return;
        }
        xcosDiagram.info(XcosMessages.GENERATE_SUPERBLOCK);
        xcosDiagram.getModel().beginUpdate();
        try {
            JavaController javaController = new JavaController();
            Object[] objectArray = xcosDiagram.getSelectionCells();
            List<XcosCell> list = Arrays.stream(objectArray).filter(object -> object instanceof XcosCell).map(object -> (XcosCell)((Object)((Object)object))).collect(Collectors.toList());
            SuperBlock superBlock = this.allocateSuperBlock(javaController, xcosDiagram, objectArray);
            Collection<Broken> collection = this.updateParent(javaController, xcosDiagram, superBlock, list);
            this.moveToChild(javaController, xcosDiagram, superBlock, collection, list);
            BlockPositioning.updateBlockView(xcosDiagram, superBlock);
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
        }
        finally {
            xcosDiagram.getModel().endUpdate();
            xcosDiagram.info("");
        }
    }

    private SuperBlock allocateSuperBlock(JavaController javaController, XcosDiagram xcosDiagram, Object[] objectArray) throws ScilabInterpreterManagement.InterpreterException {
        Object object;
        SuperBlock superBlock = (SuperBlock)XcosCellFactory.createBlock(INTERFUNCTION_NAME);
        while (superBlock.getChildCount() > 0) {
            superBlock.remove(superBlock.getChildCount() - 1);
        }
        VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
        javaController.setObjectProperty(superBlock.getUID(), superBlock.getKind(), ObjectProperties.CHILDREN, vectorOfScicosID);
        mxRectangle mxRectangle2 = xcosDiagram.getBoundingBoxFromGeometry(objectArray);
        try {
            double d = mxRectangle2.getX();
            double d2 = d + mxRectangle2.getWidth();
            double d3 = mxRectangle2.getY();
            double d4 = d3 + mxRectangle2.getHeight();
            object = superBlock.getGeometry();
            object.setX((d2 + d - object.getWidth()) / 2.0);
            object.setY((d4 + d3 - object.getHeight()) / 2.0);
            superBlock.setGeometry((mxGeometry)object);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        VectorOfDouble vectorOfDouble = new VectorOfDouble();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Object object2 : objectArray) {
            if (!(object2 instanceof BasicBlock)) continue;
            object = (BasicBlock)object2;
            String[] stringArray = new String[1];
            javaController.getObjectProperty(((XcosCell)((Object)object)).getUID(), Kind.BLOCK, ObjectProperties.STYLE, stringArray);
            StyleMap styleMap = new StyleMap(stringArray[0]);
            boolean bl = Boolean.TRUE.toString().equals(styleMap.get((Object)"mirror"));
            boolean bl2 = Boolean.TRUE.toString().equals(styleMap.get((Object)"flip"));
            int n4 = Double.valueOf((String)styleMap.getOrDefault((Object)XcosConstants.STYLE_ROTATION, (Object)"0")).intValue();
            n += n4;
            if (bl2) {
                ++n2;
            }
            if (!bl) continue;
            ++n3;
        }
        int n5 = objectArray.length / 2;
        String[] stringArray = new String[1];
        javaController.getObjectProperty(superBlock.getUID(), superBlock.getKind(), ObjectProperties.STYLE, stringArray);
        StyleMap styleMap = new StyleMap(stringArray[0]);
        styleMap.put((Object)XcosConstants.STYLE_ROTATION, (Object)Integer.toString(BlockPositioning.roundAngle(n / objectArray.length)));
        if (n2 > n5) {
            styleMap.put((Object)"flip", (Object)Boolean.toString(true));
        }
        if (n3 > n5) {
            styleMap.put((Object)"mirror", (Object)Boolean.toString(true));
        }
        javaController.setObjectProperty(superBlock.getUID(), superBlock.getKind(), ObjectProperties.STYLE, styleMap.toString());
        return superBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Broken> updateParent(JavaController javaController, XcosDiagram xcosDiagram, SuperBlock superBlock, List<XcosCell> list) {
        TreeSet<Broken> treeSet;
        mxGraphModel mxGraphModel2 = (mxGraphModel)xcosDiagram.getModel();
        mxGraphModel2.beginUpdate();
        try {
            treeSet = new TreeSet<Broken>();
            this.fillLinks(xcosDiagram, mxGraphModel2, list, treeSet);
            for (Broken object : treeSet) {
                mxGraphModel.setTerminals((mxIGraphModel)mxGraphModel2, (Object)((Object)object.getParentLink()), null, null);
            }
            xcosDiagram.addCell(superBlock);
            Object object = new int[]{0, 0, 0, 0};
            for (Broken broken : treeSet) {
                this.incrementOrdering(javaController, (int[])object, broken);
                this.connectParent(xcosDiagram, mxGraphModel2, superBlock, broken);
                this.connectChild(xcosDiagram, mxGraphModel2, broken);
                BlockPositioning.updateBlockView(xcosDiagram, broken.getChildBlock());
            }
        }
        finally {
            mxGraphModel2.endUpdate();
        }
        return treeSet;
    }

    private void fillLinks(XcosDiagram xcosDiagram, mxGraphModel mxGraphModel2, Collection<XcosCell> collection, Collection<Broken> collection2) {
        LinkedList<XcosCell> linkedList = new LinkedList<XcosCell>(collection);
        while (!linkedList.isEmpty()) {
            Object e = linkedList.remove();
            int n = mxGraphModel2.getChildCount(e);
            for (int i = 0; i < n; ++i) {
                Object object = mxGraphModel2.getChildAt(e, i);
                int n2 = mxGraphModel2.getEdgeCount(object);
                for (int j = 0; j < n2; ++j) {
                    Object object2 = mxGraphModel2.getEdgeAt(object, j);
                    Object object3 = mxGraphModel2.getTerminal(object2, true);
                    Object object4 = mxGraphModel2.getTerminal(object2, false);
                    boolean bl = collection.contains(mxGraphModel2.getParent(object3));
                    boolean bl2 = collection.contains(mxGraphModel2.getParent(object4));
                    if (bl && bl2 && object2 instanceof XcosCell) {
                        collection.add((XcosCell)((Object)object2));
                        continue;
                    }
                    if (bl) {
                        collection2.add(new Broken(xcosDiagram, mxGraphModel2, (BasicPort)((Object)object3), (BasicPort)((Object)object4), (BasicLink)((Object)object2), true));
                        continue;
                    }
                    if (!bl2) continue;
                    collection2.add(new Broken(xcosDiagram, mxGraphModel2, (BasicPort)((Object)object3), (BasicPort)((Object)object4), (BasicLink)((Object)object2), false));
                }
            }
        }
    }

    private void incrementOrdering(JavaController javaController, int[] nArray, Broken broken) {
        if (broken.getTerminal() instanceof InputPort) {
            nArray[0] = nArray[0] + 1;
            broken.getChildBlock().setOrdering(javaController, nArray[0]);
        } else if (broken.getTerminal() instanceof OutputPort) {
            nArray[1] = nArray[1] + 1;
            broken.getChildBlock().setOrdering(javaController, nArray[1]);
        } else if (broken.getTerminal() instanceof ControlPort) {
            nArray[2] = nArray[2] + 1;
            broken.getChildBlock().setOrdering(javaController, nArray[2]);
        } else {
            nArray[3] = nArray[3] + 1;
            broken.getChildBlock().setOrdering(javaController, nArray[3]);
        }
    }

    private void connectParent(XcosDiagram xcosDiagram, mxGraphModel mxGraphModel2, SuperBlock superBlock, Broken broken) {
        xcosDiagram.addCell((Object)broken.getParentPort(), superBlock);
        xcosDiagram.addCell((Object)broken.getParentLink());
        mxICell mxICell2 = broken.getParentTerminal(true);
        mxICell mxICell3 = broken.getParentTerminal(false);
        mxGraphModel.setTerminals((mxIGraphModel)mxGraphModel2, (Object)((Object)broken.getParentLink()), (Object)mxICell2, (Object)mxICell3);
    }

    private void connectChild(XcosDiagram xcosDiagram, mxGraphModel mxGraphModel2, Broken broken) {
        xcosDiagram.addCell(broken.getChildBlock());
        xcosDiagram.addCell((Object)broken.getChildLink());
        mxICell mxICell2 = broken.getChildTerminal(true);
        mxICell mxICell3 = broken.getChildTerminal(false);
        mxGraphModel.setTerminals((mxIGraphModel)mxGraphModel2, (Object)((Object)broken.getChildLink()), (Object)mxICell2, (Object)mxICell3);
    }

    private void moveToChild(JavaController javaController, XcosDiagram xcosDiagram, SuperBlock superBlock, Collection<Broken> collection, List<XcosCell> list) {
        Comparable<Broken> comparable2;
        ArrayList<XcosCell> arrayList = new ArrayList<XcosCell>();
        arrayList.addAll(list);
        for (Comparable<Broken> comparable2 : collection) {
            arrayList.add(comparable2.getChildBlock());
            arrayList.add(comparable2.getChildLink());
        }
        xcosDiagram.removeCells(arrayList.toArray(), false);
        VectorOfScicosID vectorOfScicosID = new VectorOfScicosID(arrayList.size());
        comparable2 = vectorOfScicosID.asByteBuffer(0, arrayList.size()).asLongBuffer();
        long l = superBlock.getUID();
        long l2 = xcosDiagram.getKind() == Kind.DIAGRAM ? xcosDiagram.getUID() : xcosDiagram.getRootDiagramUID(javaController);
        arrayList.stream().forEach(arg_0 -> RegionToSuperblockAction.lambda$moveToChild$2((LongBuffer)comparable2, javaController, l, l2, arg_0));
        javaController.setObjectProperty(superBlock.getUID(), superBlock.getKind(), ObjectProperties.CHILDREN, vectorOfScicosID);
    }

    private static /* synthetic */ void lambda$moveToChild$2(LongBuffer longBuffer, JavaController javaController, long l, long l2, XcosCell xcosCell) {
        longBuffer.put(xcosCell.getUID());
        javaController.referenceObject(xcosCell.getUID());
        javaController.setObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.PARENT_BLOCK, l);
        javaController.setObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.PARENT_DIAGRAM, l2);
    }

    private static final class Broken
    implements Comparable<Broken> {
        private final mxGraphModel parentModel;
        private final BasicPort source;
        private final BasicPort target;
        private final BasicLink parentLink;
        private final boolean containsSource;
        private final double x;
        private final double y;
        private BasicLink childLink;
        private BasicPort parentPort;
        private ContextUpdate childBlock;

        public Broken(XcosDiagram xcosDiagram, mxGraphModel mxGraphModel2, BasicPort basicPort, BasicPort basicPort2, BasicLink basicLink, boolean bl) {
            this.parentModel = mxGraphModel2;
            this.source = basicPort;
            this.target = basicPort2;
            this.parentLink = basicLink;
            this.containsSource = bl;
            BasicPort basicPort3 = bl ? basicPort2 : basicPort;
            mxGeometry mxGeometry2 = mxGraphModel2.getGeometry((Object)basicPort3);
            mxGeometry mxGeometry3 = mxGraphModel2.getGeometry(mxGraphModel2.getParent((Object)basicPort3));
            if (mxGeometry2 != null && mxGeometry3 != null) {
                this.x = xcosDiagram.snap(mxGeometry2.getX() + mxGeometry3.getX() - mxGeometry2.getHeight() / 2.0);
                this.y = xcosDiagram.snap(mxGeometry2.getY() + mxGeometry3.getY() - mxGeometry2.getWidth() / 2.0);
            } else {
                this.x = 0.0;
                this.y = 0.0;
            }
        }

        public BasicLink getParentLink() {
            return this.parentLink;
        }

        public mxICell getParentTerminal(boolean bl) {
            BasicPort basicPort = this.containsSource ? (bl ? this.getParentPort() : this.target) : (bl ? this.source : this.getParentPort());
            return basicPort;
        }

        public mxICell getChildTerminal(boolean bl) {
            Object object = this.containsSource ? (bl ? this.source : this.getChildBlock().getChildAt(0)) : (bl ? this.getChildBlock().getChildAt(0) : this.target);
            return object;
        }

        public BasicPort getTerminal() {
            if (this.containsSource) {
                return this.source;
            }
            return this.target;
        }

        public BasicLink getChildLink() {
            if (this.childLink == null) {
                this.childLink = (BasicLink)((Object)this.parentModel.cloneCells(new Object[]{this.parentLink}, true)[0]);
            }
            return this.childLink;
        }

        public BasicPort getParentPort() {
            if (this.parentPort == null) {
                JavaController javaController = new JavaController();
                long l = javaController.createObject(Kind.PORT);
                try {
                    this.parentPort = this.containsSource ? ContextUpdate.IOBlocks.getOpposite(((Object)((Object)this.target)).getClass()).getConstructor(JavaController.class, Long.TYPE, Kind.class, Object.class, String.class, String.class).newInstance(new Object[]{javaController, l, Kind.PORT, null, null, new UID().toString()}) : ContextUpdate.IOBlocks.getOpposite(((Object)((Object)this.source)).getClass()).getConstructor(JavaController.class, Long.TYPE, Kind.class, Object.class, String.class, String.class).newInstance(new Object[]{javaController, l, Kind.PORT, null, null, new UID().toString()});
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    Logger.getLogger(RegionToSuperblockAction.class.getName()).severe(reflectiveOperationException.toString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logger.getLogger(RegionToSuperblockAction.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
                }
            }
            return this.parentPort;
        }

        public ContextUpdate getChildBlock() {
            if (this.childBlock == null) {
                BasicPort basicPort = this.getTerminal();
                this.childBlock = ContextUpdate.IOBlocks.createBlock(basicPort);
                try {
                    mxGeometry mxGeometry2 = this.childBlock.getGeometry();
                    mxGeometry2.setX(this.x);
                    mxGeometry2.setY(this.y);
                    this.childBlock.setGeometry(mxGeometry2);
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                }
            }
            return this.childBlock;
        }

        @Override
        public int compareTo(Broken broken) {
            int n = (int)(this.x - broken.x);
            int n2 = (int)(this.y - broken.y);
            if (n == 0 && n2 == 0) {
                return this.hashCode() - broken.hashCode();
            }
            return (n2 << 16) + n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getParentLink().getChildCount() > 0) {
                stringBuilder.append(this.getParentLink().getChildAt(0).getValue());
                stringBuilder.append(": ");
            }
            stringBuilder.append(this.getParentTerminal(true));
            stringBuilder.append(" -> ");
            stringBuilder.append(this.getParentTerminal(false));
            stringBuilder.append('\n');
            if (this.getChildLink().getChildCount() > 0) {
                stringBuilder.append(this.getChildLink().getChildAt(0).getValue());
                stringBuilder.append(": ");
            }
            stringBuilder.append(this.getChildTerminal(true));
            stringBuilder.append(" -> ");
            stringBuilder.append(this.getChildTerminal(false));
            return stringBuilder.toString();
        }
    }
}

