/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.scicos;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxPoint;
import java.lang.reflect.Constructor;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabMList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.io.scicos.AbstractElement;
import org.scilab.modules.xcos.io.scicos.BasicBlockInfo;
import org.scilab.modules.xcos.io.scicos.ScicosFormatException;
import org.scilab.modules.xcos.link.BasicLink;
import org.scilab.modules.xcos.link.LinkPortMap;
import org.scilab.modules.xcos.port.BasicPort;

public final class LinkElement
extends AbstractElement<BasicLink> {
    protected static final List<String> DATA_FIELD_NAMES = Arrays.asList("Link", "xx", "yy", "id", "thick", "ct", "from", "to");
    private static final int XX_INDEX = DATA_FIELD_NAMES.indexOf("xx");
    private static final int YY_INDEX = DATA_FIELD_NAMES.indexOf("yy");
    private static final int CT_INDEX = DATA_FIELD_NAMES.indexOf("ct");
    private static final int FROM_INDEX = DATA_FIELD_NAMES.indexOf("from");
    private static final int TO_INDEX = DATA_FIELD_NAMES.indexOf("to");
    private static final Logger LOG = Logger.getLogger(LinkElement.class.getName());
    private ScilabMList data;
    private BasicPort start;
    private BasicPort end;
    private final Map<Integer, BasicBlock> blocks;

    public LinkElement(JavaController javaController, Map<Integer, BasicBlock> map) {
        super(javaController);
        this.blocks = map;
    }

    @Override
    public BasicLink decode(ScilabType scilabType, BasicLink basicLink) throws ScicosFormatException {
        this.data = (ScilabMList)scilabType;
        BasicLink basicLink2 = basicLink;
        this.validate();
        if (basicLink == null) {
            basicLink2 = this.allocateLink();
        }
        basicLink2 = this.beforeDecode(scilabType, basicLink2);
        this.searchForPorts(basicLink2);
        List<mxPoint> list = this.getPoints();
        basicLink2.setTerminal((mxICell)this.start, true);
        basicLink2.setTerminal((mxICell)this.end, false);
        mxGeometry mxGeometry2 = basicLink2.getGeometry();
        if (mxGeometry2 == null) {
            mxGeometry2 = new mxGeometry();
        }
        mxGeometry2.setPoints(list);
        basicLink2.setGeometry(mxGeometry2);
        basicLink2 = this.afterDecode(scilabType, basicLink2);
        return basicLink2;
    }

    private BasicLink allocateLink() {
        BasicLink basicLink = null;
        int n = (int)((ScilabDouble)this.data.get(CT_INDEX)).getRealPart()[0][1];
        String string = new UID().toString();
        try {
            Class<? extends BasicLink> clazz = LinkPortMap.getLinkClass(n);
            Constructor<? extends BasicLink> constructor = clazz.getConstructor(JavaController.class, Long.TYPE, Kind.class, Object.class, mxGeometry.class, String.class, String.class);
            basicLink = constructor.newInstance(new Object[]{this.controller, this.controller.createObject(Kind.LINK), Kind.LINK, null, null, null, string});
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            LOG.severe(reflectiveOperationException.toString());
        }
        return basicLink;
    }

    private List<mxPoint> getPoints() {
        int n;
        boolean bl;
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>();
        double[][] dArray = ((ScilabDouble)this.data.get(XX_INDEX)).getRealPart();
        double[][] dArray2 = ((ScilabDouble)this.data.get(YY_INDEX)).getRealPart();
        boolean bl2 = bl = ((ScilabType)this.data.get(XX_INDEX)).getHeight() >= ((ScilabType)this.data.get(XX_INDEX)).getWidth();
        if (this.start == null || this.end == null) {
            return arrayList;
        }
        int[] nArray = new int[]{0, 0};
        if (bl) {
            n = ((ScilabType)this.data.get(1)).getHeight() - 1;
            nArray[0] = 1;
        } else {
            n = ((ScilabType)this.data.get(1)).getWidth() - 1;
            nArray[1] = 1;
        }
        for (int i = 1; i < n; ++i) {
            double d = dArray[nArray[0]][nArray[1]];
            double d2 = dArray2[nArray[0]][nArray[1]];
            d2 = -d2;
            arrayList.add(new mxPoint(d, d2));
            LinkElement.incrementIndexes(nArray, bl);
        }
        return arrayList;
    }

    private void searchForPorts(BasicLink basicLink) {
        ScilabDouble scilabDouble = (ScilabDouble)this.data.get(FROM_INDEX);
        ScilabDouble scilabDouble2 = (ScilabDouble)this.data.get(TO_INDEX);
        double[][] dArray = scilabDouble.getRealPart();
        double[][] dArray2 = scilabDouble2.getRealPart();
        int[] nArray = new int[]{0, 0};
        boolean bl = scilabDouble.getHeight() >= scilabDouble.getWidth();
        int n = (int)dArray[nArray[0]][nArray[1]];
        int n2 = (int)dArray2[nArray[0]][nArray[1]];
        BasicBlock basicBlock = this.blocks.get(n - 1);
        BasicBlock basicBlock2 = this.blocks.get(n2 - 1);
        LinkElement.incrementIndexes(nArray, bl);
        int n3 = (int)dArray[nArray[0]][nArray[1]];
        if (n3 == 0) {
            LOG.severe("Link has an invalid start port");
            LOG.severe(this.data.toString());
            return;
        }
        int n4 = (int)dArray2[nArray[0]][nArray[1]];
        if (n4 == 0) {
            LOG.severe("Link has an invalid end port");
            LOG.severe(this.data.toString());
            return;
        }
        LinkElement.incrementIndexes(nArray, bl);
        boolean bl2 = LinkElement.canGet((ScilabType)scilabDouble, nArray) ? dArray[nArray[0]][nArray[1]] == 0.0 : true;
        boolean bl3 = LinkElement.canGet((ScilabType)scilabDouble2, nArray) ? dArray2[nArray[0]][nArray[1]] == 0.0 : false;
        List<BasicPort> list = BasicBlockInfo.getAllPortsAtPosition(basicBlock, n3);
        List<BasicPort> list2 = BasicBlockInfo.getAllPortsAtPosition(basicBlock2, n4);
        this.lookForOrderedPorts(basicLink, list, bl2, list2, bl3);
        if (this.start == null || this.end == null) {
            if (LOG.isLoggable(Level.FINEST)) {
                int n5;
                BasicBlock basicBlock3;
                if (this.start == null) {
                    basicBlock3 = basicBlock;
                    n5 = n3;
                } else {
                    basicBlock3 = basicBlock2;
                    n5 = n4;
                }
                if (basicBlock3 != null) {
                    String[] stringArray = new String[1];
                    this.controller.getObjectProperty(basicBlock3.getUID(), basicBlock3.getKind(), ObjectProperties.SIM_FUNCTION_NAME, stringArray);
                    LOG.warning("Unable to get " + stringArray[0] + "[" + n5 + "]" + basicBlock3.toString());
                } else {
                    return;
                }
            }
            this.lookForOrderedPorts(basicLink, list, !bl2, list2, !bl3);
            if (this.start != null && this.end != null) {
                return;
            }
            this.lookForOrderedPorts(basicLink, list, bl2, list2, !bl3);
            if (this.start != null && this.end != null) {
                return;
            }
            this.lookForOrderedPorts(basicLink, list, !bl2, list2, bl3);
            if (this.start != null && this.end != null) {
                return;
            }
        }
    }

    private void lookForOrderedPorts(BasicLink basicLink, List<BasicPort> list, boolean bl, List<BasicPort> list2, boolean bl2) {
        Class<? extends BasicPort> clazz = LinkPortMap.getPortClass(((Object)((Object)basicLink)).getClass(), bl);
        Class<? extends BasicPort> clazz2 = LinkPortMap.getPortClass(((Object)((Object)basicLink)).getClass(), bl2);
        this.start = null;
        this.end = null;
        for (BasicPort basicPort : list) {
            if (!clazz.isInstance((Object)basicPort)) continue;
            if (basicPort.getEdgeCount() != 0) break;
            this.start = basicPort;
            break;
        }
        for (BasicPort basicPort : list2) {
            if (!clazz2.isInstance((Object)basicPort)) continue;
            if (basicPort.getEdgeCount() != 0) break;
            this.end = basicPort;
            break;
        }
    }

    private void validate() throws ScicosFormatException {
        if (!this.canDecode((ScilabType)this.data)) {
            throw new ScicosFormatException.WrongElementException();
        }
        int n = 0;
        if (this.data.size() != DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        String[] stringArray = ((ScilabString)this.data.get(n)).getData()[0];
        if (stringArray.length != DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(DATA_FIELD_NAMES.get(i))) continue;
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
    }

    @Override
    public boolean canDecode(ScilabType scilabType) {
        this.data = (ScilabMList)scilabType;
        String string = ((ScilabString)this.data.get(0)).getData()[0][0];
        return string.equals(DATA_FIELD_NAMES.get(0));
    }
}

