/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.scicos;

import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabTList;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfString;
import org.scilab.modules.xcos.graph.ScicosParameters;
import org.scilab.modules.xcos.io.scicos.AbstractElement;
import org.scilab.modules.xcos.io.scicos.ScicosFormatException;

public final class ScicosParametersElement
extends AbstractElement<ScicosParameters> {
    protected static final List<String> DATA_FIELD_NAMES = Arrays.asList("params", "wpar", "title", "tol", "tf", "context", "void1", "options", "void2", "void3", "doc");
    private static final int TOL_INDEX = DATA_FIELD_NAMES.indexOf("tol");
    private static final int TF_INDEX = DATA_FIELD_NAMES.indexOf("tf");
    private static final int CONTEXT_INDEX = DATA_FIELD_NAMES.indexOf("context");
    private static final int TOL_SIZE = 7;
    private ScilabTList data;

    public ScicosParametersElement(JavaController javaController) {
        super(javaController);
    }

    @Override
    public ScicosParameters decode(ScilabType scilabType, ScicosParameters scicosParameters) throws ScicosFormatException {
        this.data = (ScilabTList)scilabType;
        ScicosParameters scicosParameters2 = scicosParameters;
        this.validate();
        scicosParameters2 = this.beforeDecode(scilabType, scicosParameters2);
        if (scicosParameters2.getCurrent().getKind() == Kind.DIAGRAM) {
            this.fillWithThirdFields(scicosParameters2);
            try {
                double d = ((ScilabDouble)this.data.get(TF_INDEX)).getRealPart()[0][0];
                VectorOfDouble vectorOfDouble = scicosParameters2.getProperties(this.controller);
                vectorOfDouble.set(0, d);
                scicosParameters2.setProperties(this.controller, vectorOfDouble);
            }
            catch (PropertyVetoException propertyVetoException) {
                Logger.getLogger(ScicosParametersElement.class.getName()).severe(propertyVetoException.toString());
            }
        }
        this.fillContext(scicosParameters2);
        scicosParameters2 = this.afterDecode(scilabType, scicosParameters2);
        return scicosParameters2;
    }

    private void validate() throws ScicosFormatException {
        if (!this.canDecode((ScilabType)this.data)) {
            throw new ScicosFormatException.WrongElementException();
        }
        int n = 0;
        if (this.data.size() != DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        String[] stringArray = ((ScilabString)this.data.get(n)).getData()[0];
        if (stringArray.length != DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(DATA_FIELD_NAMES.get(i))) continue;
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabString) && !ScicosParametersElement.isEmptyField((ScilabType)this.data.get(n))) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!ScicosParametersElement.isEmptyField((ScilabType)this.data.get(++n))) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabTList)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!ScicosParametersElement.isEmptyField((ScilabType)this.data.get(++n))) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!ScicosParametersElement.isEmptyField((ScilabType)this.data.get(++n))) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabList) && !ScicosParametersElement.isEmptyField((ScilabType)this.data.get(n))) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
    }

    private void fillWithThirdFields(ScicosParameters scicosParameters) {
        boolean bl = ((ScilabType)this.data.get(TOL_INDEX)).getHeight() >= ((ScilabType)this.data.get(TOL_INDEX)).getWidth();
        double[][] dArray = ((ScilabDouble)this.data.get(TOL_INDEX)).getRealPart();
        int[] nArray = new int[]{0, 0};
        VectorOfDouble vectorOfDouble = scicosParameters.getProperties(this.controller);
        vectorOfDouble.set(1, dArray[nArray[0]][nArray[1]]);
        ScicosParametersElement.incrementIndexes(nArray, bl);
        vectorOfDouble.set(2, dArray[nArray[0]][nArray[1]]);
        ScicosParametersElement.incrementIndexes(nArray, bl);
        vectorOfDouble.set(3, dArray[nArray[0]][nArray[1]]);
        ScicosParametersElement.incrementIndexes(nArray, bl);
        vectorOfDouble.set(4, dArray[nArray[0]][nArray[1]]);
        ScicosParametersElement.incrementIndexes(nArray, bl);
        vectorOfDouble.set(5, dArray[nArray[0]][nArray[1]]);
        ScicosParametersElement.incrementIndexes(nArray, bl);
        vectorOfDouble.set(6, dArray[nArray[0]][nArray[1]]);
        ScicosParametersElement.incrementIndexes(nArray, bl);
        try {
            vectorOfDouble.set(7, dArray[nArray[0]][nArray[1]]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            scicosParameters.setProperties(this.controller, vectorOfDouble);
        }
        catch (PropertyVetoException propertyVetoException) {
            Logger.getLogger(ScicosParametersElement.class.getName()).severe(propertyVetoException.toString());
        }
    }

    private void fillContext(ScicosParameters scicosParameters) {
        ScilabType scilabType = (ScilabType)this.data.get(CONTEXT_INDEX);
        if (scilabType instanceof ScilabDouble) {
            return;
        }
        boolean bl = scilabType.getHeight() >= scilabType.getWidth();
        String[][] stringArray = ((ScilabString)scilabType).getData();
        int n = scilabType.getHeight() + scilabType.getWidth() - 1;
        VectorOfString vectorOfString = new VectorOfString(n);
        int[] nArray = new int[]{0, 0};
        for (int i = 0; i < n; ++i) {
            vectorOfString.set(i, stringArray[nArray[0]][nArray[1]]);
            ScicosParametersElement.incrementIndexes(nArray, bl);
        }
        try {
            scicosParameters.setContext(this.controller, vectorOfString);
        }
        catch (PropertyVetoException propertyVetoException) {
            Logger.getLogger(ScicosParametersElement.class.getName()).severe(propertyVetoException.toString());
        }
    }

    @Override
    public boolean canDecode(ScilabType scilabType) {
        this.data = (ScilabTList)scilabType;
        String string = ((ScilabString)this.data.get(0)).getData()[0][0];
        return string.equals(DATA_FIELD_NAMES.get(0));
    }
}

