/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.writer;

import javax.xml.stream.XMLStreamException;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.io.writer.ScilabWriter;
import org.scilab.modules.xcos.io.writer.XcosWriter;

public class JGraphXWriter
extends ScilabWriter {
    public JGraphXWriter(XcosWriter xcosWriter) {
        super(xcosWriter);
    }

    @Override
    public void write(long l, Kind kind) throws XMLStreamException {
        VectorOfDouble vectorOfDouble = new VectorOfDouble();
        switch (kind) {
            case ANNOTATION: 
            case BLOCK: {
                this.shared.controller.getObjectProperty(l, kind, ObjectProperties.GEOMETRY, vectorOfDouble);
                this.shared.stream.writeEmptyElement("mxGeometry");
                this.shared.stream.writeAttribute("as", "geometry");
                this.shared.stream.writeAttribute("x", Double.toString(vectorOfDouble.get(0)));
                this.shared.stream.writeAttribute("y", Double.toString(vectorOfDouble.get(1)));
                this.shared.stream.writeAttribute("width", Double.toString(vectorOfDouble.get(2)));
                this.shared.stream.writeAttribute("height", Double.toString(vectorOfDouble.get(3)));
                break;
            }
            case LINK: {
                this.shared.controller.getObjectProperty(l, kind, ObjectProperties.CONTROL_POINTS, vectorOfDouble);
                int n = 0;
                int n2 = vectorOfDouble.size() / 2;
                this.shared.stream.writeStartElement("mxGeometry");
                this.shared.stream.writeAttribute("as", "geometry");
                if (n < n2) {
                    this.shared.stream.writeEmptyElement("mxPoint");
                    this.shared.stream.writeAttribute("as", "sourcePoint");
                    this.shared.stream.writeAttribute("x", Double.toString(vectorOfDouble.get(2 * n)));
                    this.shared.stream.writeAttribute("y", Double.toString(vectorOfDouble.get(2 * n + 1)));
                    ++n;
                }
                this.shared.stream.writeStartElement("Array");
                this.shared.stream.writeAttribute("as", "points");
                while (n < n2 - 1) {
                    this.shared.stream.writeEmptyElement("mxPoint");
                    this.shared.stream.writeAttribute("x", Double.toString(vectorOfDouble.get(2 * n)));
                    this.shared.stream.writeAttribute("y", Double.toString(vectorOfDouble.get(2 * n + 1)));
                    ++n;
                }
                this.shared.stream.writeEndElement();
                if (n < n2) {
                    this.shared.stream.writeEmptyElement("mxPoint");
                    this.shared.stream.writeAttribute("as", "targetPoint");
                    this.shared.stream.writeAttribute("x", Double.toString(vectorOfDouble.get(2 * n)));
                    this.shared.stream.writeAttribute("y", Double.toString(vectorOfDouble.get(2 * n + 1)));
                }
                this.shared.stream.writeEndElement();
                break;
            }
        }
    }
}

