/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.writer;

import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.io.writer.BlockWriter;
import org.scilab.modules.xcos.io.writer.CustomWriter;
import org.scilab.modules.xcos.io.writer.LinkWriter;
import org.scilab.modules.xcos.io.writer.RawDataWriter;
import org.scilab.modules.xcos.utils.Stack;

public class XcosWriter {
    protected static final Logger LOG = Logger.getLogger("org.scilab.modules.xcos.io.writer");
    protected final JavaController controller = new JavaController();
    protected final ScilabList dictionary;
    protected final RawDataWriter rawDataWriter;
    protected final XMLStreamWriter stream;
    protected final Stack<String> layers;
    protected final HashSet<String> uniqueUIDs;

    public XcosWriter(ScilabList scilabList, XMLStreamWriter xMLStreamWriter) {
        this.dictionary = scilabList;
        this.rawDataWriter = new RawDataWriter(this);
        this.stream = xMLStreamWriter;
        this.layers = new Stack();
        this.uniqueUIDs = new HashSet();
    }

    public void write(long l, Kind kind) throws XMLStreamException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering(XcosWriter.class.getName(), "write");
        }
        switch (kind) {
            case ANNOTATION: 
            case BLOCK: {
                new BlockWriter(this).write(l, kind);
                break;
            }
            case DIAGRAM: {
                new CustomWriter(this).write(l, kind);
                break;
            }
            case LINK: {
                new LinkWriter(this).write(l, kind);
                break;
            }
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.exiting(XcosWriter.class.getName(), "write");
        }
    }
}

