/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette;

import com.mxgraph.swing.util.mxGraphTransferable;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.palette.PaletteCtrl;
import org.scilab.modules.xcos.palette.listener.PaletteBlockKeyListener;
import org.scilab.modules.xcos.palette.listener.PaletteBlockMouseListener;
import org.scilab.modules.xcos.palette.listener.PaletteDragGestureListener;
import org.scilab.modules.xcos.palette.model.PaletteBlock;
import org.scilab.modules.xcos.palette.view.PaletteBlockView;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;

public final class PaletteBlockCtrl {
    private static final DragGestureListener DRAG_LISTENER = new PaletteDragGestureListener();
    private static final KeyListener KEY_LISTENER = new PaletteBlockKeyListener();
    private static final MouseListener MOUSE_LISTENER = new PaletteBlockMouseListener();
    private static final String UNABLE_TO_LOAD_BLOCK = Messages.gettext((String)"Unable to load block from %s .");
    private static final String LOADING_THE_BLOCK = Messages.gettext((String)"Loading the block") + "...";
    private final PaletteCtrl paletteCtrl;
    private final PaletteBlock model;
    private final PaletteBlockView view;
    private BasicBlock basicBlock;
    private boolean isSelected;

    public PaletteBlockCtrl(PaletteCtrl paletteCtrl, PaletteBlock paletteBlock) {
        this.paletteCtrl = paletteCtrl;
        this.model = paletteBlock;
        this.view = new PaletteBlockView(this);
        this.isSelected = false;
        this.basicBlock = null;
        this.paletteCtrl.addBlock(this);
        this.view.setFocusTraversalKeysEnabled(false);
        this.view.addKeyListener(KEY_LISTENER);
        this.view.addMouseListener(MOUSE_LISTENER);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.getView(), 1, DRAG_LISTENER);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean bl) {
        if (bl) {
            this.getView().requestFocus();
            this.getView().setStatusUI(PaletteBlockView.StatusUI.SELECTED);
        } else {
            PaletteManagerView.get().getPanel().requestFocus();
            this.getView().setStatusUI(PaletteBlockView.StatusUI.NON_SELECTED);
        }
        this.isSelected = bl;
    }

    public PaletteCtrl getPaletteCtrl() {
        return this.paletteCtrl;
    }

    public PaletteBlockView getView() {
        return this.view;
    }

    public PaletteBlock getModel() {
        return this.model;
    }

    public BasicBlock getBlock() {
        if (this.basicBlock == null) {
            this.basicBlock = (BasicBlock)((mxGraphTransferable)this.paletteCtrl.getTransferable()).getCells()[0];
        }
        return this.basicBlock;
    }
}

