/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.xcos.palette.model.Category;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;
import org.scilab.modules.xcos.utils.FileUtils;
import org.scilab.modules.xcos.utils.XcosMessages;
import org.xml.sax.SAXException;

public final class PaletteManager {
    public static final String MODEL_CLASS_PACKAGE = "org.scilab.modules.xcos.palette.model";
    private static final String UNABLE_TO_VALIDATE_CONFIG = "Unable to validate the configuration file.\n";
    private static final String SCHEMA_FILENAME = "/PaletteConfiguration.xsd";
    private static final String INSTANCE_FILENAME = "/palettes.xml";
    private static final Logger LOG = Logger.getLogger(PaletteManager.class.getName());
    private static PaletteManager instance;
    private static Marshaller marshaller;
    private static Unmarshaller unmarshaller;
    private Category root;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    private PaletteManager() {
    }

    public void setRoot(Category category) {
        this.root = category;
    }

    public Category getRoot() {
        return this.root;
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.pcs.firePropertyChange(string, bl, bl2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public static synchronized PaletteManager getInstance() {
        if (instance == null) {
            instance = new PaletteManager();
            instance.loadConfig();
        }
        return instance;
    }

    public static boolean isVisible() {
        return ScilabTabFactory.getInstance().getFromCache(MODEL_CLASS_PACKAGE) != null;
    }

    public static void setVisible(boolean bl) {
        PaletteManagerView paletteManagerView = PaletteManagerView.get();
        boolean bl2 = PaletteManager.isVisible();
        if (bl && paletteManagerView == null) {
            boolean bl3 = WindowsConfigurationManager.restoreUUID((String)MODEL_CLASS_PACKAGE);
            if (!bl3) {
                PaletteManagerView.restore();
            }
        } else if (bl2) {
            ClosingOperationsManager.startClosingOperation((SwingScilabDockablePanel)PaletteManagerView.get());
        }
        PaletteManager.getInstance().firePropertyChange("visible", bl2, bl);
    }

    private void loadConfig() {
        try {
            if (unmarshaller == null) {
                this.initUnmarshaller();
            }
            try {
                File file = new File(String.valueOf(ScilabConstants.SCIHOME.getAbsoluteFile()) + INSTANCE_FILENAME);
                if (!file.exists()) {
                    File file2 = new File(String.valueOf(ScilabConstants.SCI.getAbsoluteFile()) + "/modules/xcos/etc/palettes.xml");
                    FileUtils.forceCopy(file2, file);
                }
                this.setRoot((Category)unmarshaller.unmarshal(file));
            }
            catch (JAXBException jAXBException) {
                LOG.warning("user palette configuration file is not valid.\nSwitching to the default one." + String.valueOf((Object)jAXBException));
                ScilabModalDialog.show((SimpleTab)PaletteManagerView.get(), (String)XcosMessages.ERR_CONFIG_PALETTE_INVALID, (String)XcosMessages.XCOS_ERROR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.ERROR_ICON);
                try {
                    File file = new File(String.valueOf(ScilabConstants.SCI.getAbsoluteFile()) + "/modules/xcos/etc/palettes.xml");
                    this.setRoot((Category)unmarshaller.unmarshal(file));
                }
                catch (JAXBException jAXBException2) {
                    LOG.severe("base palette configuration file corrupted.\n" + String.valueOf((Object)jAXBException));
                    return;
                }
            }
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            return;
        }
    }

    private void initUnmarshaller() throws JAXBException {
        String string = ScilabConstants.SCI.getAbsolutePath() + "/modules/xcos/etc/PaletteConfiguration.xsd";
        JAXBContext jAXBContext = JAXBContext.newInstance((String)MODEL_CLASS_PACKAGE);
        unmarshaller = jAXBContext.createUnmarshaller();
        try {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new File(string));
            unmarshaller.setSchema(schema);
        }
        catch (SAXException sAXException) {
            LOG.severe(UNABLE_TO_VALIDATE_CONFIG + String.valueOf(sAXException));
        }
    }

    public void saveConfig() {
        try {
            if (marshaller == null) {
                this.initMarshaller();
            }
            try {
                File file = new File(String.valueOf(ScilabConstants.SCIHOME.getAbsoluteFile()) + INSTANCE_FILENAME);
                marshaller.marshal((Object)this.getRoot(), file);
            }
            catch (JAXBException jAXBException) {
                LOG.warning("Unable to save user palette configuration file.\n" + String.valueOf((Object)jAXBException));
            }
        }
        catch (JAXBException jAXBException) {
            LOG.severe(jAXBException.toString());
            return;
        }
    }

    private void initMarshaller() throws JAXBException {
        String string = ScilabConstants.SCI.getAbsolutePath() + "/modules/xcos/etc/PaletteConfiguration.xsd";
        JAXBContext jAXBContext = JAXBContext.newInstance((String)MODEL_CLASS_PACKAGE);
        marshaller = jAXBContext.createMarshaller();
        try {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new File(string));
            marshaller.setSchema(schema);
        }
        catch (SAXException sAXException) {
            LOG.warning(UNABLE_TO_VALIDATE_CONFIG + String.valueOf(sAXException));
        }
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
    }
}

