/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabTList;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.io.scicos.AbstractElement;
import org.scilab.modules.xcos.io.scicos.ScicosFormatException;
import org.scilab.modules.xcos.palette.model.PaletteBlock;
import org.scilab.modules.xcos.palette.model.PreLoaded;
import org.scilab.modules.xcos.palette.model.VariablePath;

public class PreLoadedElement
extends AbstractElement<PreLoaded> {
    private static final List<String> DATA_FIELD_NAMES = Arrays.asList("palette", "name", "blockNames", "icons", "style");
    private ScilabTList data;

    public PreLoadedElement() {
        super(null);
    }

    @Override
    public boolean canDecode(ScilabType scilabType) {
        this.data = (ScilabTList)scilabType;
        String string = ((ScilabString)this.data.get(0)).getData()[0][0];
        return string.equals(DATA_FIELD_NAMES.get(0));
    }

    @Override
    public PreLoaded decode(ScilabType scilabType, PreLoaded preLoaded) throws ScicosFormatException {
        this.data = (ScilabTList)scilabType;
        PreLoaded preLoaded2 = preLoaded;
        this.validate();
        if (preLoaded == null) {
            preLoaded2 = new PreLoaded();
        }
        preLoaded2.setEnable(true);
        int n = 1;
        String[][] stringArray = ((ScilabString)this.data.get(n)).getData();
        String[][] stringArray2 = ((ScilabString)this.data.get(++n)).getData();
        String[][] stringArray3 = ((ScilabString)this.data.get(++n)).getData();
        preLoaded2.setName(stringArray[0][0]);
        List<PaletteBlock> list = preLoaded2.getBlock();
        for (int i = 0; i < stringArray2.length; ++i) {
            for (int j = 0; j < stringArray2[i].length; ++j) {
                PaletteBlock paletteBlock = new PaletteBlock();
                paletteBlock.setName(stringArray2[i][j]);
                VariablePath variablePath = new VariablePath();
                variablePath.setVariable(null);
                File file = new File(stringArray3[i][j]);
                if (!file.exists()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(ScilabInterpreterManagement.buildCall((String)("blk=" + stringArray2[i][j]), (Object[])new Object[]{"define"}));
                    stringBuilder.append("; ");
                    stringBuilder.append(ScilabInterpreterManagement.buildCall((String)"xcosPalGenerateIcon", (Object[])new Object[]{"blk".toCharArray(), stringArray3[i][j]}));
                    stringBuilder.append("; ");
                    ScilabInterpreterManagement.requestScilabExec((String)stringBuilder.toString());
                }
                variablePath.setPath(stringArray3[i][j]);
                paletteBlock.setIcon(variablePath);
                list.add(paletteBlock);
            }
        }
        return preLoaded2;
    }

    private void validate() throws ScicosFormatException {
        if (!this.canDecode((ScilabType)this.data)) {
            throw new ScicosFormatException.WrongElementException();
        }
        int n = 0;
        if (this.data.size() != DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        String[] stringArray = ((ScilabString)this.data.get(n)).getData()[0];
        if (stringArray.length != DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(DATA_FIELD_NAMES.get(i))) continue;
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(++n) instanceof ScilabString) || ((ScilabType)this.data.get(n)).getWidth() != 1 || ((ScilabType)this.data.get(n)).getHeight() != 1) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabString) || ((ScilabType)this.data.get(n)).getWidth() != 1) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabString) || ((ScilabType)this.data.get(n)).getWidth() != 1) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
    }

    @Override
    public ScilabType encode(PreLoaded preLoaded, ScilabType scilabType) {
        this.data = (ScilabTList)scilabType;
        int n = 0;
        if (this.data == null) {
            this.data = this.allocateElement();
        }
        this.data.set(++n, (Object)new ScilabString(preLoaded.getName()));
        List<PaletteBlock> list = preLoaded.getBlock();
        String[][] stringArray = new String[list.size()][1];
        String[][] stringArray2 = new String[list.size()][1];
        String[][] stringArray3 = new String[list.size()][1];
        Map map = Xcos.getInstance().getStyleSheet().getStyles();
        for (int i = 0; i < list.size(); ++i) {
            PaletteBlock paletteBlock = list.get(i);
            stringArray[i][0] = paletteBlock.getName();
            stringArray2[i][0] = paletteBlock.getIcon().getEvaluatedPath();
            StringBuilder stringBuilder = new StringBuilder();
            Map map2 = (Map)map.get(paletteBlock.getName());
            if (map2 != null) {
                for (Map.Entry entry : map2.entrySet()) {
                    stringBuilder.append((String)entry.getKey()).append('=').append(entry.getValue()).append(';');
                }
            }
            stringArray3[i][0] = stringBuilder.toString();
        }
        this.data.set(++n, (Object)new ScilabString(stringArray));
        this.data.set(++n, (Object)new ScilabString(stringArray2));
        this.data.set(++n, (Object)new ScilabString(stringArray3));
        return this.data;
    }

    private ScilabTList allocateElement() {
        ScilabTList scilabTList = new ScilabTList(DATA_FIELD_NAMES.toArray(new String[DATA_FIELD_NAMES.size()]));
        scilabTList.add((Object)new ScilabString());
        scilabTList.add((Object)new ScilabString());
        scilabTList.add((Object)new ScilabString());
        scilabTList.add((Object)new ScilabString());
        return scilabTList;
    }
}

