/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.actions;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.xcos.palette.actions.SearchUI;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;
import org.scilab.modules.xcos.utils.XcosMessages;

public class SearchAction
extends CommonCallBack {
    private static final long serialVersionUID = 1L;
    private static final String LABEL_SEARCH = XcosMessages.SEARCH;
    private static final String ICON_SEARCH = FindIconHelper.findIcon((String)"system-search");
    private static JButton btnSearch;
    private static JComboBox txtSearch;
    private static JPanel searchBar;

    public SearchAction() {
        super("");
    }

    public static JPanel createSearchBar() {
        searchBar = new JPanel();
        searchBar.setLayout(new FlowLayout(0, 0, 0));
        txtSearch = new JComboBox();
        txtSearch.setUI(new SearchUI());
        searchBar.add(txtSearch);
        btnSearch = new JButton();
        ScilabLAF.setDefaultProperties((AbstractButton)btnSearch);
        btnSearch.setIcon(new ImageIcon(ICON_SEARCH));
        btnSearch.setToolTipText(LABEL_SEARCH);
        btnSearch.addActionListener((ActionListener)SearchAction.getCallBack());
        btnSearch.setFocusable(true);
        btnSearch.setBorderPainted(false);
        searchBar.add(btnSearch);
        return searchBar;
    }

    private static CommonCallBack getCallBack() {
        CommonCallBack commonCallBack = null;
        try {
            commonCallBack = (CommonCallBack)SearchAction.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return commonCallBack;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SearchAction.search();
    }

    public void callBack() {
    }

    protected static void search() {
        String string = txtSearch.getSelectedItem().toString();
        if (string.isEmpty()) {
            return;
        }
        PaletteManagerView.get().getSearchManager().search(string);
        Object e = txtSearch.getItemAt(0);
        if (e == null || !e.toString().equals(string)) {
            txtSearch.insertItemAt(string, 0);
        }
    }
}

