/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.scilab.modules.commons.OS;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;
import org.scilab.modules.xcos.utils.XcosMessages;

public class ZoomAction
extends CommonCallBack {
    private static final long serialVersionUID = 1L;
    private static final String ICON_ZOOMIN = FindIconHelper.findIcon((String)"zoom-in");
    private static final String ICON_ZOOMOUT = FindIconHelper.findIcon((String)"zoom-out");
    private static final int ACCELERATOR_KEY = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String ZOOM_IN = "ZoomIn";
    private static final String ZOOM_OUT = "ZoomOut";
    private static JButton btnZoomIn;
    private static JButton btnZoomOut;
    private static MenuItem miZoomIn;
    private static MenuItem miZoomOut;

    public ZoomAction() {
        super("");
    }

    public static void registerKeyAction(ActionMap actionMap, InputMap inputMap) {
        KeyStroke[] keyStrokeArray;
        KeyStroke[] keyStrokeArray2;
        actionMap.put(ZOOM_IN, (Action)((Object)new ZoomAction()));
        actionMap.put(ZOOM_OUT, (Action)((Object)new ZoomAction()));
        if (OS.get() == OS.MAC) {
            keyStrokeArray2 = new KeyStroke[]{KeyStroke.getKeyStroke(47, ACCELERATOR_KEY), KeyStroke.getKeyStroke(47, ACCELERATOR_KEY | 0x40)};
            keyStrokeArray = new KeyStroke[]{KeyStroke.getKeyStroke(61, ACCELERATOR_KEY), KeyStroke.getKeyStroke(61, ACCELERATOR_KEY | 0x40)};
        } else {
            keyStrokeArray2 = new KeyStroke[]{KeyStroke.getKeyStroke(61, ACCELERATOR_KEY), KeyStroke.getKeyStroke(61, ACCELERATOR_KEY | 0x40), KeyStroke.getKeyStroke(43, ACCELERATOR_KEY), KeyStroke.getKeyStroke(43, ACCELERATOR_KEY | 0x40), KeyStroke.getKeyStroke(107, ACCELERATOR_KEY)};
            keyStrokeArray = new KeyStroke[]{KeyStroke.getKeyStroke(45, ACCELERATOR_KEY), KeyStroke.getKeyStroke(45, ACCELERATOR_KEY | 0x40), KeyStroke.getKeyStroke(95, ACCELERATOR_KEY), KeyStroke.getKeyStroke(95, ACCELERATOR_KEY | 0x40), KeyStroke.getKeyStroke(109, ACCELERATOR_KEY)};
        }
        for (KeyStroke keyStroke : keyStrokeArray2) {
            inputMap.put(keyStroke, ZOOM_IN);
        }
        for (KeyStroke keyStroke : keyStrokeArray) {
            inputMap.put(keyStroke, ZOOM_OUT);
        }
    }

    public static JButton createButtonZoomIn() {
        btnZoomIn = new JButton();
        ScilabLAF.setDefaultProperties((AbstractButton)btnZoomIn);
        btnZoomIn.setName(XcosMessages.ZOOM_IN);
        btnZoomIn.setIcon(new ImageIcon(ICON_ZOOMIN));
        btnZoomIn.setToolTipText(XcosMessages.ZOOM_IN);
        btnZoomIn.addActionListener((ActionListener)ZoomAction.getCallBack());
        btnZoomIn.setFocusable(true);
        ZoomAction.setEnabledZoomIn(true);
        return btnZoomIn;
    }

    public static JButton createButtonZoomOut() {
        btnZoomOut = new JButton();
        ScilabLAF.setDefaultProperties((AbstractButton)btnZoomOut);
        btnZoomOut.setName(XcosMessages.ZOOM_OUT);
        btnZoomOut.setIcon(new ImageIcon(ICON_ZOOMOUT));
        btnZoomOut.setToolTipText(XcosMessages.ZOOM_OUT);
        btnZoomOut.addActionListener((ActionListener)ZoomAction.getCallBack());
        btnZoomOut.setFocusable(true);
        ZoomAction.setEnabledZoomOut(true);
        return btnZoomOut;
    }

    public static MenuItem createMenuZoomIn() {
        miZoomIn = ScilabMenuItem.createMenuItem();
        miZoomIn.setText(XcosMessages.ZOOM_IN);
        miZoomIn.setCallback(ZoomAction.getCallBack());
        SwingScilabMenuItem swingScilabMenuItem = (SwingScilabMenuItem)miZoomIn.getAsSimpleMenuItem();
        swingScilabMenuItem.setIcon((Icon)new ImageIcon(ICON_ZOOMIN));
        swingScilabMenuItem.setAccelerator(KeyStroke.getKeyStroke(107, ACCELERATOR_KEY));
        return miZoomIn;
    }

    public static MenuItem createMenuZoomOut() {
        miZoomOut = ScilabMenuItem.createMenuItem();
        miZoomOut.setText(XcosMessages.ZOOM_OUT);
        miZoomOut.setCallback(ZoomAction.getCallBack());
        SwingScilabMenuItem swingScilabMenuItem = (SwingScilabMenuItem)miZoomOut.getAsSimpleMenuItem();
        swingScilabMenuItem.setIcon((Icon)new ImageIcon(ICON_ZOOMOUT));
        swingScilabMenuItem.setAccelerator(KeyStroke.getKeyStroke(109, ACCELERATOR_KEY));
        return miZoomOut;
    }

    private static CommonCallBack getCallBack() {
        CommonCallBack commonCallBack = null;
        try {
            commonCallBack = (CommonCallBack)ZoomAction.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return commonCallBack;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.isEmpty()) {
            string = ((JButton)actionEvent.getSource()).getName();
        } else if (OS.get() == OS.MAC && string.equals("=") || string.equals("-") || string.equals("_")) {
            string = XcosMessages.ZOOM_OUT;
        } else if (string.equals("/") || string.equals("+") || string.equals("=")) {
            string = XcosMessages.ZOOM_IN;
        }
        if (string.equals(XcosMessages.ZOOM_IN)) {
            PaletteManagerView.get().getPanel().zoomIn();
        } else if (string.equals(XcosMessages.ZOOM_OUT)) {
            PaletteManagerView.get().getPanel().zoomOut();
        }
    }

    public static void setEnabledZoomIn(boolean bl) {
        btnZoomIn.setEnabled(bl);
        miZoomIn.setEnabled(bl);
    }

    public static void setEnabledZoomOut(boolean bl) {
        btnZoomOut.setEnabled(bl);
        miZoomOut.setEnabled(bl);
    }

    public void callBack() {
    }
}

