/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.listener;

import java.awt.MouseInfo;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.SwingUtilities;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.gui.bridge.contextmenu.SwingScilabContextMenu;
import org.scilab.modules.gui.contextmenu.ContextMenu;
import org.scilab.modules.gui.contextmenu.ScilabContextMenu;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.XcosTab;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.palette.PaletteBlockCtrl;
import org.scilab.modules.xcos.palette.PaletteCtrl;
import org.scilab.modules.xcos.palette.view.PaletteBlockView;
import org.scilab.modules.xcos.utils.BlockPositioning;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class PaletteBlockMouseListener
implements MouseListener {
    private List<XcosDiagram> getOpenedDiagrams() {
        List<XcosDiagram> list = Xcos.getInstance().openedDiagrams();
        assert (list.size() != 0);
        return list;
    }

    private ContextMenu createContextMenu(final PaletteBlockCtrl paletteBlockCtrl, String string) {
        MenuItem menuItem;
        List<XcosDiagram> list = this.getOpenedDiagrams();
        ContextMenu contextMenu = ScilabContextMenu.createContextMenu();
        if (list.size() == 1) {
            menuItem = ScilabMenuItem.createMenuItem();
            menuItem.setText(XcosMessages.ADDTO + " " + XcosTab.get(list.get(0)).getName());
            final XcosDiagram xcosDiagram = list.get(0);
            menuItem.setCallback(new CommonCallBack(string){
                private static final long serialVersionUID = 0L;

                public void callBack() {
                    Object[] objectArray = paletteBlockCtrl.getPaletteCtrl().getSelectedBlocks();
                    if (objectArray != null) {
                        BlockPositioning.updatePortsPosition(xcosDiagram, objectArray);
                        xcosDiagram.addCells(objectArray);
                    }
                }
            });
            contextMenu.add(menuItem);
        } else {
            menuItem = ScilabMenu.createMenu();
            menuItem.setText(XcosMessages.ADDTO);
            for (int i = 0; i < list.size(); ++i) {
                MenuItem menuItem2 = ScilabMenuItem.createMenuItem();
                final XcosDiagram xcosDiagram = list.get(i);
                menuItem2.setText(XcosTab.get(list.get(i)).getName());
                menuItem2.setCallback(new CommonCallBack(string){
                    private static final long serialVersionUID = 0L;

                    public void callBack() {
                        Object[] objectArray = paletteBlockCtrl.getPaletteCtrl().getSelectedBlocks();
                        if (objectArray != null) {
                            BlockPositioning.updatePortsPosition(xcosDiagram, objectArray);
                            xcosDiagram.addCells(objectArray);
                        }
                    }
                });
                menuItem.add(menuItem2);
            }
            contextMenu.add((Menu)menuItem);
        }
        contextMenu.getAsSimpleContextMenu().addSeparator();
        menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setText("Block help");
        menuItem.setCallback(new CommonCallBack(string){
            private static final long serialVersionUID = 0L;

            public void callBack() {
                try {
                    ScilabInterpreterManagement.asynchronousScilabExec(null, (String)"doc", (Object[])new Object[]{paletteBlockCtrl.getModel().getName()});
                }
                catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
                    interpreterException.printStackTrace();
                }
            }
        });
        contextMenu.add(menuItem);
        return contextMenu;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        PaletteBlockView paletteBlockView = (PaletteBlockView)mouseEvent.getSource();
        PaletteBlockCtrl paletteBlockCtrl = paletteBlockView.getController();
        if (mouseEvent.getClickCount() == 1 && SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isPopupTrigger() || XcosMessages.isMacOsPopupTrigger(mouseEvent)) {
            ContextMenu contextMenu = this.createContextMenu(paletteBlockCtrl, mouseEvent.toString());
            contextMenu.setVisible(true);
            ((SwingScilabContextMenu)contextMenu.getAsSimpleContextMenu()).setLocation(MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
            if ((mouseEvent.getModifiers() & 2) == 0) {
                PaletteCtrl.clearSelections();
            }
            paletteBlockCtrl.setSelected(true);
        } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (mouseEvent.getClickCount() == 1) {
                boolean bl = paletteBlockCtrl.isSelected();
                if ((mouseEvent.getModifiers() & 2) == 0) {
                    PaletteCtrl.clearSelections();
                }
                paletteBlockCtrl.setSelected(!bl);
            } else if (mouseEvent.getClickCount() == 2) {
                paletteBlockCtrl.setSelected(true);
                List<XcosDiagram> list = this.getOpenedDiagrams();
                XcosDiagram xcosDiagram = list.get(list.size() - 1);
                Object[] objectArray = paletteBlockCtrl.getPaletteCtrl().getSelectedBlocks();
                if (objectArray != null) {
                    BlockPositioning.updatePortsPosition(xcosDiagram, objectArray);
                    xcosDiagram.addCells(objectArray);
                }
            }
        } else {
            return;
        }
        paletteBlockCtrl.getPaletteCtrl().getView().scrollRectToVisible(paletteBlockView.getBounds());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        PaletteBlockView paletteBlockView = (PaletteBlockView)mouseEvent.getSource();
        if (!paletteBlockView.getController().isSelected()) {
            paletteBlockView.setStatusUI(PaletteBlockView.StatusUI.HOVER);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        PaletteBlockView paletteBlockView = (PaletteBlockView)mouseEvent.getSource();
        if (paletteBlockView.getController().isSelected()) {
            paletteBlockView.setStatusUI(PaletteBlockView.StatusUI.SELECTED);
        } else {
            paletteBlockView.setStatusUI(PaletteBlockView.StatusUI.NON_SELECTED);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }
}

