/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.scilab.modules.helptools.Converter;
import org.scilab.modules.helptools.CopyConvert;
import org.scilab.modules.helptools.Helpers;
import org.scilab.modules.helptools.SciDocMain;
import org.scilab.modules.helptools.image.ImageConverter;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FODocbookTagConverter
implements Converter {
    private static final String SCI = System.getenv("SCI");
    public static final boolean IS_WINDOWS = File.pathSeparatorChar == ';';
    private static final String CANNOT_COPY_CONVERT = "Cannot copy/convert '";
    private static final String TO_WITH_QUOTES = "' to '";
    private static final String COLON_WITH_QUOTES = "': ";
    private final String inName;
    private final SciDocMain sciDocMain;
    private final File docbookPath;
    private final File styleDoc;

    public FODocbookTagConverter(String string, SciDocMain sciDocMain, ImageConverter imageConverter) throws IOException {
        this.inName = string;
        this.sciDocMain = sciDocMain;
        Object object = System.getenv("DOCBOOK_ROOT");
        if (object == null) {
            object = SCI + "/thirdparty/docbook";
        }
        this.docbookPath = new File((String)object);
        if (!this.docbookPath.isDirectory()) {
            throw new FileNotFoundException("Could not find variable DOCBOOK_ROOT defining Docbook root directory");
        }
        this.styleDoc = new File(new File(this.docbookPath, "fo"), "docbook.xsl");
        if (!this.styleDoc.isFile()) {
            throw new FileNotFoundException("Could not find " + String.valueOf(this.styleDoc));
        }
    }

    @Override
    public void registerAllExternalXMLHandlers() {
    }

    @Override
    public void convert() throws SAXException, IOException {
        TransformerFactory transformerFactory;
        File file = this.generateExtendedStyle();
        File file2 = this.preProcessMaster(this.inName);
        if (!file2.isFile()) {
            throw new FileNotFoundException("Unable to parse generated master file : " + this.inName + " .");
        }
        StreamResult streamResult = new StreamResult(new File(Helpers.getTemporaryNameFo(this.sciDocMain.getOutputDirectory())));
        StreamSource streamSource = new StreamSource(file2);
        try {
            transformerFactory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            transformerFactory = TransformerFactory.newInstance();
        }
        try {
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(file));
            transformer.setParameter("base.dir", this.sciDocMain.getOutputDirectory());
            transformer.setParameter("use.extensions", "1");
            transformer.setParameter("graphicsize.extension", "0");
            transformer.setParameter("paper.type", "A4");
            transformer.setParameter("generate.toc", "book toc,title,figure,table,example,equation part toc,title reference toc,title");
            transformer.setParameter("toc.section.depth", "3");
            transformer.setParameter("section.autolabel", "1");
            transformer.setParameter("variablelist.as.blocks", "1");
            transformer.setParameter("shade.verbatim", "1");
            transformer.setParameter("img.src.path", this.sciDocMain.getOutputDirectory());
            transformer.transform(streamSource, streamResult);
            file2.delete();
            file.delete();
        }
        catch (NullPointerException | TransformerException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void install() throws IOException {
    }

    private File generateExtendedStyle() throws IOException {
        File file = new File(SCI + "/modules/helptools/schema/extendedStyle.xsl");
        try {
            String string = Helpers.loadString(file, "UTF-8");
            string = string.replaceAll("STYLE_DOC", this.styleDoc.toURI().toString());
            File file2 = File.createTempFile("style_", ".xsl");
            Helpers.saveString(string, file2, "UTF-8");
            return file2;
        }
        catch (IOException iOException) {
            System.err.println("Could not convert " + String.valueOf(file));
            throw iOException;
        }
    }

    private File preProcessMaster(String string) throws IOException {
        String string2 = new File(string).getName();
        File file = new File(this.sciDocMain.getOutputDirectory() + File.separator + string2.substring(0, string2.lastIndexOf(".")) + "-processed.xml");
        CopyConvert copyConvert = new CopyConvert();
        copyConvert.setVerbose(true);
        copyConvert.setPrintFormat(this.sciDocMain.getFormat().name());
        copyConvert.setLatexConverted(false);
        try {
            copyConvert.run(new File(string), file);
        }
        catch (SAXParseException sAXParseException) {
            System.err.println(CANNOT_COPY_CONVERT + string + TO_WITH_QUOTES + String.valueOf(file) + COLON_WITH_QUOTES + Helpers.reason(sAXParseException));
            System.err.println("Line: " + sAXParseException.getLineNumber());
            System.err.println("Column: " + sAXParseException.getColumnNumber());
            System.err.println("Public ID: " + sAXParseException.getPublicId());
            System.err.println("System Id: " + sAXParseException.getSystemId());
            throw new IOException(sAXParseException);
        }
        catch (SAXException sAXException) {
            System.err.println(CANNOT_COPY_CONVERT + string + TO_WITH_QUOTES + String.valueOf(file) + COLON_WITH_QUOTES + Helpers.reason(sAXException));
            throw new IOException(sAXException);
        }
        catch (IOException iOException) {
            System.err.println(CANNOT_COPY_CONVERT + string + TO_WITH_QUOTES + String.valueOf(file) + COLON_WITH_QUOTES + Helpers.reason(iOException));
            throw iOException;
        }
        return file;
    }
}

