/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools.image;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.scilab.modules.helptools.DocbookTagConverter;
import org.scilab.modules.helptools.image.ExternalImageConverter;

public class SVGImageConverter
implements ExternalImageConverter {
    private final DocbookTagConverter conv;

    public SVGImageConverter(DocbookTagConverter docbookTagConverter) {
        this.conv = docbookTagConverter;
    }

    @Override
    public String getMimeType() {
        return "image/svg";
    }

    @Override
    public boolean mustRegenerate() {
        return false;
    }

    @Override
    public String convertToImage(String string, String string2, Map<String, String> map, File file, String string3) {
        return this.convertToPNG(new TranscoderInput((Reader)new StringReader(string2)), map, file, string3);
    }

    @Override
    public String convertToImage(File file, Map<String, String> map, File file2, String string) {
        try {
            return this.convertToPNG(new TranscoderInput((InputStream)new FileInputStream(file)), map, file2, this.conv.getBaseImagePath() + string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Problem when exporting SVG to " + String.valueOf(file2) + "!\n" + fileNotFoundException.toString());
            return null;
        }
    }

    private String convertToPNG(TranscoderInput transcoderInput, Map<String, String> map, File file, String string) {
        PNGTranscoder pNGTranscoder = new PNGTranscoder();
        pNGTranscoder.addTranscodingHint(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE, (Object)Boolean.TRUE);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)fileOutputStream);
            pNGTranscoder.transcode(transcoderInput, transcoderOutput);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            return this.conv.generateImageCode(this.conv.getBaseImagePath() + string, map);
        }
        catch (Exception exception) {
            System.err.println("Problem when exporting SVG to " + String.valueOf(file) + "!\n" + exception.toString());
            return null;
        }
    }
}

