/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools.source;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.scilab.modules.helptools.scilab.AbstractScilabCodeHandler;
import org.scilab.modules.helptools.scilab.HTMLScilabCodeHandler;
import org.scilab.modules.helptools.scilab.ScilabLexer;

public class ScilabSourceBrowser
extends HTMLScilabCodeHandler {
    private static final String entete = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n          \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"{$lang}\" lang=\"{$lang}\">\n  <head{$profile}>\n    <title><!--<title>--> <!--<subtitle>--></title>\n    <style type=\"text/css\" media=\"all\">\n      @import url(\"site.css\");\n      @import url(\"css/scilab_code.css\");\n      @import url(\"css/style.css\");\n    </style>\n    <!--[if IE]><![endif]><![endif]-->\n    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n    <!-- <link rel=\"shortcut icon\" href=\"{$_SERVER['STATIC_ROOT']}/favicon.ico\" />{$link}\n     $canonical\n    <script type=\"text/javascript\" src=\"{$_SERVER['STATIC_ROOT']}/userprefs.js\"></script>{$base}{$meta}{$moreheadtags}\n        -->\n  </head>\n  <body>";
    private List<String> files;
    private Map<String, Set<String>> macroUsage = new HashMap<String, Set<String>>();
    private ScilabLexer scilabLexer;
    private String outputDirectory;
    private Map<String, String> mapId;

    public static void main(String[] stringArray) {
        ScilabSourceBrowser scilabSourceBrowser = new ScilabSourceBrowser(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        scilabSourceBrowser.generateSource();
    }

    public ScilabSourceBrowser(String string, String string2, String string3, String string4) {
        this.outputDirectory = string4;
        this.scilabLexer = new ScilabLexer(string2, string3);
        this.generateMapId(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSource() {
        new FirstPass().getMacroUsage();
        for (String string : this.files) {
            Reader reader = null;
            try {
                File file = new File(string);
                System.out.println(file);
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                this.currentCommand = file.getName().split("\\.")[0];
                this.buffer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputDirectory + File.separator + this.currentCommand + ".html"), "UTF-8");
                this.buffer.append(entete);
                this.buffer.append("<div style=\"code\"><pre>");
                this.scilabLexer.convert(this, reader, false);
                this.buffer.append("</pre></div>\n</body>\n</html>");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    ((Writer)this.buffer).flush();
                    ((Writer)this.buffer).close();
                    reader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    @Override
    public void handleCommand(String string) throws IOException {
        this.buffer.append("<span class=\"command\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleFunctionId(String string) throws IOException {
        this.buffer.append("<a href=\"#");
        this.buffer.append(string);
        this.buffer.append("\"><span class=\"functionid\">");
        this.buffer.append(string);
        this.buffer.append("</span></a>");
    }

    @Override
    public void handleFunctionIdDecl(String string) throws IOException {
        this.buffer.append("<a name=\"");
        this.buffer.append(string);
        this.buffer.append("\"></a><span class=\"functionid\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleInputOutputArgs(String string) throws IOException {
        this.buffer.append("<a href=\"#");
        this.buffer.append(string);
        this.buffer.append("\"><span class=\"inputoutputargs\">");
        this.buffer.append(string);
        this.buffer.append("</span></a>");
    }

    @Override
    public void handleInputOutputArgsDecl(String string) throws IOException {
        this.buffer.append("<a name=\"");
        this.buffer.append(string);
        this.buffer.append("\"></a><span class=\"inputoutputargs\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    private void generateMapId(String string) {
        BufferedReader bufferedReader = null;
        this.files = new ArrayList<String>();
        this.mapId = new HashMap<String, String>();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                this.files.add(string2);
                String string3 = new File(string2).getName().split("\\.")[0];
                this.mapId.put(string3, string3 + ".html");
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
    }

    class FirstPass
    extends AbstractScilabCodeHandler {
        FirstPass() {
        }

        void getMacroUsage() {
            for (String string : ScilabSourceBrowser.this.files) {
                try {
                    File file = new File(string);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    ScilabSourceBrowser.this.currentCommand = file.getName().split("\\.")[0];
                    ScilabSourceBrowser.this.scilabLexer.convert(this, bufferedReader, false);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        @Override
        public void handleMacro(String string) throws IOException {
            Set<String> set = ScilabSourceBrowser.this.macroUsage.get(string);
            if (set == null) {
                set = new HashSet<String>();
                ScilabSourceBrowser.this.macroUsage.put(string, set);
            }
            set.add(ScilabSourceBrowser.this.currentCommand);
        }
    }
}

