/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.dockbar;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.WeakHashMap;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.flexdock.dockbar.Dockbar;
import org.flexdock.dockbar.StatusDockbar;
import org.flexdock.dockbar.ViewPane;
import org.flexdock.dockbar.activation.ActivationQueue;
import org.flexdock.dockbar.activation.ActiveDockableHandler;
import org.flexdock.dockbar.activation.Animation;
import org.flexdock.dockbar.event.ActivationListener;
import org.flexdock.dockbar.event.DockablePropertyChangeHandler;
import org.flexdock.dockbar.event.DockbarEvent;
import org.flexdock.dockbar.event.DockbarEventHandler;
import org.flexdock.dockbar.event.DockbarListener;
import org.flexdock.dockbar.event.DockbarTracker;
import org.flexdock.dockbar.layout.DockbarLayout;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.floating.frames.DockingFrame;
import org.flexdock.docking.props.PropertyChangeListenerFactory;
import org.flexdock.docking.state.DockingPath;
import org.flexdock.docking.state.DockingState;
import org.flexdock.event.EventManager;
import org.flexdock.perspective.RestorationManager;
import org.flexdock.util.RootWindow;
import org.flexdock.util.Utilities;

public class DockbarManager {
    private static final WeakHashMap MANAGERS_BY_WINDOW = new WeakHashMap();
    public static final Integer DOCKBAR_LAYER = new Integer(JLayeredPane.PALETTE_LAYER - 5);
    public static final int DEFAULT_EDGE = 2;
    private static String dockbarManagerClassName;
    private static DockbarManager currentManager;
    protected WeakReference windowRef;
    protected Dockbar leftBar;
    protected Dockbar rightBar;
    protected Dockbar bottomBar;
    protected ViewPane viewPane;
    protected DockbarLayout dockbarLayout = new DockbarLayout(this);
    private ActivationListener activationListener = new ActivationListener(this);
    private HashMap dockables;
    private int activeEdge = -1;
    private String activeDockableId;
    private boolean animating;
    private boolean dragging;

    public static DockbarManager getInstance(Component c) {
        RootWindow window = RootWindow.getRootContainer(c);
        return DockbarManager.getInstance(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DockbarManager getInstance(RootWindow window) {
        if (window == null) {
            return null;
        }
        Component root = window.getRootContainer();
        if (root instanceof DockingFrame) {
            root = ((DockingFrame)root).getOwner();
            return DockbarManager.getInstance(root);
        }
        DockbarManager mgr = (DockbarManager)MANAGERS_BY_WINDOW.get(window);
        if (mgr == null) {
            mgr = DockbarManager.createDockbarManager(window);
            WeakHashMap weakHashMap = MANAGERS_BY_WINDOW;
            synchronized (weakHashMap) {
                MANAGERS_BY_WINDOW.put(window, mgr);
            }
            mgr.install();
        }
        if (currentManager == null) {
            currentManager = mgr;
        }
        return mgr;
    }

    private static DockbarManager createDockbarManager(RootWindow window) {
        if (dockbarManagerClassName == null) {
            return new DockbarManager(window);
        }
        DockbarManager mgr = null;
        try {
            Class<?> clazz = Class.forName(dockbarManagerClassName);
            Constructor<?> constructor = clazz.getConstructor(RootWindow.class);
            mgr = (DockbarManager)constructor.newInstance(window);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return mgr;
    }

    public static void setDockbarManager(String className) {
        dockbarManagerClassName = className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DockbarManager getCurrent(Dockable dockable) {
        if (dockable == null) {
            return null;
        }
        WeakHashMap weakHashMap = MANAGERS_BY_WINDOW;
        synchronized (weakHashMap) {
            for (DockbarManager mgr : MANAGERS_BY_WINDOW.values()) {
                if (!mgr.isOwner(dockable)) continue;
                return mgr;
            }
        }
        return null;
    }

    public static void windowChanged(Component newWindow) {
        currentManager = DockbarManager.getInstance(newWindow);
    }

    public static DockbarManager getCurrent() {
        return currentManager;
    }

    public static void addListener(DockbarListener listener) {
        EventManager.addListener(listener);
    }

    public static void activate(String dockableId, boolean locked) {
        Dockable dockable = DockingManager.getDockable(dockableId);
        DockbarManager.activate(dockable, locked);
    }

    public static void activate(Dockable dockable, boolean locked) {
        if (dockable == null) {
            return;
        }
        DockbarManager mgr = DockbarManager.getCurrent(dockable);
        if (mgr == null || !mgr.contains(dockable)) {
            return;
        }
        mgr.setActiveDockable(dockable);
        if (locked) {
            mgr.getActivationListener().lockViewpane();
        }
    }

    protected DockbarManager(RootWindow window) {
        this.leftBar = new Dockbar(this, 2);
        this.rightBar = new Dockbar(this, 4);
        this.bottomBar = new StatusDockbar(this, 3);
        this.viewPane = new ViewPane(this);
        this.windowRef = new WeakReference<RootWindow>(window);
        this.dockables = new HashMap();
    }

    public RootWindow getWindow() {
        return (RootWindow)this.windowRef.get();
    }

    protected void install() {
        RootWindow window = this.getWindow();
        if (window == null) {
            return;
        }
        JLayeredPane layerPane = window.getLayeredPane();
        boolean changed = this.install(this.leftBar, layerPane);
        changed = this.install(this.rightBar, layerPane) || changed;
        changed = this.install(this.bottomBar, layerPane) || changed;
        boolean bl = changed = this.install(this.viewPane, layerPane) || changed;
        if (changed) {
            layerPane.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent evt) {
                    if (evt.getSource() instanceof JLayeredPane) {
                        DockbarManager.this.revalidate();
                    }
                }
            });
        }
        this.revalidate();
    }

    private boolean install(Component c, JLayeredPane layerPane) {
        if (c.getParent() != layerPane) {
            if (c.getParent() != null) {
                c.getParent().remove(c);
            }
            layerPane.add(c, DOCKBAR_LAYER);
            return true;
        }
        return false;
    }

    public Dockbar getBottomBar() {
        return this.bottomBar;
    }

    public Dockbar getLeftBar() {
        return this.leftBar;
    }

    public Dockbar getRightBar() {
        return this.rightBar;
    }

    public ViewPane getViewPane() {
        return this.viewPane;
    }

    public void revalidate() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DockbarManager.this.validate();
            }
        });
    }

    public void validate() {
        this.toggleDockbars();
        this.dockbarLayout.layout();
        this.viewPane.revalidate();
    }

    private void toggleDockbars() {
        this.leftBar.setVisible(this.leftBar.getComponentCount() != 0);
        this.rightBar.setVisible(this.rightBar.getComponentCount() != 0);
        this.bottomBar.setVisible(this.bottomBar.getComponentCount() != 0);
    }

    private int findDockbarEdge(Dockable dockable) {
        RootWindow window = RootWindow.getRootContainer(dockable.getComponent());
        if (window == null) {
            return 2;
        }
        Component cmp = dockable.getComponent();
        Container contentPane = window.getContentPane();
        Rectangle contentRect = new Rectangle(0, 0, contentPane.getWidth(), contentPane.getHeight());
        Rectangle dockRect = SwingUtilities.convertRectangle(cmp.getParent(), cmp.getBounds(), contentPane);
        Point dockCenter = new Point(dockRect.x + dockRect.width / 2, dockRect.y + dockRect.height / 2);
        Point leftCenter = new Point(0, contentRect.height / 2);
        Point bottomCenter = new Point(contentRect.width / 2, contentRect.height);
        Point rightCenter = new Point(contentRect.width, contentRect.height / 2);
        double min = Math.abs(dockCenter.distance(leftCenter));
        int edge = 2;
        double delta = Math.abs(dockCenter.distance(rightCenter));
        if (delta < min) {
            min = delta;
            edge = 4;
        }
        if ((delta = Math.abs(dockCenter.distance(bottomCenter))) < min) {
            min = delta;
            edge = 3;
        }
        return edge;
    }

    public int getEdge(String dockableId) {
        Dockable dockable = DockingManager.getDockable(dockableId);
        return this.getEdge(dockable);
    }

    public int getEdge(Dockable dockable) {
        Dockbar dockbar = this.getDockbar(dockable);
        if (dockbar == this.leftBar) {
            return 2;
        }
        if (dockbar == this.rightBar) {
            return 4;
        }
        if (dockbar == this.bottomBar) {
            return 3;
        }
        return -1;
    }

    public Dockbar getDockbar(Dockable dockable) {
        if (dockable == null) {
            return null;
        }
        if (this.leftBar.contains(dockable)) {
            return this.leftBar;
        }
        if (this.rightBar.contains(dockable)) {
            return this.rightBar;
        }
        if (this.bottomBar.contains(dockable)) {
            return this.bottomBar;
        }
        return null;
    }

    public Dockbar getDockbar(int edge) {
        edge = Dockbar.getValidOrientation(edge);
        switch (edge) {
            case 4: {
                return this.rightBar;
            }
            case 3: {
                return this.bottomBar;
            }
        }
        return this.leftBar;
    }

    public void minimize(Dockable dockable) {
        if (dockable == null) {
            return;
        }
        int edge = 2;
        RootWindow window = this.getWindow();
        if (window != null && DockingManager.isDocked(dockable)) {
            edge = this.findDockbarEdge(dockable);
        }
        this.minimize(dockable, edge);
    }

    public void minimize(Dockable dockable, int edge) {
        if (dockable == null) {
            return;
        }
        if (this.isDockingCancelled(dockable, edge)) {
            return;
        }
        edge = Dockbar.getValidOrientation(edge);
        this.install(dockable, edge);
        this.dockables.put(dockable.getPersistentId(), new Integer(edge));
        DockbarEvent evt = new DockbarEvent(dockable, 11, edge);
        EventManager.dispatch(evt);
    }

    public void reAdd(Dockable dockable) {
        if (dockable == null || this.contains(dockable)) {
            return;
        }
        Integer edge = (Integer)this.dockables.get(dockable.getPersistentId());
        if (edge != null) {
            this.install(dockable, edge);
        }
    }

    private void install(Dockable dockable, int edge) {
        Dockbar dockbar = this.getDockbar(edge);
        DockingManager.undock(dockable);
        dockbar.dock(dockable);
        dockable.getDockingProperties().setDockingEnabled(false);
        DockingState info = DockingManager.getLayoutManager().getDockingState(dockable);
        info.setMinimizedConstraint(edge);
        this.revalidate();
    }

    private boolean isDockingCancelled(Dockable dockable, int edge) {
        DockbarEvent evt = new DockbarEvent(dockable, 10, edge);
        EventManager.dispatch(evt);
        return evt.isConsumed();
    }

    public void restore(Dockable dockable) {
        if (dockable == null) {
            return;
        }
        DockingState dockingState = DockingManager.getDockingState(dockable);
        DockingPath dockingPath = dockingState.getPath();
        boolean restoreResult = false;
        restoreResult = dockingPath != null ? dockingPath.restore(dockable) : RestorationManager.getInstance().restore(dockable);
        if (restoreResult) {
            this.remove(dockable);
            this.dockables.remove(dockable.getPersistentId());
        }
    }

    public boolean remove(Dockable dockable) {
        Dockbar dockbar;
        if (dockable == null) {
            return false;
        }
        if (this.getActiveDockable() == dockable) {
            this.setActiveDockable((Dockable)null);
        }
        if ((dockbar = this.getDockbar(dockable)) == null) {
            return false;
        }
        dockbar.undock(dockable);
        dockable.getDockingProperties().setDockingEnabled(true);
        this.revalidate();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveEdge() {
        DockbarManager dockbarManager = this;
        synchronized (dockbarManager) {
            return this.activeEdge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveEdge(int edge) {
        DockbarManager dockbarManager = this;
        synchronized (dockbarManager) {
            this.activeEdge = edge;
        }
    }

    private Dockbar getActiveDockbar() {
        int edge = this.getActiveEdge();
        switch (edge) {
            case 1: {
                return this.bottomBar;
            }
            case 4: {
                return this.rightBar;
            }
        }
        return this.leftBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getActiveDockableId() {
        DockbarManager dockbarManager = this;
        synchronized (dockbarManager) {
            return this.activeDockableId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveDockableId(String id) {
        DockbarManager dockbarManager = this;
        synchronized (dockbarManager) {
            this.activeDockableId = id;
        }
    }

    public Dockable getActiveDockable() {
        String dockingId = this.getActiveDockableId();
        Dockable dockable = DockingManager.getDockable(dockingId);
        return dockable;
    }

    public Cursor getResizeCursor() {
        return this.viewPane.getResizeCursor();
    }

    public boolean isActive() {
        return this.getActiveDockable() != null;
    }

    public void setActiveDockable(String dockableId) {
        Dockable dockable = DockingManager.getDockable(dockableId);
        this.setActiveDockable(dockable);
    }

    public void setActiveDockable(Dockable dockable) {
        int newEdge = this.getEdge(dockable);
        if (newEdge == -1) {
            dockable = null;
        }
        Dockable oldDockable = this.getActiveDockable();
        String newDockableId = dockable == null ? null : dockable.getPersistentId();
        String currentlyActiveId = this.getActiveDockableId();
        boolean changed = Utilities.isChanged(currentlyActiveId, newDockableId);
        boolean bl = changed = changed || newEdge != this.getActiveEdge();
        if (changed) {
            this.viewPane.setLocked(false);
            this.setActiveEdge(newEdge);
            this.setActiveDockableId(newDockableId);
            this.startAnimation(oldDockable, dockable, newDockableId, newEdge);
        }
    }

    private void dispatchEvent(Dockable oldDockable, Dockable newDockable) {
        int evtType = 0;
        if (newDockable == null && oldDockable != null) {
            newDockable = oldDockable;
            evtType = 2;
        }
        if (newDockable != null) {
            DockbarEvent evt = new DockbarEvent(newDockable, evtType, this.getActiveEdge());
            EventManager.dispatch(evt);
        }
    }

    private void startAnimation(final Dockable oldDockable, final Dockable newDockable, final String newDockableId, final int newEdge) {
        Animation deactivation = oldDockable == null ? null : new Animation(this, true);
        Runnable updater1 = new Runnable(){

            public void run() {
                DockbarManager.this.setActiveEdge(newEdge);
                DockbarManager.this.setActiveDockableId(newDockableId);
                DockbarManager.this.viewPane.updateOrientation();
                DockbarManager.this.viewPane.updateContents();
            }
        };
        Animation activation = newDockableId == null ? null : new Animation(this, false);
        Runnable updater2 = new Runnable(){

            public void run() {
                DockbarManager.this.viewPane.setPrefSize(-1);
                DockbarManager.this.viewPane.updateOrientation();
                DockbarManager.this.viewPane.updateContents();
                DockbarManager.this.revalidate();
                DockbarManager.this.dispatchEvent(oldDockable, newDockable);
            }
        };
        ActivationQueue queue = new ActivationQueue(this, deactivation, updater1, activation, updater2);
        queue.start();
    }

    public int getPreferredViewpaneSize() {
        return this.dockbarLayout.getDesiredViewpaneSize();
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public void setAnimating(boolean animating) {
        this.animating = animating;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public ActivationListener getActivationListener() {
        return this.activationListener;
    }

    public boolean contains(Dockable dockable) {
        return this.getDockbar(dockable) != null;
    }

    private boolean isOwner(Dockable dockable) {
        return dockable == null ? false : this.dockables.containsKey(dockable.getPersistentId());
    }

    public DockbarLayout getLayout() {
        return this.dockbarLayout;
    }

    static {
        Class<DockingManager> c = DockingManager.class;
        EventManager.addHandler(new DockbarEventHandler());
        DockbarTracker.register();
        PropertyChangeListenerFactory.addFactory(new DockablePropertyChangeHandler.Factory());
        EventManager.addListener(new ActiveDockableHandler());
    }
}

