/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.plaf.resources;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.flexdock.plaf.Configurator;
import org.flexdock.plaf.PropertySet;
import org.flexdock.plaf.XMLConstants;
import org.flexdock.plaf.resources.ConstructorHandler;
import org.flexdock.plaf.resources.ResourceHandler;
import org.w3c.dom.Element;

public class ResourceHandlerFactory
implements XMLConstants {
    private static final HashMap RESOURCE_HANDLERS = ResourceHandlerFactory.loadResourceHandlers();
    private static final HashMap PROPERTY_HANDLERS = ResourceHandlerFactory.loadPropertyHandlers();

    public static ResourceHandler getResourceHandler(String handlerName) {
        return (ResourceHandler)RESOURCE_HANDLERS.get(handlerName);
    }

    public static String getPropertyHandler(String propertyType) {
        return (String)PROPERTY_HANDLERS.get(propertyType);
    }

    private static HashMap loadResourceHandlers() {
        HashMap elements = Configurator.getNamedElementsByTagName("handler");
        HashMap<String, ResourceHandler> handlers = new HashMap<String, ResourceHandler>(elements.size());
        for (String key : elements.keySet()) {
            Element elem = (Element)elements.get(key);
            String name = elem.getAttribute("name");
            String className = elem.getAttribute("value");
            ResourceHandler handler = ResourceHandlerFactory.createResourceHandler(className);
            if (handler == null) continue;
            handlers.put(name, handler);
        }
        HashMap constructors = ResourceHandlerFactory.loadConstructors();
        handlers.putAll(constructors);
        return handlers;
    }

    private static ResourceHandler createResourceHandler(String className) {
        if (Configurator.isNull(className)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (ResourceHandler)clazz.newInstance();
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static HashMap loadPropertyHandlers() {
        HashMap elements = Configurator.getNamedElementsByTagName("prop-handler");
        HashMap<String, String> propHandlers = new HashMap<String, String>(elements.size());
        for (String key : elements.keySet()) {
            Element elem = (Element)elements.get(key);
            String tagName = elem.getAttribute("name");
            String handlerName = elem.getAttribute("value");
            if (Configurator.isNull(tagName) || Configurator.isNull(handlerName)) continue;
            propHandlers.put(tagName, handlerName);
        }
        return propHandlers;
    }

    private static HashMap loadConstructors() {
        PropertySet[] constructors = Configurator.getProperties("constructor");
        HashMap<String, ConstructorHandler> map = new HashMap<String, ConstructorHandler>(constructors.length);
        for (int i = 0; i < constructors.length; ++i) {
            ConstructorHandler handler = ResourceHandlerFactory.createConstructorHandler(constructors[i]);
            if (handler == null) continue;
            map.put(constructors[i].getName(), handler);
        }
        return map;
    }

    private static ConstructorHandler createConstructorHandler(PropertySet props) {
        String className = props.getString("classname");
        if (Configurator.isNull(className)) {
            return null;
        }
        try {
            List argKeys = props.getNumericKeys(true);
            ArrayList<Class> params = new ArrayList<Class>(argKeys.size());
            for (String key : argKeys) {
                Class paramType = props.toClass(key);
                if (!paramType.isPrimitive() && paramType != String.class) {
                    throw new IllegalArgumentException("ConstructorHandler can only parse primitive and String arguments: " + paramType);
                }
                params.add(paramType);
            }
            Class<?> type = Class.forName(className);
            Class[] paramTypes = params.toArray(new Class[0]);
            Constructor<?> constructor = type.getConstructor(paramTypes);
            return new ConstructorHandler(constructor);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

