/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jeuclid.converter.ConverterRegistry;
import net.sourceforge.jeuclid.converter.FreeHepConverter;
import net.sourceforge.jeuclid.elements.support.ClassLoaderSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.freehep.graphicsbase.util.export.ExportFileType;

public final class FreeHepInternalDetector {
    private static final Log LOGGER = LogFactory.getLog(FreeHepInternalDetector.class);
    private static final Map<String, String> PLUGINS_CLASSES = new HashMap<String, String>();

    private FreeHepInternalDetector() {
    }

    public static void actuallyDetectConversionPlugins(ConverterRegistry converterRegistry) {
        for (Map.Entry<String, String> entry : PLUGINS_CLASSES.entrySet()) {
            try {
                Class<?> clazz = ClassLoaderSupport.getInstance().loadClass(entry.getKey());
                ExportFileType exportFileType = (ExportFileType)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                Class<?> clazz2 = ClassLoaderSupport.getInstance().loadClass(entry.getValue());
                FreeHepInternalDetector.actuallyRegister(converterRegistry, exportFileType, clazz2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.debug((Object)noSuchMethodException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.debug((Object)classNotFoundException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.debug((Object)illegalArgumentException);
            }
            catch (SecurityException securityException) {
                LOGGER.debug((Object)securityException);
            }
            catch (InstantiationException instantiationException) {
                LOGGER.debug((Object)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.debug((Object)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.debug((Object)invocationTargetException);
            }
        }
    }

    private static void actuallyRegister(ConverterRegistry converterRegistry, ExportFileType exportFileType, Class<?> clazz) throws NoSuchMethodException {
        FreeHepConverter freeHepConverter = new FreeHepConverter(clazz);
        for (String string : exportFileType.getMIMETypes()) {
            for (String string2 : exportFileType.getExtensions()) {
                converterRegistry.registerMimeTypeAndSuffix(string, string2, false);
            }
            converterRegistry.registerConverter(string, freeHepConverter, false);
        }
    }

    static {
        PLUGINS_CLASSES.put("org.freehep.graphicsio.emf.EMFExportFileType", "org.freehep.graphicsio.emf.EMFGraphics2D");
        PLUGINS_CLASSES.put("org.freehep.graphicsio.gif.GIFExportFileType", "org.freehep.graphicsio.gif.GIFGraphics2D");
        PLUGINS_CLASSES.put("org.freehep.graphicsio.pdf.PDFExportFileType", "org.freehep.graphicsio.pdf.PDFGraphics2D");
        PLUGINS_CLASSES.put("org.freehep.graphicsio.ps.PSExportFileType", "org.freehep.graphicsio.ps.PSGraphics2D");
        PLUGINS_CLASSES.put("org.freehep.graphicsio.svg.SVGExportFileType", "org.freehep.graphicsio.svg.SVGGraphics2D");
        PLUGINS_CLASSES.put("org.freehep.graphicsio.swf.SWFExportFileType", "org.freehep.graphicsio.swf.SWFGraphics2D");
    }
}

