/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.layout.JEuclidView;
import net.sourceforge.jeuclid.swing.JMathComponent;
import org.w3c.dom.Node;

public class MathComponentUI
extends ComponentUI
implements PropertyChangeListener {
    private final Map<JMathComponent, Reference<ViewContext>> contextCache = new HashMap<JMathComponent, Reference<ViewContext>>();

    private JEuclidView getJeuclidView(Graphics graphics, JComponent jComponent) {
        JMathComponent jMathComponent = (JMathComponent)jComponent;
        ViewContext viewContext = null;
        Reference<ViewContext> reference = this.contextCache.get(jMathComponent);
        if (reference != null) {
            viewContext = reference.get();
        }
        if (viewContext == null) {
            viewContext = new ViewContext(jMathComponent);
            this.contextCache.put(jMathComponent, new SoftReference<ViewContext>(viewContext));
        }
        return viewContext.getJeculidView((Graphics2D)graphics);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        JEuclidView jEuclidView = this.getJeuclidView(graphics, jComponent);
        Dimension dimension = this.calculatePreferredSize(jComponent, jEuclidView);
        Point point = this.getStartPointWithBordersAndAdjustDimension(jComponent, dimension);
        this.paintBackground(graphics, jComponent, dimension, point);
        Point2D point2D = this.calculateAlignmentOffset((JMathComponent)jComponent, jEuclidView, dimension);
        jEuclidView.draw((Graphics2D)graphics, (float)point2D.getX() + (float)point.x, (float)point2D.getY() + (float)point.y);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.paint(graphics, jComponent);
    }

    private Point2D calculateAlignmentOffset(JMathComponent jMathComponent, JEuclidView jEuclidView, Dimension dimension) {
        float f = jMathComponent.getHorizontalAlignment() == 10 || jMathComponent.getHorizontalAlignment() == 2 ? 0.0f : (jMathComponent.getHorizontalAlignment() == 11 || jMathComponent.getHorizontalAlignment() == 4 ? (float)dimension.width - jEuclidView.getWidth() : ((float)dimension.width - jEuclidView.getWidth()) / 2.0f);
        float f2 = jMathComponent.getVerticalAlignment() == 1 ? jEuclidView.getAscentHeight() : (jMathComponent.getVerticalAlignment() == 3 ? (float)dimension.height - jEuclidView.getDescentHeight() : ((float)dimension.height + jEuclidView.getAscentHeight() - jEuclidView.getDescentHeight()) / 2.0f);
        return new Point2D.Float(f, f2);
    }

    private void paintBackground(Graphics graphics, JComponent jComponent, Dimension dimension, Point point) {
        Color color = this.getRealBackgroundColor(jComponent);
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(point.x, point.y, dimension.width, dimension.height);
        }
    }

    private Point getStartPointWithBordersAndAdjustDimension(JComponent jComponent, Dimension dimension) {
        Insets insets;
        Point point = new Point(0, 0);
        Border border = jComponent.getBorder();
        if (border != null && (insets = border.getBorderInsets(jComponent)) != null) {
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            point = new Point(insets.left, insets.top);
        }
        return point;
    }

    private Color getRealBackgroundColor(JComponent jComponent) {
        Color color = jComponent.getBackground();
        if (jComponent.isOpaque()) {
            if (color == null) {
                color = Color.WHITE;
            }
            color = new Color(color.getRGB());
        }
        return color;
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (!(jComponent instanceof JMathComponent)) {
            throw new IllegalArgumentException("This UI can only be installed on a JMathComponent");
        }
        jComponent.addPropertyChangeListener(this);
        this.installDefaults(jComponent);
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installProperty(jComponent, "opaque", Boolean.FALSE);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this);
        this.contextCache.remove(jComponent);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.contextCache.remove(propertyChangeEvent.getSource());
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMathComponentSize(jComponent);
    }

    private Dimension getMathComponentSize(JComponent jComponent) {
        JEuclidView jEuclidView = this.getJeuclidView(jComponent.getGraphics(), jComponent);
        return this.calculatePreferredSize(jComponent, jEuclidView);
    }

    private Dimension calculatePreferredSize(JComponent jComponent, JEuclidView jEuclidView) {
        Insets insets;
        Dimension dimension = new Dimension((int)Math.ceil(jEuclidView.getWidth()), (int)Math.ceil(jEuclidView.getAscentHeight() + jEuclidView.getDescentHeight()));
        Border border = jComponent.getBorder();
        if (border != null && (insets = border.getBorderInsets(jComponent)) != null) {
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
        }
        return dimension;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getMathComponentSize(jComponent);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getMathComponentSize(jComponent);
    }

    public List<JEuclidView.NodeRect> getNodesAt(JMathComponent jMathComponent, float f, float f2) {
        JEuclidView jEuclidView = this.getJeuclidView(jMathComponent.getGraphics(), jMathComponent);
        Point2D point2D = this.calculateAlignmentOffset(jMathComponent, jEuclidView, jMathComponent.getSize());
        return jEuclidView.getNodesAt(f, f2, (float)point2D.getX(), (float)point2D.getY());
    }

    private static class ViewContext {
        final Node document;
        final LayoutContext layoutContext;
        final Map<Graphics2D, JEuclidView> jeuclidViews = new HashMap<Graphics2D, JEuclidView>();

        public ViewContext(JMathComponent jMathComponent) {
            this.document = jMathComponent.getDocument();
            this.layoutContext = jMathComponent.getParameters();
        }

        public JEuclidView getJeculidView(Graphics2D graphics2D) {
            JEuclidView jEuclidView = this.jeuclidViews.get(graphics2D);
            if (jEuclidView == null) {
                jEuclidView = new JEuclidView(this.document, this.layoutContext, graphics2D);
                this.jeuclidViews.put(graphics2D, jEuclidView);
            }
            return jEuclidView;
        }
    }
}

