/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView;

import java.awt.Component;
import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.BuffersManager;
import org.scilab.forge.scirenderer.buffers.DataBuffer;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.texture.AbstractTextureDataProvider;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDataProvider;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.tranformations.TransformationStack;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.forge.scirenderer.utils.shapes.geometry.CubeFactory;
import org.scilab.modules.graphic_objects.ObjectRemovedException;
import org.scilab.modules.graphic_objects.arc.Arc;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.axes.AxesContainer;
import org.scilab.modules.graphic_objects.axes.Camera;
import org.scilab.modules.graphic_objects.axis.Axis;
import org.scilab.modules.graphic_objects.compound.Compound;
import org.scilab.modules.graphic_objects.contouredObject.ContouredObject;
import org.scilab.modules.graphic_objects.datatip.Datatip;
import org.scilab.modules.graphic_objects.fec.Fec;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;
import org.scilab.modules.graphic_objects.graphicView.GraphicView;
import org.scilab.modules.graphic_objects.imageplot.Grayplot;
import org.scilab.modules.graphic_objects.imageplot.Matplot;
import org.scilab.modules.graphic_objects.label.Label;
import org.scilab.modules.graphic_objects.legend.Legend;
import org.scilab.modules.graphic_objects.polyline.Polyline;
import org.scilab.modules.graphic_objects.rectangle.Rectangle;
import org.scilab.modules.graphic_objects.surface.Fac3d;
import org.scilab.modules.graphic_objects.surface.Plot3d;
import org.scilab.modules.graphic_objects.textObject.Text;
import org.scilab.modules.graphic_objects.uicontrol.frame.Frame;
import org.scilab.modules.graphic_objects.vectfield.Arrow;
import org.scilab.modules.graphic_objects.vectfield.Champ;
import org.scilab.modules.graphic_objects.vectfield.Segs;
import org.scilab.modules.renderer.JoGLView.AxisDrawer;
import org.scilab.modules.renderer.JoGLView.DataManager;
import org.scilab.modules.renderer.JoGLView.Fac3dDrawer;
import org.scilab.modules.renderer.JoGLView.FecDrawer;
import org.scilab.modules.renderer.JoGLView.ScilabTextureManager;
import org.scilab.modules.renderer.JoGLView.arrowDrawing.ArrowDrawer;
import org.scilab.modules.renderer.JoGLView.axes.AxesDrawer;
import org.scilab.modules.renderer.JoGLView.contouredObject.ContouredObjectDrawer;
import org.scilab.modules.renderer.JoGLView.datatip.DatatipDisplayModeManager;
import org.scilab.modules.renderer.JoGLView.datatip.DatatipTextDrawer;
import org.scilab.modules.renderer.JoGLView.interaction.InteractionManager;
import org.scilab.modules.renderer.JoGLView.label.LabelManager;
import org.scilab.modules.renderer.JoGLView.legend.LegendDrawer;
import org.scilab.modules.renderer.JoGLView.mark.MarkSpriteManager;
import org.scilab.modules.renderer.JoGLView.postRendering.PostRendered;
import org.scilab.modules.renderer.JoGLView.text.TextManager;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.JoGLView.util.LightingUtils;
import org.scilab.modules.renderer.JoGLView.util.OutOfMemoryException;
import org.scilab.modules.renderer.JoGLView.util.PixelDrawingModeUtils;

public class DrawerVisitor
implements Visitor,
Drawer,
GraphicView {
    private static final Set<Integer> X_AXIS_TICKS_PROPERTIES = new HashSet<Integer>(Arrays.asList(123, 124, 125));
    private static final Set<Integer> Y_AXIS_TICKS_PROPERTIES = new HashSet<Integer>(Arrays.asList(140, 141, 142));
    private static final Set<Integer> Z_AXIS_TICKS_PROPERTIES = new HashSet<Integer>(Arrays.asList(157, 158, 159));
    private static final Set<Integer> SILENT_FIGURE_PROPERTIES = new HashSet<Integer>(Arrays.asList(100, 89, 86, 83, 80, 81, 88));
    private static final boolean DEBUG_MODE = false;
    private final Component component;
    private final AxesContainer figure;
    private final InteractionManager interactionManager;
    private final ColorMapTextureDataProvider colorMapTextureDataProvider;
    private final ScilabTextureManager textureManager;
    private final MarkSpriteManager markManager;
    private final LabelManager labelManager;
    private final DataManager dataManager;
    private final TextManager textManager;
    private final ContouredObjectDrawer contouredObjectDrawer;
    private final LegendDrawer legendDrawer;
    protected final AxesDrawer axesDrawer;
    private final AxisDrawer axisDrawer;
    private final ArrowDrawer arrowDrawer;
    private final FecDrawer fecDrawer;
    private final Fac3dDrawer fac3dDrawer;
    private final DatatipTextDrawer datatipTextDrawer;
    private DatatipDisplayModeManager datatipDisplayModeManager;
    private DrawingTools drawingTools;
    private Texture colorMapTexture;
    private ColorMap colorMap;
    private Axes currentAxes;
    private Canvas canvas;
    private static final Map<Integer, DrawerVisitor> visitorMap = new HashMap<Integer, DrawerVisitor>();
    private final List<PostRendered> postRenderedList = new LinkedList<PostRendered>();
    private static final Map<Integer, List<Integer>> openGLChildren = new HashMap<Integer, List<Integer>>();
    private Geometry cube;

    public static int[] getSize() {
        return new int[]{visitorMap.size(), openGLChildren.size()};
    }

    public DrawerVisitor(Component component, Canvas canvas, AxesContainer axesContainer) {
        GraphicController.getController().register((GraphicView)this);
        this.component = component;
        this.canvas = canvas;
        this.figure = axesContainer;
        this.interactionManager = new InteractionManager(this);
        this.dataManager = new DataManager(canvas);
        this.textureManager = new ScilabTextureManager(this);
        this.markManager = new MarkSpriteManager(canvas.getTextureManager());
        this.textManager = new TextManager(canvas.getTextureManager());
        this.labelManager = new LabelManager(canvas.getTextureManager());
        this.axesDrawer = new AxesDrawer(this);
        this.axisDrawer = new AxisDrawer(this);
        this.arrowDrawer = new ArrowDrawer(this);
        this.contouredObjectDrawer = new ContouredObjectDrawer(this, this.dataManager, this.markManager);
        this.legendDrawer = new LegendDrawer(this);
        this.fecDrawer = new FecDrawer(this);
        this.fac3dDrawer = new Fac3dDrawer(this);
        this.colorMapTextureDataProvider = new ColorMapTextureDataProvider();
        this.datatipTextDrawer = new DatatipTextDrawer(canvas);
        this.datatipDisplayModeManager = new DatatipDisplayModeManager(component);
        visitorMap.put(axesContainer.getIdentifier(), this);
    }

    public static void changeVisitor(AxesContainer axesContainer, DrawerVisitor drawerVisitor) {
        if (drawerVisitor == null) {
            visitorMap.remove(axesContainer.getIdentifier());
        } else {
            visitorMap.put(axesContainer.getIdentifier(), drawerVisitor);
        }
    }

    public void setDrawingTools(DrawingTools drawingTools) {
        this.drawingTools = drawingTools;
    }

    public DrawingTools getDrawingTools() {
        return this.drawingTools;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public TextManager getTextManager() {
        return this.textManager;
    }

    public LegendDrawer getLegendDrawer() {
        return this.legendDrawer;
    }

    public MarkSpriteManager getMarkManager() {
        return this.markManager;
    }

    public AxesDrawer getAxesDrawer() {
        return this.axesDrawer;
    }

    public ArrowDrawer getArrowDrawer() {
        return this.arrowDrawer;
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public DatatipTextDrawer getDatatipTextDrawer() {
        return this.datatipTextDrawer;
    }

    public static DrawerVisitor getVisitor(Integer n) {
        return visitorMap.get(n);
    }

    public void addPostRendering(PostRendered postRendered) {
        if (postRendered != null) {
            this.postRenderedList.add(postRendered);
        }
    }

    public void removePostRendering(PostRendered postRendered) {
        this.postRenderedList.remove(postRendered);
    }

    public void draw(DrawingTools drawingTools) {
        this.drawingTools = drawingTools;
        if (this.figure instanceof Figure) {
            if (((Figure)this.figure).isValid().booleanValue()) {
                this.visit((Figure)this.figure);
            }
        } else if (((Frame)this.figure).isValid().booleanValue()) {
            this.visit((Frame)this.figure);
        }
        for (PostRendered postRendered : this.postRenderedList) {
            try {
                postRendered.draw(drawingTools);
            }
            catch (SciRendererException sciRendererException) {
                System.err.println("A 'PostRendered' is not drawable because: '" + sciRendererException.getMessage() + "'");
            }
        }
        drawingTools.getTransformationManager().useSceneCoordinate();
    }

    public void askAcceptVisitor(Integer[] integerArray) {
        if (integerArray != null) {
            for (int i = integerArray.length - 1; i >= 0; --i) {
                GraphicObject graphicObject = GraphicController.getController().getObjectFromId(integerArray[i]);
                if (graphicObject == null) continue;
                try {
                    graphicObject.accept((Visitor)this);
                    continue;
                }
                catch (ObjectRemovedException objectRemovedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean is2DView() {
        return this.currentAxes.getViewAsEnum() == Camera.ViewType.VIEW_2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Axes axes) {
        Axes axes2 = axes;
        synchronized (axes2) {
            if (axes.isValid().booleanValue() && axes.getVisible().booleanValue()) {
                try {
                    ColorMap colorMap = this.getColorMap();
                    if (axes.getColorMap().getSize() != 0) {
                        this.colorMap = axes.getColorMap();
                    }
                    this.currentAxes = axes;
                    this.axesDrawer.computeRulers(axes);
                    this.axesDrawer.draw(axes);
                    this.colorMap = colorMap;
                }
                catch (SciRendererException sciRendererException) {
                    this.invalidate((GraphicObject)axes, (Exception)((Object)sciRendererException));
                }
            }
        }
    }

    public void visit(Arc arc) {
        if (arc.isValid().booleanValue() && arc.getVisible().booleanValue()) {
            this.axesDrawer.enableClipping(this.currentAxes, arc.getClipProperty());
            try {
                this.contouredObjectDrawer.draw((ContouredObject)arc, this.currentAxes.getViewAsEnum() == Camera.ViewType.VIEW_2D);
            }
            catch (OutOfMemoryException outOfMemoryException) {
                this.invalidate((GraphicObject)arc, outOfMemoryException);
            }
            catch (SciRendererException sciRendererException) {
                this.invalidate((GraphicObject)arc, (Exception)((Object)sciRendererException));
            }
            catch (ObjectRemovedException objectRemovedException) {
                this.invalidate((GraphicObject)arc, (Exception)((Object)objectRemovedException));
            }
            this.axesDrawer.disableClipping(arc.getClipProperty());
        }
    }

    public void visit(Axis axis) {
        if (axis.getVisible().booleanValue()) {
            this.axesDrawer.enableClipping(this.currentAxes, axis.getClipProperty());
            this.axisDrawer.draw(this.currentAxes, axis);
            this.axesDrawer.disableClipping(axis.getClipProperty());
        }
    }

    public void visit(Compound compound) {
        if (compound.getVisible().booleanValue()) {
            this.askAcceptVisitor(compound.getChildren());
        }
    }

    public void visit(Fec fec) throws ObjectRemovedException {
        if (fec.isValid().booleanValue() && fec.getVisible().booleanValue()) {
            this.axesDrawer.enableClipping(this.currentAxes, fec.getClipProperty());
            try {
                this.fecDrawer.draw(fec);
            }
            catch (OutOfMemoryException outOfMemoryException) {
                this.invalidate((GraphicObject)fec, outOfMemoryException);
            }
            this.axesDrawer.disableClipping(fec.getClipProperty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Figure figure) {
        Figure figure2 = figure;
        synchronized (figure2) {
            try {
                Dimension dimension = this.getCanvas().getDimension();
                this.colorMap = figure.getColorMap();
                this.drawingTools.clear(ColorFactory.createColor(this.colorMap, figure.getBackground()));
                this.drawingTools.clearDepthBuffer();
                if (this.drawingTools instanceof JoGLDrawingTools) {
                    ((JoGLDrawingTools)this.drawingTools).setPixelDrawingMode(PixelDrawingModeUtils.figureToJoGLmode(figure.getPixelDrawingModeAsEnum()));
                }
                if (figure.isValid().booleanValue() && figure.getVisible().booleanValue() && figure.getImmediateDrawing().booleanValue() && dimension.width > 1 && dimension.height > 1) {
                    this.askAcceptVisitor(figure.getChildren());
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Frame frame) {
        Frame frame2 = frame;
        synchronized (frame2) {
            try {
                DrawerVisitor drawerVisitor;
                this.colorMap = frame.getColorMap();
                this.drawingTools.clear(ColorFactory.createColor(this.colorMap, frame.getBackground()));
                this.drawingTools.clearDepthBuffer();
                if (frame.isValid().booleanValue() && frame.getVisible().booleanValue() && (drawerVisitor = visitorMap.get(frame.getIdentifier())) != null) {
                    Dimension dimension = drawerVisitor.getCanvas().getDimension();
                    drawerVisitor.setDrawingTools(this.drawingTools);
                    if (dimension.width > 1 && dimension.height > 1) {
                        drawerVisitor.askAcceptVisitor(frame.getChildren());
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    public void visit(Grayplot grayplot) {
        if (grayplot.isValid().booleanValue() && grayplot.getVisible().booleanValue()) {
            this.axesDrawer.enableClipping(this.currentAxes, grayplot.getClipProperty());
            try {
                DefaultGeometry defaultGeometry = new DefaultGeometry();
                defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.TRIANGLES);
                defaultGeometry.setVertices(this.dataManager.getVertexBuffer(grayplot.getIdentifier()));
                defaultGeometry.setColors(this.dataManager.getColorBuffer(grayplot.getIdentifier()));
                defaultGeometry.setIndices(this.dataManager.getIndexBuffer(grayplot.getIdentifier()));
                defaultGeometry.setFaceCullingMode(Geometry.FaceCullingMode.BOTH);
                Appearance appearance = new Appearance();
                this.drawingTools.draw((Geometry)defaultGeometry, appearance);
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
            }
            this.axesDrawer.disableClipping(grayplot.getClipProperty());
        }
    }

    public void visit(Matplot matplot) {
        if (matplot.isValid().booleanValue() && matplot.getVisible().booleanValue()) {
            this.axesDrawer.enableClipping(this.currentAxes, matplot.getClipProperty());
            try {
                if (this.currentAxes != null && (this.currentAxes.getXAxisLogFlag().booleanValue() || this.currentAxes.getYAxisLogFlag().booleanValue())) {
                    DefaultGeometry defaultGeometry = new DefaultGeometry();
                    defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.TRIANGLES);
                    defaultGeometry.setVertices(this.dataManager.getVertexBuffer(matplot.getIdentifier()));
                    defaultGeometry.setColors(this.dataManager.getColorBuffer(matplot.getIdentifier()));
                    defaultGeometry.setIndices(this.dataManager.getIndexBuffer(matplot.getIdentifier()));
                    defaultGeometry.setFaceCullingMode(Geometry.FaceCullingMode.BOTH);
                    Appearance appearance = new Appearance();
                    this.drawingTools.draw((Geometry)defaultGeometry, appearance);
                } else {
                    TransformationStack transformationStack = this.drawingTools.getTransformationManager().getModelViewStack();
                    double[][] dArray = this.currentAxes.getScaleTranslateFactors();
                    Transformation transformation = matplot.getScale();
                    Double[] doubleArray = matplot.getTranslate();
                    Transformation transformation2 = transformation;
                    Double.valueOf(transformation2[0] * dArray[0][0]);
                    transformation2 = transformation;
                    Double.valueOf(transformation2[1] * dArray[0][1]);
                    doubleArray[0] = doubleArray[0] * dArray[0][0] + dArray[1][0];
                    doubleArray[1] = doubleArray[1] * dArray[0][1] + dArray[1][1];
                    transformation2 = TransformationFactory.getTranslateTransformation((double)doubleArray[0], (double)doubleArray[1], (double)0.0);
                    Transformation transformation3 = TransformationFactory.getScaleTransformation((double)transformation[0].doubleValue(), (double)transformation[1].doubleValue(), (double)1.0);
                    transformationStack.pushRightMultiply(transformation2);
                    transformationStack.pushRightMultiply(transformation3);
                    this.drawingTools.draw(this.textureManager.getTexture(matplot.getIdentifier()));
                    transformationStack.pop();
                    transformationStack.pop();
                }
            }
            catch (ObjectRemovedException objectRemovedException) {
                this.invalidate((GraphicObject)matplot, (Exception)((Object)objectRemovedException));
            }
            catch (SciRendererException sciRendererException) {
                this.invalidate((GraphicObject)matplot, (Exception)((Object)sciRendererException));
            }
            catch (OutOfMemoryException outOfMemoryException) {
                this.invalidate((GraphicObject)matplot, outOfMemoryException);
            }
            this.axesDrawer.disableClipping(matplot.getClipProperty());
        }
    }

    public void visit(Label label) {
        if (label.isValid().booleanValue() && label.getVisible().booleanValue() && !label.isEmpty()) {
            try {
                this.labelManager.draw(this.drawingTools, this.colorMap, label, this.axesDrawer);
            }
            catch (SciRendererException sciRendererException) {
                this.invalidate((GraphicObject)label, (Exception)((Object)sciRendererException));
            }
        }
    }

    public void visit(Legend legend) {
        if (legend.isValid().booleanValue() && legend.getVisible().booleanValue()) {
            try {
                this.legendDrawer.draw(legend);
            }
            catch (SciRendererException sciRendererException) {
                this.invalidate((GraphicObject)legend, (Exception)((Object)sciRendererException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Polyline polyline) {
        Polyline polyline2 = polyline;
        synchronized (polyline2) {
            if (polyline.isValid().booleanValue() && polyline.getVisible().booleanValue()) {
                this.axesDrawer.enableClipping(this.currentAxes, polyline.getClipProperty());
                try {
                    Object object;
                    DefaultGeometry defaultGeometry = new DefaultGeometry();
                    defaultGeometry.setVertices(this.dataManager.getVertexBuffer(polyline.getIdentifier()));
                    defaultGeometry.setIndices(this.dataManager.getIndexBuffer(polyline.getIdentifier()));
                    defaultGeometry.setWireIndices(this.dataManager.getWireIndexBuffer(polyline.getIdentifier()));
                    int n = polyline.getPolylineStyle();
                    if (n == 1 || n == 2 || n == 4 || n == 5) {
                        defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS_STRIP);
                    } else {
                        defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
                    }
                    defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.TRIANGLES);
                    defaultGeometry.setFaceCullingMode(Geometry.FaceCullingMode.BOTH);
                    defaultGeometry.setPolygonOffsetMode(this.currentAxes.getCamera().getView() == Camera.ViewType.VIEW_3D);
                    Appearance appearance = new Appearance();
                    if (polyline.getInterpColorMode().booleanValue() && n == 1) {
                        defaultGeometry.setTextureCoordinates(this.dataManager.getTextureCoordinatesBuffer(polyline.getIdentifier()));
                        appearance.setTexture(this.getColorMapTexture());
                    } else if (polyline.getColorSet().booleanValue()) {
                        object = this.dataManager.getColorBuffer(polyline.getIdentifier());
                        defaultGeometry.setColors((ElementsBuffer)object);
                        appearance.setLineColor(null);
                    } else {
                        defaultGeometry.setColors(null);
                        appearance.setLineColor(ColorFactory.createColor(this.colorMap, polyline.getLineColor()));
                    }
                    object = polyline.getSelected() != false ? polyline.getSelectedColor() : polyline.getLineColor();
                    appearance.setLineColor(ColorFactory.createColor(this.colorMap, (Integer)object));
                    appearance.setLineWidth(polyline.getLineThickness().floatValue());
                    appearance.setLinePattern(polyline.getLineStyleAsEnum().asPattern());
                    if (!polyline.getInterpColorMode().booleanValue() || n != 1) {
                        int n2 = n == 5 ? ((Integer)object).intValue() : polyline.getBackground().intValue();
                        appearance.setFillColor(ColorFactory.createColor(this.colorMap, n2));
                    }
                    this.drawingTools.draw((Geometry)defaultGeometry, appearance);
                    if (n == 4) {
                        this.arrowDrawer.drawArrows(polyline.getParentAxes(), polyline.getIdentifier(), polyline.getArrowSizeFactor(), polyline.getLineThickness(), false, false, (Integer)object, true);
                    }
                    if (polyline.getMarkMode().booleanValue()) {
                        ElementsBuffer elementsBuffer = this.dataManager.getVertexBuffer(polyline.getIdentifier());
                        int n3 = polyline.getMarkOffset();
                        int n4 = polyline.getMarkStride();
                        if (polyline.getColorSet().booleanValue() && polyline.getNumMarkForegrounds() > 0 || polyline.getNumMarkBackgrounds() > 0) {
                            ElementsBuffer elementsBuffer2 = this.dataManager.getColorBuffer(polyline.getIdentifier());
                            Color color = polyline.getNumMarkBackgrounds() > 0 ? ColorFactory.createColor(this.colorMap, polyline.getMark().getForeground()) : ColorFactory.createColor(this.colorMap, polyline.getMark().getBackground());
                            FloatBuffer floatBuffer = elementsBuffer.getData();
                            FloatBuffer floatBuffer2 = elementsBuffer2.getData();
                            Integer[] integerArray = polyline.getMarkSizes();
                            if (integerArray.length > 0 && floatBuffer != null && floatBuffer2 != null && elementsBuffer.getSize() == integerArray.length && elementsBuffer2.getSize() == integerArray.length) {
                                Integer n5 = polyline.getMarkSize();
                                floatBuffer.rewind();
                                floatBuffer2.rewind();
                                n4 = n4 < 1 ? 1 : n4;
                                n3 = n3 < 0 ? 0 : n3;
                                int n6 = elementsBuffer.getElementsSize();
                                int n7 = n3 * n6;
                                int n8 = 0;
                                while (floatBuffer.remaining() >= n4 * n6) {
                                    polyline.getMark().setSize(integerArray[n8++]);
                                    BuffersManager buffersManager = this.drawingTools.getCanvas().getBuffersManager();
                                    ElementsBuffer elementsBuffer3 = buffersManager.createElementsBuffer();
                                    ElementsBuffer elementsBuffer4 = buffersManager.createElementsBuffer();
                                    float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                                    floatBuffer.position(n7);
                                    floatBuffer.get(fArray);
                                    float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                                    floatBuffer2.position(n7);
                                    floatBuffer2.get(fArray2);
                                    n7 += n4 * n6;
                                    elementsBuffer3.setData(fArray, n6);
                                    elementsBuffer4.setData(fArray2, n6);
                                    Texture texture = this.markManager.getMarkSprite((ContouredObject)polyline, null, appearance);
                                    this.drawingTools.draw(texture, AnchorPosition.CENTER, elementsBuffer3, 0, 0, 0.0, color, elementsBuffer4);
                                    buffersManager.dispose((DataBuffer)elementsBuffer4);
                                    buffersManager.dispose((DataBuffer)elementsBuffer3);
                                }
                                polyline.getMark().setSize(n5);
                            } else {
                                Texture texture = this.markManager.getMarkSprite((ContouredObject)polyline, null, appearance);
                                this.drawingTools.draw(texture, AnchorPosition.CENTER, elementsBuffer, n3, n4, 0.0, color, elementsBuffer2);
                            }
                        } else {
                            FloatBuffer floatBuffer = elementsBuffer.getData();
                            Integer[] integerArray = polyline.getMarkSizes();
                            if (integerArray.length > 0 && floatBuffer != null && elementsBuffer.getSize() == integerArray.length) {
                                Integer n9 = polyline.getMarkSize();
                                floatBuffer.rewind();
                                n4 = n4 < 1 ? 1 : n4;
                                n3 = n3 < 0 ? 0 : n3;
                                int n10 = elementsBuffer.getElementsSize();
                                int n11 = n3 * n10;
                                int n12 = 0;
                                while (floatBuffer.remaining() >= n4 * n10) {
                                    polyline.getMark().setSize(integerArray[n12++]);
                                    BuffersManager buffersManager = this.drawingTools.getCanvas().getBuffersManager();
                                    ElementsBuffer elementsBuffer5 = buffersManager.createElementsBuffer();
                                    float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                                    floatBuffer.position(n11);
                                    floatBuffer.get(fArray);
                                    n11 += n4 * n10;
                                    elementsBuffer5.setData(fArray, n10);
                                    Texture texture = this.markManager.getMarkSprite((ContouredObject)polyline, this.colorMap, appearance);
                                    this.drawingTools.draw(texture, AnchorPosition.CENTER, elementsBuffer5, 0, 0, 0.0, null, null);
                                    buffersManager.dispose((DataBuffer)elementsBuffer5);
                                }
                                polyline.getMark().setSize(n9);
                            } else {
                                Texture texture = this.markManager.getMarkSprite((ContouredObject)polyline, this.colorMap, appearance);
                                this.drawingTools.draw(texture, AnchorPosition.CENTER, elementsBuffer, n3, n4, 0.0, null, null);
                            }
                        }
                    }
                }
                catch (ObjectRemovedException objectRemovedException) {
                    this.invalidate((GraphicObject)polyline, (Exception)((Object)objectRemovedException));
                }
                catch (OutOfMemoryException outOfMemoryException) {
                    this.invalidate((GraphicObject)polyline, outOfMemoryException);
                }
                catch (SciRendererException sciRendererException) {
                    this.invalidate((GraphicObject)polyline, (Exception)((Object)sciRendererException));
                }
                this.axesDrawer.disableClipping(polyline.getClipProperty());
                this.askAcceptVisitor(polyline.getDatatips());
            }
        }
    }

    public void visit(Rectangle rectangle) {
        if (rectangle.isValid().booleanValue() && rectangle.getVisible().booleanValue()) {
            this.axesDrawer.enableClipping(this.currentAxes, rectangle.getClipProperty());
            try {
                this.contouredObjectDrawer.draw((ContouredObject)rectangle, this.currentAxes.getCamera().getView() == Camera.ViewType.VIEW_2D);
            }
            catch (ObjectRemovedException objectRemovedException) {
                this.invalidate((GraphicObject)rectangle, (Exception)((Object)objectRemovedException));
            }
            catch (OutOfMemoryException outOfMemoryException) {
                this.invalidate((GraphicObject)rectangle, outOfMemoryException);
            }
            catch (SciRendererException sciRendererException) {
                this.invalidate((GraphicObject)rectangle, (Exception)((Object)sciRendererException));
            }
            this.axesDrawer.disableClipping(rectangle.getClipProperty());
        }
    }

    public void visit(Fac3d fac3d) throws ObjectRemovedException {
        if (fac3d.isValid().booleanValue() && fac3d.getVisible().booleanValue()) {
            this.axesDrawer.enableClipping(this.currentAxes, fac3d.getClipProperty());
            try {
                this.fac3dDrawer.draw(fac3d);
            }
            catch (OutOfMemoryException outOfMemoryException) {
                this.invalidate((GraphicObject)fac3d, outOfMemoryException);
            }
            this.axesDrawer.disableClipping(fac3d.getClipProperty());
        }
    }

    public void visit(Plot3d plot3d) {
        if (plot3d.isValid().booleanValue() && plot3d.getVisible().booleanValue()) {
            this.axesDrawer.enableClipping(this.currentAxes, plot3d.getClipProperty());
            try {
                Object object;
                ElementsBuffer elementsBuffer;
                DefaultGeometry defaultGeometry;
                if (plot3d.getSurfaceMode().booleanValue()) {
                    defaultGeometry = new DefaultGeometry();
                    if (plot3d.getColorMode() != 0) {
                        defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.TRIANGLES);
                    } else {
                        defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.NONE);
                    }
                    defaultGeometry.setPolygonOffsetMode(true);
                    defaultGeometry.setVertices(this.dataManager.getVertexBuffer(plot3d.getIdentifier()));
                    defaultGeometry.setNormals(this.dataManager.getNormalBuffer(plot3d.getIdentifier()));
                    defaultGeometry.setIndices(this.dataManager.getIndexBuffer(plot3d.getIdentifier()));
                    if (plot3d.getHiddenColor() > 0) {
                        defaultGeometry.setFaceCullingMode(this.axesDrawer.getBackFaceCullingMode());
                        elementsBuffer = new Appearance();
                        elementsBuffer.setFillColor(ColorFactory.createColor(this.colorMap, plot3d.getHiddenColor()));
                        this.drawingTools.draw((Geometry)defaultGeometry, (Appearance)elementsBuffer);
                    }
                    elementsBuffer = new Appearance();
                    elementsBuffer.setMaterial(LightingUtils.getMaterial(plot3d.getMaterial()));
                    LightingUtils.setupLights(this.drawingTools.getLightManager(), this.currentAxes);
                    if (plot3d.getColorFlag() == 1) {
                        defaultGeometry.setColors(this.dataManager.getColorBuffer(plot3d.getIdentifier()));
                    } else {
                        defaultGeometry.setColors(null);
                    }
                    if (plot3d.getHiddenColor() > 0) {
                        defaultGeometry.setFaceCullingMode(this.axesDrawer.getFrontFaceCullingMode());
                    } else {
                        defaultGeometry.setFaceCullingMode(Geometry.FaceCullingMode.BOTH);
                    }
                    if (plot3d.getColorFlag() == 0) {
                        elementsBuffer.setFillColor(ColorFactory.createColor(this.colorMap, Math.abs(plot3d.getColorMode())));
                    }
                    if (plot3d.getColorMode() >= 0 && plot3d.getLineThickness() > 0.0) {
                        defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
                        defaultGeometry.setWireIndices(this.dataManager.getWireIndexBuffer(plot3d.getIdentifier()));
                        elementsBuffer.setLinePattern(plot3d.getLineStyleAsEnum().asPattern());
                        object = plot3d.getSelected() != false ? plot3d.getSelectedColor() : plot3d.getLineColor();
                        elementsBuffer.setLineColor(ColorFactory.createColor(this.colorMap, (Integer)object));
                        elementsBuffer.setLineWidth(plot3d.getLineThickness().floatValue());
                    }
                    this.drawingTools.draw((Geometry)defaultGeometry, (Appearance)elementsBuffer);
                    LightingUtils.setLightingEnable(this.drawingTools.getLightManager(), false);
                }
                if (plot3d.getMarkMode().booleanValue()) {
                    defaultGeometry = null;
                    if (plot3d.getLineThickness() > 0.0) {
                        defaultGeometry = new Appearance();
                        defaultGeometry.setLineWidth(plot3d.getLineThickness().floatValue());
                    }
                    elementsBuffer = this.dataManager.getVertexBuffer(plot3d.getIdentifier());
                    if ((plot3d.getMark().getBackground() == -3 || plot3d.getMark().getForeground() == -3) && plot3d.getColorFlag() == 1) {
                        object = this.markManager.getMarkSprite((ContouredObject)plot3d, null, (Appearance)defaultGeometry);
                        ElementsBuffer elementsBuffer2 = this.dataManager.getColorBuffer(plot3d.getIdentifier());
                        Color color = plot3d.getMark().getBackground() == -3 ? ColorFactory.createColor(this.colorMap, plot3d.getMark().getForeground()) : ColorFactory.createColor(this.colorMap, plot3d.getMark().getBackground());
                        this.drawingTools.draw((Texture)object, AnchorPosition.CENTER, elementsBuffer, color, elementsBuffer2);
                    } else {
                        object = this.markManager.getMarkSprite((ContouredObject)plot3d, this.colorMap, (Appearance)defaultGeometry);
                        this.drawingTools.draw((Texture)object, AnchorPosition.CENTER, elementsBuffer, null, null);
                    }
                }
            }
            catch (ObjectRemovedException objectRemovedException) {
                this.invalidate((GraphicObject)plot3d, (Exception)((Object)objectRemovedException));
            }
            catch (OutOfMemoryException outOfMemoryException) {
                this.invalidate((GraphicObject)plot3d, outOfMemoryException);
            }
            catch (SciRendererException sciRendererException) {
                this.invalidate((GraphicObject)plot3d, (Exception)((Object)sciRendererException));
            }
            this.axesDrawer.disableClipping(plot3d.getClipProperty());
        }
    }

    public void visit(Text text) {
        if (text.isValid().booleanValue() && text.getVisible().booleanValue()) {
            this.axesDrawer.enableClipping(this.currentAxes, text.getClipProperty());
            try {
                this.textManager.draw(this.drawingTools, this.colorMap, text);
            }
            catch (SciRendererException sciRendererException) {
                this.invalidate((GraphicObject)text, (Exception)((Object)sciRendererException));
            }
            this.axesDrawer.disableClipping(text.getClipProperty());
        }
    }

    public void visit(Datatip datatip) {
        if (datatip.isValid().booleanValue() && datatip.getVisible().booleanValue()) {
            this.axesDrawer.enableClipping(this.currentAxes, datatip.getClipProperty());
            try {
                Double[] doubleArray = this.currentAxes.getCorrectedBounds();
                Vector3d vector3d = DatatipTextDrawer.calculateAnchorPoint(datatip);
                Double d = vector3d.getX();
                Double d2 = vector3d.getY();
                Double d3 = vector3d.getZ();
                if (d >= doubleArray[0] && d <= doubleArray[1] && d2 >= doubleArray[2] && d2 <= doubleArray[3] && d3 >= doubleArray[4] && d3 <= doubleArray[5]) {
                    if (datatip.getMarkMode().booleanValue()) {
                        Texture texture = this.markManager.getMarkSprite((ContouredObject)datatip, this.colorMap, null);
                        this.drawingTools.draw(texture, AnchorPosition.CENTER, vector3d);
                    }
                    if (datatip.getTipLabelMode().booleanValue() && this.datatipDisplayModeManager.needDraw(datatip.getIdentifier())) {
                        this.datatipTextDrawer.draw(this.drawingTools, this.colorMap, datatip);
                    }
                }
            }
            catch (SciRendererException sciRendererException) {
                this.invalidate((GraphicObject)datatip, (Exception)((Object)sciRendererException));
            }
            this.axesDrawer.disableClipping(datatip.getClipProperty());
        }
    }

    public void visit(Arrow arrow) {
        System.out.println("How can I draw an arrow ?");
    }

    public void visit(Champ champ) {
        if (champ.isValid().booleanValue() && champ.getVisible().booleanValue()) {
            this.axesDrawer.enableClipping(this.currentAxes, champ.getClipProperty());
            try {
                DefaultGeometry defaultGeometry = new DefaultGeometry();
                defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.NONE);
                defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
                defaultGeometry.setVertices(this.dataManager.getVertexBuffer(champ.getIdentifier()));
                defaultGeometry.setWireIndices(this.dataManager.getWireIndexBuffer(champ.getIdentifier()));
                defaultGeometry.setFaceCullingMode(Geometry.FaceCullingMode.BOTH);
                if (champ.getColored().booleanValue()) {
                    defaultGeometry.setColors(this.dataManager.getColorBuffer(champ.getIdentifier()));
                } else {
                    defaultGeometry.setColors(null);
                }
                if (champ.getLineMode().booleanValue()) {
                    Appearance appearance = new Appearance();
                    if (champ.getColored().booleanValue()) {
                        appearance.setLineColor(null);
                    } else {
                        appearance.setLineColor(ColorFactory.createColor(this.colorMap, champ.getLineColor()));
                    }
                    appearance.setLineWidth(champ.getLineThickness().floatValue());
                    appearance.setLinePattern(champ.getLineStyleAsEnum().asPattern());
                    this.drawingTools.draw((Geometry)defaultGeometry, appearance);
                }
                if (champ.getArrowSize() != 0.0) {
                    this.arrowDrawer.drawArrows(champ.getParentAxes(), champ.getIdentifier(), champ.getArrowSize(), champ.getLineThickness(), false, champ.getColored(), champ.getLineColor(), false);
                }
            }
            catch (OutOfMemoryException outOfMemoryException) {
                this.invalidate((GraphicObject)champ, outOfMemoryException);
            }
            catch (ObjectRemovedException objectRemovedException) {
                this.invalidate((GraphicObject)champ, (Exception)((Object)objectRemovedException));
            }
            catch (SciRendererException sciRendererException) {
                this.invalidate((GraphicObject)champ, (Exception)((Object)sciRendererException));
            }
            this.axesDrawer.disableClipping(champ.getClipProperty());
        }
    }

    public void visit(Segs segs) {
        if (segs.isValid().booleanValue() && segs.getVisible().booleanValue() && segs.getArrows().size() != 0) {
            this.axesDrawer.enableClipping(this.currentAxes, segs.getClipProperty());
            try {
                Appearance appearance;
                DefaultGeometry defaultGeometry = new DefaultGeometry();
                defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.NONE);
                defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
                defaultGeometry.setVertices(this.dataManager.getVertexBuffer(segs.getIdentifier()));
                defaultGeometry.setColors(this.dataManager.getColorBuffer(segs.getIdentifier()));
                defaultGeometry.setWireIndices(this.dataManager.getWireIndexBuffer(segs.getIdentifier()));
                defaultGeometry.setFaceCullingMode(Geometry.FaceCullingMode.BOTH);
                if (segs.getLineMode().booleanValue()) {
                    appearance = new Appearance();
                    appearance.setLineColor(null);
                    appearance.setLineWidth(segs.getLineThickness().floatValue());
                    appearance.setLinePattern(segs.getLineStyleAsEnum().asPattern());
                    this.drawingTools.draw((Geometry)defaultGeometry, appearance);
                }
                if (segs.getMarkMode().booleanValue()) {
                    appearance = this.dataManager.getVertexBuffer(segs.getIdentifier());
                    appearance.getData().limit(segs.getNumberArrows() * 2 * 4);
                    if (((Arrow)segs.getArrows().get(0)).getMark().getBackground() == -3 || ((Arrow)segs.getArrows().get(0)).getMark().getForeground() == -3) {
                        Texture texture = this.markManager.getMarkSprite(segs.getIdentifier(), ((Arrow)segs.getArrows().get(0)).getMark(), null, null);
                        ElementsBuffer elementsBuffer = this.dataManager.getColorBuffer(segs.getIdentifier());
                        Color color = ((Arrow)segs.getArrows().get(0)).getMark().getBackground() == -3 ? ColorFactory.createColor(this.colorMap, ((Arrow)segs.getArrows().get(0)).getMark().getForeground()) : ColorFactory.createColor(this.colorMap, ((Arrow)segs.getArrows().get(0)).getMark().getBackground());
                        this.drawingTools.draw(texture, AnchorPosition.CENTER, (ElementsBuffer)appearance, color, elementsBuffer);
                    } else {
                        Texture texture = this.markManager.getMarkSprite(segs.getIdentifier(), ((Arrow)segs.getArrows().get(0)).getMark(), this.colorMap, null);
                        this.drawingTools.draw(texture, AnchorPosition.CENTER, (ElementsBuffer)appearance, null, null);
                    }
                    appearance.getData().limit(appearance.getData().capacity());
                }
                if (segs.getArrowSize() != 0.0) {
                    this.arrowDrawer.drawArrows(segs.getParentAxes(), segs.getIdentifier(), segs.getArrowSize(), segs.getLineThickness(), true, true, segs.getLineColor(), false);
                }
            }
            catch (OutOfMemoryException outOfMemoryException) {
                this.invalidate((GraphicObject)segs, outOfMemoryException);
            }
            catch (ObjectRemovedException objectRemovedException) {
                this.invalidate((GraphicObject)segs, (Exception)((Object)objectRemovedException));
            }
            catch (SciRendererException sciRendererException) {
                this.invalidate((GraphicObject)segs, (Exception)((Object)sciRendererException));
            }
            this.axesDrawer.disableClipping(segs.getClipProperty());
        }
    }

    public void updateObject(Integer n, int n2) {
        Figure figure;
        int n3;
        Integer n4 = (Integer)GraphicController.getController().getProperty(n, 29);
        int n5 = n3 = n4 == 19 ? (Integer)GraphicController.getController().getProperty(n, 279) : -1;
        if (n.intValue() != this.figure.getIdentifier().intValue() && (n4 == 19 && n3 != 283 || n4 == 20)) {
            return;
        }
        if (n2 == 22) {
            if (n.intValue() != this.figure.getIdentifier().intValue()) {
                return;
            }
            figure = GraphicController.getController().getObjectFromId(n).getChildren();
            List<Integer> list = openGLChildren.get(n);
            if (list == null) {
                openGLChildren.put(n, new ArrayList());
                list = openGLChildren.get(n);
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < ((Integer[])figure).length; ++i) {
                Integer n6 = (Integer)GraphicController.getController().getProperty(figure[i], 29);
                if (n6 == 19 || n6 == 20) continue;
                arrayList.add(figure[i]);
            }
            if (list.size() == arrayList.size()) {
                return;
            }
            openGLChildren.put(n, arrayList);
        }
        try {
            if (this.needUpdate(n, n2)) {
                if (90 == n2) {
                    this.labelManager.disposeAll();
                    this.dataManager.disposeAllColorBuffers();
                    this.dataManager.disposeAllTextureCoordinatesBuffers();
                    this.markManager.disposeAll();
                    this.textManager.disposeAll();
                    this.axesDrawer.disposeAll();
                    this.fecDrawer.updateAll();
                    this.fac3dDrawer.updateAll();
                    this.colorMapTextureDataProvider.update();
                    this.datatipTextDrawer.disposeAll();
                    this.textureManager.disposeAll();
                } else {
                    this.labelManager.update(n, n2);
                    this.dataManager.update(n, n2);
                    this.markManager.update(n, n2);
                    this.textManager.update(n, n2);
                    this.axesDrawer.update(n, n2);
                    this.legendDrawer.update(n, n2);
                    this.fecDrawer.update(n, n2);
                    this.fac3dDrawer.update(n, n2);
                    this.datatipTextDrawer.update(n, n2);
                }
                if (94 == n2) {
                    this.canvas.setAntiAliasingLevel(this.figure.getAntialiasing().intValue());
                }
                figure = (Figure)GraphicController.getController().getObjectFromId(this.figure.getParentFigure());
                if (this.figure.getVisible().booleanValue() && figure != null && figure.getVisible().booleanValue() && this.isImmediateDrawing(n)) {
                    if (95 == n2) {
                        this.canvas.redrawAndWait();
                    } else {
                        this.canvas.redraw();
                    }
                }
            }
            if (95 == n2 && !this.isImmediateDrawing(n)) {
                this.canvas.waitImage();
            }
        }
        catch (OutOfMemoryException outOfMemoryException) {
            this.invalidate(GraphicController.getController().getObjectFromId(n), outOfMemoryException);
        }
        catch (ObjectRemovedException objectRemovedException) {
            // empty catch block
        }
    }

    protected boolean needUpdate(Integer n, int n2) {
        int n3;
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(n);
        int n4 = (Integer)GraphicController.getController().getProperty(n, 29);
        int n5 = n3 = n4 == 19 ? (Integer)GraphicController.getController().getProperty(n, 279) : -1;
        if (graphicObject != null && (this.isFigureChild(n) || this.isFigureParent(n)) || n4 == 19 && n3 == 283 && n4 != 20 && n4 != 386) {
            Frame frame;
            if (79 == n2) {
                return false;
            }
            if (graphicObject instanceof Axes) {
                frame = (Frame)graphicObject;
                if (frame.getXAxisAutoTicks() != false && X_AXIS_TICKS_PROPERTIES.contains(n2) || frame.getYAxisAutoTicks() != false && Y_AXIS_TICKS_PROPERTIES.contains(n2) || frame.getZAxisAutoTicks().booleanValue() && Z_AXIS_TICKS_PROPERTIES.contains(n2)) {
                    return false;
                }
                if (frame.getXAxisAutoTicks() == false && X_AXIS_TICKS_PROPERTIES.contains(n2) || frame.getYAxisAutoTicks() == false && Y_AXIS_TICKS_PROPERTIES.contains(n2) || !frame.getZAxisAutoTicks().booleanValue() && Z_AXIS_TICKS_PROPERTIES.contains(n2)) {
                    this.axesDrawer.computeMargins((Axes)frame);
                    return true;
                }
                if (n2 != 22) {
                    this.axesDrawer.computeRulers((Axes)frame);
                }
            }
            if (graphicObject instanceof Label || graphicObject instanceof Legend) {
                frame = GraphicController.getController().getObjectFromId(graphicObject.getParent());
                if (frame instanceof Axes) {
                    Frame frame2 = frame;
                    if (frame2.getXAxisLabel().equals(n) || frame2.getYAxisLabel().equals(n) || frame2.getZAxisLabel().equals(n) || frame2.getTitle().equals(n)) {
                        this.labelManager.update(n, n2);
                        this.axesDrawer.computeMargins((Axes)frame2);
                    } else if (graphicObject instanceof Legend && (n2 == 236 || n2 == 238 || n2 == 260)) {
                        this.legendDrawer.update(n, n2);
                        this.axesDrawer.computeMargins((Axes)frame2);
                    }
                }
            } else if (graphicObject instanceof Figure) {
                if (n2 == 81 || n2 == 85 || n2 == 22 || n2 == 80 || n2 == 27) {
                    for (Frame frame3 : this.figure.getChildren()) {
                        GraphicObject graphicObject2 = GraphicController.getController().getObjectFromId((Integer)frame3);
                        if (!(graphicObject2 instanceof Axes)) continue;
                        this.axesDrawer.computeMargins((Axes)graphicObject2);
                        this.axesDrawer.computeRulers((Axes)graphicObject2);
                    }
                }
                if (SILENT_FIGURE_PROPERTIES.contains(n2)) {
                    return false;
                }
            } else if (graphicObject instanceof Frame && n.intValue() == this.figure.getIdentifier().intValue() && n2 == 80) {
                frame = (Frame)graphicObject;
                for (Integer n6 : frame.getChildren()) {
                    GraphicObject graphicObject3 = GraphicController.getController().getObjectFromId(n6);
                    if (!(graphicObject3 instanceof Axes)) continue;
                    this.axesDrawer.computeRulers((Axes)graphicObject3);
                }
            } else if (graphicObject instanceof Axes && n2 == 116 || n2 == 133 || n2 == 185) {
                this.axesDrawer.computeMargins((Axes)graphicObject);
            }
            if (!graphicObject.isValid().booleanValue()) {
                GraphicController.getController().setProperty(n, 79, (Object)true);
            }
            return true;
        }
        return (n2 == 90 || n2 == 95) && n.intValue() == this.figure.getParentFigure().intValue();
    }

    private boolean isImmediateDrawing(Integer n) {
        Integer n2 = (Integer)GraphicController.getController().getProperty(n, 31);
        if (this.figure instanceof Frame) {
            n2 = this.figure.getParentFigure();
        }
        if (this.figure instanceof Figure && (n2 == null || !n2.equals(this.figure.getIdentifier()))) {
            return false;
        }
        Boolean bl = (Boolean)GraphicController.getController().getProperty(n2, 95);
        return bl == null ? false : bl;
    }

    public void createObject(Integer n) {
    }

    public void deleteObject(Integer n) {
        Integer n2 = (Integer)GraphicController.getController().getProperty(n, 29);
        if (n2 == 338) {
            this.datatipDisplayModeManager.remove(n);
        }
        if (!this.figure.getIdentifier().equals(n) && n2 == 19 || n2 == 20) {
            return;
        }
        openGLChildren.remove(n);
        if (this.isImmediateDrawing(n)) {
            this.canvas.redraw();
        }
        this.dataManager.dispose(n);
        this.markManager.dispose(n);
        this.textManager.dispose(n);
        this.labelManager.dispose(n);
        this.axesDrawer.dispose(n);
        this.legendDrawer.dispose(n);
        this.fecDrawer.dispose(n);
        this.fac3dDrawer.dispose(n);
        this.textureManager.dispose(n);
        if (!this.figure.getIdentifier().equals(n)) {
            return;
        }
        visitorMap.remove(n);
        GraphicController.getController().unregister((GraphicView)this);
        if (SwingUtilities.isEventDispatchThread()) {
            this.canvas.destroy();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DrawerVisitor.this.canvas.destroy();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isFigureParent(Integer n) {
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(n);
        if (graphicObject != null) {
            Integer n2;
            Object object = GraphicController.getController().getProperty(this.figure.getIdentifier(), 24);
            Integer n3 = n2 = object == null ? Integer.valueOf(0) : (Integer)object;
            while (n2 != 0) {
                if (n2.intValue() == n.intValue()) {
                    return true;
                }
                object = GraphicController.getController().getProperty(n2, 24);
                n2 = object == null ? 0 : (Integer)object;
            }
        }
        return false;
    }

    private boolean isFigureChild(Integer n) {
        Integer n2;
        if (n.intValue() == this.figure.getIdentifier().intValue()) {
            return true;
        }
        Object object = GraphicController.getController().getProperty(n, 24);
        Integer n3 = n2 = object == null ? Integer.valueOf(0) : (Integer)object;
        while (n2 != 0) {
            if (this.figure.getIdentifier().intValue() == n2.intValue()) {
                return true;
            }
            Integer n4 = (Integer)GraphicController.getController().getProperty(n2, 279);
            if (n4 != null && n4 == 283) {
                return false;
            }
            object = GraphicController.getController().getProperty(n2, 24);
            n2 = object == null ? 0 : (Integer)object;
        }
        return false;
    }

    public void invalidate(GraphicObject graphicObject, Exception exception) {
        GraphicController.getController().setProperty(graphicObject.getIdentifier(), 79, (Object)false);
    }

    public LabelManager getLabelManager() {
        return this.labelManager;
    }

    public Texture getColorMapTexture() {
        if (this.colorMapTexture == null) {
            this.colorMapTexture = this.canvas.getTextureManager().createTexture();
            this.colorMapTexture.setMagnificationFilter(Texture.Filter.NEAREST);
            this.colorMapTexture.setMinifyingFilter(Texture.Filter.NEAREST);
            this.colorMapTexture.setSWrappingMode(Texture.Wrap.CLAMP);
            this.colorMapTexture.setTWrappingMode(Texture.Wrap.CLAMP);
            this.colorMapTexture.setDataProvider((TextureDataProvider)this.colorMapTextureDataProvider);
        }
        return this.colorMapTexture;
    }

    public AxesContainer getFigure() {
        return this.figure;
    }

    public Axes getAxes() {
        return this.currentAxes;
    }

    public Geometry getCube() {
        if (this.cube == null) {
            this.cube = CubeFactory.createCube((Canvas)this.canvas);
        }
        return this.cube;
    }

    public Component getComponent() {
        return this.component;
    }

    public InteractionManager getInteractionManager() {
        return this.interactionManager;
    }

    private class ColorMapTextureDataProvider
    extends AbstractTextureDataProvider {
        byte[] whiteColor = new byte[]{-1, -1, -1, -1};
        byte[] blackColor = new byte[]{0, 0, 0, -1};

        public ColorMapTextureDataProvider() {
            this.imageType = TextureDataProvider.ImageType.RGBA_BYTE;
        }

        public Dimension getTextureSize() {
            return new Dimension(DrawerVisitor.this.colorMap.getSize() + 2, 1);
        }

        public ByteBuffer getData() {
            Double[] doubleArray = DrawerVisitor.this.colorMap.getData();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4 * (doubleArray.length / 3 + 2));
            byteBuffer.put(this.whiteColor);
            byteBuffer.put(this.blackColor);
            for (int i = 0; i < doubleArray.length / 3; ++i) {
                byteBuffer.put(this.toByte(doubleArray[i]));
                byteBuffer.put(this.toByte(doubleArray[i + DrawerVisitor.this.colorMap.getSize()].floatValue()));
                byteBuffer.put(this.toByte(doubleArray[i + 2 * DrawerVisitor.this.colorMap.getSize()].floatValue()));
                byteBuffer.put(this.toByte(1.0));
            }
            byteBuffer.rewind();
            return byteBuffer;
        }

        public ByteBuffer getSubData(int n, int n2, int n3, int n4) {
            return this.getData();
        }

        public boolean isValid() {
            return true;
        }

        public void update() {
            this.fireUpdate();
        }
    }
}

