/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.axes.ruler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.scilab.forge.scirenderer.ruler.RulerDrawer;
import org.scilab.forge.scirenderer.ruler.RulerSpriteFactory;
import org.scilab.forge.scirenderer.texture.TextureManager;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.renderer.JoGLView.axes.ruler.AxesRulerSpriteFactory;

class RulerDrawerManager {
    private static final Set<Integer> SPRITE_PROPERTIES = new HashSet<Integer>(Arrays.asList(222, 223, 221, 224, 121, 138, 155, 119, 136, 153, 120, 137, 154, 117, 134, 151, 177));
    private final Map<Integer, RulerDrawer[]> rulerSpriteManagerMap = new HashMap<Integer, RulerDrawer[]>();
    private final TextureManager textureManager;

    public RulerDrawerManager(TextureManager textureManager) {
        this.textureManager = textureManager;
    }

    public RulerDrawer[] get(Axes axes) {
        RulerDrawer[] rulerDrawerArray = this.rulerSpriteManagerMap.get(axes.getIdentifier());
        if (rulerDrawerArray == null) {
            rulerDrawerArray = new RulerDrawer[]{new RulerDrawer(this.textureManager), new RulerDrawer(this.textureManager), new RulerDrawer(this.textureManager)};
            rulerDrawerArray[0].setSpriteFactory((RulerSpriteFactory)new AxesRulerSpriteFactory(axes, 0));
            rulerDrawerArray[1].setSpriteFactory((RulerSpriteFactory)new AxesRulerSpriteFactory(axes, 1));
            rulerDrawerArray[2].setSpriteFactory((RulerSpriteFactory)new AxesRulerSpriteFactory(axes, 2));
            this.rulerSpriteManagerMap.put(axes.getIdentifier(), rulerDrawerArray);
        }
        return rulerDrawerArray;
    }

    public boolean update(Integer n, int n2) {
        RulerDrawer[] rulerDrawerArray;
        if (SPRITE_PROPERTIES.contains(n2)) {
            this.dispose(n);
            return true;
        }
        if (n2 == 124 || n2 == 125) {
            RulerDrawer[] rulerDrawerArray2 = this.rulerSpriteManagerMap.get(n);
            if (rulerDrawerArray2 != null) {
                rulerDrawerArray2[0].disposeResources();
            }
        } else if (n2 == 141 || n2 == 142) {
            RulerDrawer[] rulerDrawerArray3 = this.rulerSpriteManagerMap.get(n);
            if (rulerDrawerArray3 != null) {
                rulerDrawerArray3[1].disposeResources();
            }
        } else if ((n2 == 158 || n2 == 159) && (rulerDrawerArray = this.rulerSpriteManagerMap.get(n)) != null) {
            rulerDrawerArray[2].disposeResources();
        }
        return false;
    }

    public void dispose(Integer n) {
        RulerDrawer[] rulerDrawerArray = this.rulerSpriteManagerMap.get(n);
        if (rulerDrawerArray != null) {
            for (RulerDrawer rulerDrawer : rulerDrawerArray) {
                if (rulerDrawer == null) continue;
                rulerDrawer.disposeResources();
            }
        }
        this.rulerSpriteManagerMap.remove(n);
    }

    public void disposeAll() {
        for (RulerDrawer[] rulerDrawerArray : this.rulerSpriteManagerMap.values()) {
            if (rulerDrawerArray == null) continue;
            for (RulerDrawer rulerDrawer : rulerDrawerArray) {
                if (rulerDrawer == null) continue;
                rulerDrawer.disposeResources();
            }
        }
        this.rulerSpriteManagerMap.clear();
    }
}

