/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.label;

import java.util.ArrayList;
import java.util.Arrays;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.renderer.JoGLView.label.LabelPositioner;

public class AxisLabelPositioner
extends LabelPositioner {
    private Vector3d ticksDirection = new Vector3d(0.0, 0.0, 0.0);
    private double distRatio = 0.0;
    private Vector3d projectedTicksDirection = new Vector3d(0.0, 0.0, 0.0);
    private static final AnchorPosition[] allowedAnchorPositionsArray = new AnchorPosition[]{AnchorPosition.LEFT, AnchorPosition.DOWN, AnchorPosition.RIGHT, AnchorPosition.UP};
    private static final ArrayList<AnchorPosition> allowedAnchorPositions = new ArrayList<AnchorPosition>(Arrays.asList(allowedAnchorPositionsArray));

    public void setTicksDirection(Vector3d vector3d) {
        this.ticksDirection = new Vector3d(vector3d);
    }

    public Vector3d getTicksDirection() {
        return this.ticksDirection;
    }

    public void setDistanceRatio(double d) {
        this.distRatio = d;
    }

    public double getDistanceRatio() {
        return this.distRatio;
    }

    public void setProjectedTicksDirection(Vector3d vector3d) {
        this.projectedTicksDirection = new Vector3d(vector3d);
    }

    public Vector3d getProjectedTicksDirection() {
        return this.projectedTicksDirection;
    }

    private double computeTicksDirectionAngle() {
        double d;
        Vector3d vector3d;
        double d2 = Math.signum(this.projectedTicksDirection.getX());
        double d3 = Math.signum(this.projectedTicksDirection.getY());
        if (this.projectedTicksDirection.getY() > Math.abs(this.projectedTicksDirection.getX())) {
            vector3d = new Vector3d(0.0, 1.0, 0.0);
            d = d2;
        } else if (this.projectedTicksDirection.getY() < -Math.abs(this.projectedTicksDirection.getX())) {
            vector3d = new Vector3d(0.0, -1.0, 0.0);
            d = -d2;
        } else if (this.projectedTicksDirection.getX() > 0.0) {
            vector3d = new Vector3d(1.0, 0.0, 0.0);
            d = -d3;
        } else {
            vector3d = new Vector3d(-1.0, 0.0, 0.0);
            d = d3;
        }
        double d4 = vector3d.scalar(this.projectedTicksDirection);
        double d5 = Math.acos(d4) * 180.0 / Math.PI;
        return d5 *= d;
    }

    @Override
    protected Vector3d computeDisplacedPosition() {
        Vector3d vector3d = new Vector3d(this.labelPosition);
        this.labelDisplacement = this.ticksDirection.times(this.distRatio);
        vector3d = vector3d.plus(this.labelDisplacement);
        return vector3d;
    }

    @Override
    protected double getAutoRotationAngle() {
        return 0.0;
    }

    @Override
    protected AnchorPosition getAutoAnchorPosition() {
        AnchorPosition anchorPosition = this.getUncorrectedAutoAnchorPosition();
        double d = this.computeTicksDirectionAngle();
        double d2 = this.rotationAngle % 360.0;
        int n = 0;
        n = allowedAnchorPositions.indexOf(anchorPosition);
        int n2 = (int)((Math.abs(d2 -= d) + 45.0) / 90.0);
        if (d2 < 0.0) {
            n2 = -n2;
        }
        if ((n = (n + n2) % 4) < 0) {
            n = 4 + n;
        }
        anchorPosition = allowedAnchorPositions.get(n);
        return anchorPosition;
    }

    private AnchorPosition getUncorrectedAutoAnchorPosition() {
        if (this.projectedTicksDirection.getY() > Math.abs(this.projectedTicksDirection.getX())) {
            return AnchorPosition.DOWN;
        }
        if (this.projectedTicksDirection.getY() < -Math.abs(this.projectedTicksDirection.getX())) {
            return AnchorPosition.UP;
        }
        if (this.projectedTicksDirection.getX() > 0.0) {
            return AnchorPosition.LEFT;
        }
        return AnchorPosition.RIGHT;
    }

    private AnchorPosition getAutoAnchorPosition2() {
        if (this.projectedTicksDirection.getY() > 0.0) {
            if (this.projectedTicksDirection.getY() > Math.sin(1.1780972450961724)) {
                return AnchorPosition.DOWN;
            }
            if (this.projectedTicksDirection.getY() > Math.sin(0.39269908169872414)) {
                if (this.projectedTicksDirection.getX() > 0.0) {
                    return AnchorPosition.LOWER_LEFT;
                }
                return AnchorPosition.LOWER_RIGHT;
            }
            if (this.projectedTicksDirection.getX() > 0.0) {
                return AnchorPosition.LEFT;
            }
            return AnchorPosition.RIGHT;
        }
        if (this.projectedTicksDirection.getY() < -Math.sin(1.1780972450961724)) {
            return AnchorPosition.UP;
        }
        if (this.projectedTicksDirection.getY() < -Math.sin(0.39269908169872414)) {
            if (this.projectedTicksDirection.getX() > 0.0) {
                return AnchorPosition.UPPER_LEFT;
            }
            return AnchorPosition.UPPER_RIGHT;
        }
        if (this.projectedTicksDirection.getX() > 0.0) {
            return AnchorPosition.LEFT;
        }
        return AnchorPosition.RIGHT;
    }
}

