/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.ResourceConnection;
import org.xmlresolver.ResourceRequest;
import org.xmlresolver.ResourceResponse;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.utils.URIUtils;

public class ResourceAccess {
    public static ResourceResponse getResource(ResourceRequest request) throws URISyntaxException, IOException {
        URI uri = request.getAbsoluteURI();
        if (uri == null && request.getURI() != null) {
            uri = new URI(request.getURI());
        }
        if (uri == null) {
            throw new NullPointerException("URI must not be null in getResource");
        }
        if (!uri.isAbsolute()) {
            uri = URIUtils.resolve(URIUtils.cwd(), uri.toString());
        }
        switch (uri.getScheme()) {
            case "data": {
                return ResourceAccess.getDataResource(request, uri);
            }
            case "classpath": {
                return ResourceAccess.getClasspathResource(request, uri);
            }
            case "jar": {
                return ResourceAccess.getJarResource(request, uri);
            }
        }
        return ResourceAccess.getNetResource(request, uri);
    }

    public static ResourceResponse getResource(ResourceResponse response) throws URISyntaxException, IOException {
        URI uri = response.getUnmaskedURI();
        if (uri == null && response.request != null && (uri = response.request.getAbsoluteURI()) == null && response.request.getURI() != null) {
            uri = new URI(response.request.getURI());
        }
        if (uri == null) {
            throw new NullPointerException("URI must not be null in getResource");
        }
        if (!uri.isAbsolute()) {
            uri = URIUtils.resolve(URIUtils.cwd(), uri.toString());
        }
        switch (uri.getScheme()) {
            case "data": {
                return ResourceAccess.getDataResource(response.request, uri);
            }
            case "classpath": {
                return ResourceAccess.getClasspathResource(response.request, uri);
            }
            case "jar": {
                return ResourceAccess.getJarResource(response.request, uri);
            }
        }
        return ResourceAccess.getNetResource(response.request, uri);
    }

    private static ResourceResponse getDataResource(ResourceRequest request, URI resourceURI) throws URISyntaxException {
        ByteArrayInputStream inputStream = null;
        String contentType = null;
        String path = resourceURI.toString().substring(5);
        int pos = path.indexOf(",");
        if (pos >= 0) {
            String mediatype = path.substring(0, pos);
            String data = path.substring(pos + 1);
            if (mediatype.endsWith(";base64")) {
                inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));
                contentType = mediatype.substring(0, mediatype.length() - 7);
            } else {
                String charset = "UTF-8";
                pos = mediatype.indexOf(";charset=");
                if (pos > 0 && (pos = (charset = mediatype.substring(pos + 9)).indexOf(";")) >= 0) {
                    charset = charset.substring(0, pos);
                }
                try {
                    data = URLDecoder.decode(data, charset);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new IllegalArgumentException(ex);
                }
                inputStream = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
                contentType = mediatype.isEmpty() ? null : mediatype;
            }
            ResourceResponse resp = new ResourceResponse(request, resourceURI);
            resp.setInputStream(inputStream);
            resp.setContentType(contentType);
            return resp;
        }
        boolean throwExceptions = request.config.getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
        ResolverLogger logger = request.config.getFeature(ResolverFeature.RESOLVER_LOGGER);
        logger.log("request", "Comma separator missing in data: URI", new Object[0]);
        if (throwExceptions) {
            throw new URISyntaxException(resourceURI.toString(), "Comma separator missing in data: URI");
        }
        return new ResourceResponse(request);
    }

    private static ResourceResponse getClasspathResource(ResourceRequest request, URI resourceURI) {
        URL rsrc;
        String path = resourceURI.getSchemeSpecificPart();
        if (path.startsWith("/")) {
            path = path.substring(1);
            resourceURI = URI.create("classpath:" + path);
        }
        if ((rsrc = request.config.getFeature(ResolverFeature.CLASSLOADER).getResource(path)) == null) {
            return new ResourceResponse(request);
        }
        try {
            ResourceResponse resp = new ResourceResponse(request, resourceURI);
            resp.setInputStream(rsrc.openStream());
            return resp;
        }
        catch (IOException ex) {
            boolean throwExceptions = request.config.getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
            ResolverLogger logger = request.config.getFeature(ResolverFeature.RESOLVER_LOGGER);
            logger.log("request", "I/O error reading %s", resourceURI.toString());
            if (throwExceptions) {
                throw new IllegalArgumentException("I/O error reading " + resourceURI);
            }
            return new ResourceResponse(request);
        }
    }

    private static ResourceResponse getJarResource(ResourceRequest request, URI resourceURI) {
        try {
            ResourceResponse resp = new ResourceResponse(request, resourceURI);
            JarURLConnection conn = (JarURLConnection)resourceURI.toURL().openConnection();
            resp.setUri(request.getAbsoluteURI());
            resp.setInputStream(conn.getInputStream());
            resp.setEncoding(conn.getContentEncoding());
            resp.setContentType(conn.getContentType());
            return resp;
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (IOException ex) {
            boolean throwExceptions = request.config.getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
            ResolverLogger logger = request.config.getFeature(ResolverFeature.RESOLVER_LOGGER);
            logger.log("request", "I/O error reading %s", resourceURI.toString());
            if (throwExceptions) {
                throw new IllegalArgumentException("I/O error reading " + resourceURI);
            }
            return new ResourceResponse(request);
        }
    }

    private static ResourceResponse getNetResource(ResourceRequest request, URI resourceURI) {
        ResolverConfiguration config = request.config;
        ResolverLogger logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
        boolean mergeHttps = config.getFeature(ResolverFeature.MERGE_HTTPS);
        String accessList = request.isResolvingAsEntity() ? config.getFeature(ResolverFeature.ACCESS_EXTERNAL_ENTITY) : config.getFeature(ResolverFeature.ACCESS_EXTERNAL_DOCUMENT);
        URI requestURI = null;
        try {
            requestURI = request.getAbsoluteURI();
            if (requestURI == null) {
                requestURI = new URI(request.getURI());
            }
            if (!requestURI.isAbsolute()) {
                requestURI = URIUtils.cwd().resolve(requestURI.toString());
            }
            if (URIUtils.forbidAccess(accessList, requestURI.toString(), mergeHttps)) {
                if (request.isResolvingAsEntity()) {
                    logger.log("request", "resolveEntity, access denied: " + requestURI, new Object[0]);
                } else {
                    logger.log("request", "resolveURI, access denied: " + requestURI, new Object[0]);
                }
                return new ResourceResponse(request, true);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        ResourceConnection connx = new ResourceConnection(request.config, resourceURI, !request.openStream());
        URI redirect = connx.getRedirect();
        URI uri = redirect == null ? resourceURI : redirect;
        ResourceResponse resp = new ResourceResponse(request, uri);
        resp.setResolved(connx.isConnected());
        resp.setResolvedURI(uri);
        resp.setConnection(connx);
        resp.setInputStream(connx.getStream());
        resp.setHeaders(connx.getHeaders());
        resp.setContentType(connx.getContentType());
        resp.setEncoding(connx.getEncoding());
        resp.setStatusCode(connx.getStatusCode());
        if (connx.getStatusCode() >= 400) {
            resp.setResolved(false);
        }
        return resp;
    }
}

