/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.console;

import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;

public final class Console
extends GraphicObject {
    private static Console me;
    private boolean showHiddenHandles;
    private boolean showHiddenProperties;
    private ScilabMode scilabMode;
    private boolean useDeprecatedLF = false;
    private boolean toolbarVisible = false;

    private Console() {
    }

    public static Console getConsole() {
        if (me == null) {
            me = new Console();
        }
        return me;
    }

    @Override
    public Integer getType() {
        return 330;
    }

    public GraphicObject.UpdateStatus setScilabMode(ScilabMode scilabMode) {
        this.scilabMode = scilabMode;
        return GraphicObject.UpdateStatus.Success;
    }

    public ScilabMode getScilabMode() {
        return this.scilabMode;
    }

    public GraphicObject.UpdateStatus setShowHiddenHandles(boolean bl) {
        this.showHiddenHandles = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public boolean getShowHiddenHandles() {
        return this.showHiddenHandles;
    }

    public GraphicObject.UpdateStatus setShowHiddenProperties(boolean bl) {
        this.showHiddenProperties = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public boolean getShowHiddenProperties() {
        return this.showHiddenProperties;
    }

    @Override
    public void accept(Visitor visitor) {
    }

    @Override
    public Object getPropertyFromName(int n) {
        if (n == 331) {
            return ConsoleProperty.SHOWHIDDENHANDLES;
        }
        if (n == 332) {
            return ConsoleProperty.SHOWHIDDENPROPERTIES;
        }
        if (n == 333) {
            return ConsoleProperty.USEDEPRECATEDLF;
        }
        if (n == 365) {
            return ConsoleProperty.TOOLBARVISIBLE;
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object == ConsoleProperty.SHOWHIDDENHANDLES) {
            return this.getShowHiddenHandles();
        }
        if (object == ConsoleProperty.SHOWHIDDENPROPERTIES) {
            return this.getShowHiddenProperties();
        }
        if (object == ConsoleProperty.USEDEPRECATEDLF) {
            return this.getUseDeprecatedLF();
        }
        if (object == ConsoleProperty.TOOLBARVISIBLE) {
            return this.getToolbarVisible();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object == ConsoleProperty.SHOWHIDDENHANDLES) {
            this.setShowHiddenHandles((Boolean)object2);
        } else if (object == ConsoleProperty.SHOWHIDDENPROPERTIES) {
            this.setShowHiddenProperties((Boolean)object2);
        } else if (object == ConsoleProperty.USEDEPRECATEDLF) {
            this.setUseDeprecatedLF((Boolean)object2);
        } else if (object == ConsoleProperty.TOOLBARVISIBLE) {
            this.setToolbarVisible((Boolean)object2);
        } else {
            return super.setProperty(object, object2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public boolean getUseDeprecatedLF() {
        return this.useDeprecatedLF;
    }

    public GraphicObject.UpdateStatus setUseDeprecatedLF(boolean bl) {
        if (this.useDeprecatedLF == bl) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.useDeprecatedLF = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getToolbarVisible() {
        return this.toolbarVisible;
    }

    public GraphicObject.UpdateStatus setToolbarVisible(Boolean bl) {
        if (bl.equals(this.toolbarVisible)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.toolbarVisible = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public static enum ScilabMode {
        STD,
        NW;

    }

    private static enum ConsoleProperty {
        SHOWHIDDENHANDLES,
        SHOWHIDDENPROPERTIES,
        USEDEPRECATEDLF,
        TOOLBARVISIBLE;

    }
}

