/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.graphicView;

import javax.swing.tree.DefaultMutableTreeNode;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicView.TreeView;

public class FlattenTreeView
extends TreeView {
    private static FlattenTreeView me;

    private FlattenTreeView() {
    }

    public static void createView() {
        if (me == null) {
            me = new FlattenTreeView();
            GraphicController.getController().register(me);
            me.show();
        }
    }

    public static void deleteView() {
        if (me != null) {
            me.hide();
            GraphicController.getController().unregister(me);
            me = null;
        }
    }

    @Override
    public void createObject(Integer n) {
        try {
            GraphicObject graphicObject = GraphicController.getController().getObjectFromId(n);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new TreeView.GraphicObjectNode(graphicObject));
            this.allObjects.put(n, defaultMutableTreeNode);
            this.top.add(defaultMutableTreeNode);
            this.topModel.nodeStructureChanged(this.top);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void deleteObject(Integer n) {
        try {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.allObjects.get(n);
            if (defaultMutableTreeNode != null) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                defaultMutableTreeNode.removeFromParent();
                this.allObjects.remove(n);
                this.topModel.nodeStructureChanged(defaultMutableTreeNode2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void updateObject(Integer n, int n2) {
    }
}

