/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.surface;

import org.scilab.modules.graphic_objects.ObjectRemovedException;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;
import org.scilab.modules.graphic_objects.surface.Surface;

public class Fac3d
extends Surface {
    private DataMapping dataMapping = DataMapping.DIRECT;
    private double[] cDataBounds = new double[]{0.0, 0.0};
    private int[] colorRange = new int[]{0, 0};

    @Override
    public void accept(Visitor visitor) throws ObjectRemovedException {
        visitor.visit(this);
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 228: {
                return Fac3dProperty.DATAMAPPING;
            }
            case 229: {
                return Fac3dProperty.CDATABOUNDS;
            }
            case 227: {
                return Fac3dProperty.COLORRANGE;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object instanceof Fac3dProperty) {
            Fac3dProperty fac3dProperty = (Fac3dProperty)((Object)object);
            switch (fac3dProperty) {
                case DATAMAPPING: {
                    return this.getDataMapping();
                }
                case CDATABOUNDS: {
                    return this.getCDataBounds();
                }
                case COLORRANGE: {
                    return this.getColorRange();
                }
            }
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object instanceof Fac3dProperty) {
            Fac3dProperty fac3dProperty = (Fac3dProperty)((Object)object);
            switch (fac3dProperty) {
                case DATAMAPPING: {
                    this.setDataMapping((Integer)object2);
                    break;
                }
                case CDATABOUNDS: {
                    this.setCDataBounds((Double[])object2);
                    break;
                }
                case COLORRANGE: {
                    this.setColorRange((Integer[])object2);
                }
            }
        } else {
            return super.setProperty(object, object2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getDataMapping() {
        return this.getDataMappingAsEnum().ordinal();
    }

    public DataMapping getDataMappingAsEnum() {
        return this.dataMapping;
    }

    public GraphicObject.UpdateStatus setDataMapping(Integer n) {
        this.setDataMappingAsEnum(DataMapping.intToEnum(n));
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setDataMappingAsEnum(DataMapping dataMapping) {
        this.dataMapping = dataMapping;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer[] getColorRange() {
        Integer[] integerArray = new Integer[]{this.colorRange[0], this.colorRange[1]};
        return integerArray;
    }

    public GraphicObject.UpdateStatus setColorRange(Integer[] integerArray) {
        this.colorRange[0] = integerArray[0];
        this.colorRange[1] = integerArray[1];
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getCDataBounds() {
        Double[] doubleArray = new Double[]{this.cDataBounds[0], this.cDataBounds[1]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setCDataBounds(Double[] doubleArray) {
        this.cDataBounds[0] = doubleArray[0];
        this.cDataBounds[1] = doubleArray[1];
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Integer getType() {
        return 6;
    }

    private static enum DataMapping {
        SCALED,
        DIRECT;


        public static DataMapping intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return SCALED;
                }
                case 1: {
                    return DIRECT;
                }
            }
            return null;
        }
    }

    private static enum Fac3dProperty {
        DATAMAPPING,
        CDATABOUNDS,
        COLORRANGE;

    }
}

