/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.vectfield;

import org.scilab.modules.graphic_objects.contouredObject.ContouredObject;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;

public class Arrow
extends ContouredObject {
    private double[] base = new double[]{0.0, 0.0, 0.0};
    private double[] direction = new double[]{0.0, 0.0, 0.0};
    private double arrowSize = -1.0;

    @Override
    public Arrow clone() {
        Arrow arrow = (Arrow)super.clone();
        arrow.base = new double[]{0.0, 0.0, 0.0};
        arrow.direction = new double[]{0.0, 0.0, 0.0};
        return arrow;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 261: {
                return ArrowProperty.BASE;
            }
            case 265: {
                return ArrowProperty.DIRECTION;
            }
            case 269: {
                return ArrowProperty.ARROWSIZE;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object == ArrowProperty.BASE) {
            return this.getBase();
        }
        if (object == ArrowProperty.DIRECTION) {
            return this.getDirection();
        }
        if (object == ArrowProperty.ARROWSIZE) {
            return this.getArrowSize();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object == ArrowProperty.BASE) {
            this.setBase((Double[])object2);
        } else if (object == ArrowProperty.DIRECTION) {
            this.setDirection((Double[])object2);
        } else if (object == ArrowProperty.ARROWSIZE) {
            this.setArrowSize((Double)object2);
        } else {
            return super.setProperty(object, object2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getArrowSize() {
        return this.arrowSize;
    }

    public GraphicObject.UpdateStatus setArrowSize(Double d) {
        this.arrowSize = d;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getBase() {
        Double[] doubleArray = new Double[]{this.base[0], this.base[1], this.base[2]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setBase(Double[] doubleArray) {
        this.base[0] = doubleArray[0];
        this.base[1] = doubleArray[1];
        this.base[2] = doubleArray[2];
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getDirection() {
        Double[] doubleArray = new Double[]{this.direction[0], this.direction[1], this.direction[2]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setDirection(Double[] doubleArray) {
        this.direction[0] = doubleArray[0];
        this.direction[1] = doubleArray[1];
        this.direction[2] = doubleArray[2];
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Integer getType() {
        return -1;
    }

    public static enum ArrowProperty {
        BASE,
        BASEX,
        BASEY,
        BASEZ,
        DIRECTION,
        DIRECTIONX,
        DIRECTIONY,
        DIRECTIONZ,
        ARROWSIZE;

    }
}

