/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.xmlloader;

import java.io.File;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.modules.commons.CommonFileUtils;
import org.scilab.modules.commons.xml.ScilabXMLUtilities;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.console.Console;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicModel.GraphicModel;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.uicontrol.Uicontrol;
import org.scilab.modules.graphic_objects.uicontrol.frame.border.FrameBorder;
import org.scilab.modules.graphic_objects.uicontrol.frame.border.FrameBorderType;
import org.scilab.modules.graphic_objects.uimenu.Uimenu;
import org.scilab.modules.graphic_objects.utils.LayoutType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlSaver {
    private static Figure defaultFig = null;
    private static FrameBorder defaultBorder = null;

    public static String save(int n, String string, boolean bl) {
        try {
            Object object;
            defaultFig = GraphicModel.getFigureModel();
            defaultBorder = new FrameBorder();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setXmlStandalone(true);
            Element element = document.createElement("scilabgui");
            XmlSaver.setAttribute(element, "version", "1.0", "");
            XmlSaver.setAttribute(element, "usedeprecatedskin", XmlSaver.createAttribute(Console.getConsole().getUseDeprecatedLF()), "");
            Element element2 = XmlSaver.createFigure(document, n, bl);
            XmlSaver.appendChild(element, element2);
            XmlSaver.appendChild(document, element);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            ScilabXMLUtilities.removeEmptyLines((Node)document.getDocumentElement());
            document.getDocumentElement().normalize();
            DOMSource dOMSource = new DOMSource(document);
            File file = new File(string);
            if (!file.isAbsolute()) {
                object = CommonFileUtils.getCWD();
                file = new File((String)object + File.separator + string);
            }
            object = new StreamResult(file);
            transformer.transform(dOMSource, (Result)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return parserConfigurationException.getMessage();
        }
        catch (TransformerException transformerException) {
            return transformerException.getMessage();
        }
        defaultFig = null;
        defaultBorder = null;
        return "";
    }

    private static Element createFigure(Document document, int n, boolean bl) {
        Object[] objectArray;
        GraphicController graphicController = GraphicController.getController();
        Figure figure = (Figure)graphicController.getObjectFromId(n);
        Element element = document.createElement("figure");
        XmlSaver.setAttribute(element, "figure_position", XmlSaver.createAttribute(figure.getPosition()), XmlSaver.createAttribute(defaultFig.getPosition()));
        XmlSaver.setAttribute(element, "axes_size", XmlSaver.createAttribute(figure.getAxesSize()), XmlSaver.createAttribute(defaultFig.getAxesSize()));
        XmlSaver.setAttribute(element, "auto_resize", XmlSaver.createAttribute(figure.getAutoResize()), XmlSaver.createAttribute(defaultFig.getAutoResize()));
        XmlSaver.setAttribute(element, "view_port", XmlSaver.createAttribute(figure.getViewport()), XmlSaver.createAttribute(defaultFig.getViewport()));
        XmlSaver.setAttribute(element, "figure_name", XmlSaver.createAttribute(figure.getName()), XmlSaver.createAttribute(defaultFig.getName()));
        XmlSaver.setAttribute(element, "figure_id", XmlSaver.createAttribute(figure.getId()), XmlSaver.createAttribute(defaultFig.getId()));
        XmlSaver.setAttribute(element, "info_message", XmlSaver.createAttribute(figure.getInfoMessage()), XmlSaver.createAttribute(defaultFig.getInfoMessage()));
        XmlSaver.setAttribute(element, "pixel_drawing_mode", XmlSaver.createAttribute(figure.getPixelDrawingMode()), XmlSaver.createAttribute(defaultFig.getPixelDrawingMode()));
        XmlSaver.setAttribute(element, "anti_aliasing", XmlSaver.createAttribute(figure.getAntialiasing()), XmlSaver.createAttribute(defaultFig.getAntialiasing()));
        XmlSaver.setAttribute(element, "immediate_drawing", XmlSaver.createAttribute(figure.getImmediateDrawing()), XmlSaver.createAttribute(defaultFig.getImmediateDrawing()));
        XmlSaver.setAttribute(element, "background", XmlSaver.createAttribute(figure.getBackground()), XmlSaver.createAttribute(defaultFig.getBackground()));
        XmlSaver.setAttribute(element, "visible", XmlSaver.createAttribute(figure.getVisible()), XmlSaver.createAttribute(defaultFig.getVisible()));
        XmlSaver.setAttribute(element, "rotation_style", XmlSaver.createAttribute(Figure.RotationType.enumToString(figure.getRotationAsEnum())), XmlSaver.createAttribute(Figure.RotationType.enumToString(defaultFig.getRotationAsEnum())));
        XmlSaver.setAttribute(element, "event_handler", XmlSaver.createAttribute(figure.getEventHandlerString()), XmlSaver.createAttribute(defaultFig.getEventHandlerString()));
        XmlSaver.setAttribute(element, "event_handler_enable", XmlSaver.createAttribute(figure.getEventHandlerEnable()), XmlSaver.createAttribute(defaultFig.getEventHandlerEnable()));
        XmlSaver.setAttribute(element, "resizefcn", XmlSaver.createAttribute(figure.getResizeFcn()), XmlSaver.createAttribute(defaultFig.getResizeFcn()));
        XmlSaver.setAttribute(element, "closerequestfcn", XmlSaver.createAttribute(figure.getCloseRequestFcn()), XmlSaver.createAttribute(defaultFig.getCloseRequestFcn()));
        XmlSaver.setAttribute(element, "resize", XmlSaver.createAttribute(figure.getResize()), XmlSaver.createAttribute(defaultFig.getResize()));
        XmlSaver.setAttribute(element, "toolbar", XmlSaver.createAttribute(Figure.BarType.enumToString(figure.getToolbarAsEnum())), XmlSaver.createAttribute(Figure.BarType.enumToString(defaultFig.getToolbarAsEnum())));
        XmlSaver.setAttribute(element, "toolbar_visible", XmlSaver.createAttribute(figure.getToolbarVisible()), XmlSaver.createAttribute(defaultFig.getToolbarVisible()));
        XmlSaver.setAttribute(element, "menubar", XmlSaver.createAttribute(Figure.BarType.enumToString(figure.getMenubarAsEnum())), XmlSaver.createAttribute(Figure.BarType.enumToString(defaultFig.getMenubarAsEnum())));
        XmlSaver.setAttribute(element, "menubar_visible", XmlSaver.createAttribute(figure.getMenubarVisible()), XmlSaver.createAttribute(defaultFig.getMenubarVisible()));
        XmlSaver.setAttribute(element, "infobar_visible", XmlSaver.createAttribute(figure.getInfobarVisible()), XmlSaver.createAttribute(defaultFig.getInfobarVisible()));
        XmlSaver.setAttribute(element, "dockable", XmlSaver.createAttribute(figure.getDockable()), XmlSaver.createAttribute(defaultFig.getDockable()));
        XmlSaver.setAttribute(element, "layout", XmlSaver.createAttribute(LayoutType.enumToString(figure.getLayoutAsEnum())), XmlSaver.createAttribute(LayoutType.enumToString(defaultFig.getLayoutAsEnum())));
        XmlSaver.setAttribute(element, "default_axes", XmlSaver.createAttribute(figure.hasDefaultAxes()), XmlSaver.createAttribute(defaultFig.hasDefaultAxes()));
        XmlSaver.setAttribute(element, "icon", XmlSaver.createAttribute(figure.getIcon()), XmlSaver.createAttribute(defaultFig.getIcon()));
        XmlSaver.setAttribute(element, "tag", XmlSaver.createAttribute(figure.getTag()), XmlSaver.createAttribute(defaultFig.getTag()));
        if (figure.getLayoutAsEnum() == LayoutType.GRID) {
            XmlSaver.setAttribute(element, "grid_opt_grid", XmlSaver.createAttribute(figure.getGridOptGrid()), XmlSaver.createAttribute(defaultFig.getGridOptGrid()));
            XmlSaver.setAttribute(element, "grid_opt_padding", XmlSaver.createAttribute(figure.getGridOptPadding()), XmlSaver.createAttribute(defaultFig.getGridOptPadding()));
        } else if (figure.getLayoutAsEnum() == LayoutType.BORDER) {
            XmlSaver.setAttribute(element, "border_opt_padding", XmlSaver.createAttribute(figure.getBorderOptPadding()), XmlSaver.createAttribute(defaultFig.getBorderOptPadding()));
        }
        Integer[] integerArray = figure.getChildren();
        for (int i = 0; i < integerArray.length; ++i) {
            XmlSaver.appendChild(element, XmlSaver.createElement(document, integerArray[i], bl));
        }
        Object[] objectArray2 = figure.getColorMap().getData();
        if (!Arrays.deepEquals(objectArray2, objectArray = defaultFig.getColorMap().getData())) {
            XmlSaver.createColorMap(document, element, figure.getColorMap().getData());
        }
        return element;
    }

    public static void appendChild(Node node, Node node2) {
        if (node2 != null) {
            node.appendChild(node2);
        }
    }

    private static Element createElement(Document document, int n, boolean bl) {
        GraphicController graphicController = GraphicController.getController();
        Integer n2 = (Integer)graphicController.getProperty(n, 29);
        switch (n2) {
            case 19: {
                return XmlSaver.createUicontrol(document, n, bl);
            }
            case 20: {
                return XmlSaver.createUimenu(document, n, bl);
            }
            case 21: {
                return document.createElement("contextmenu");
            }
            case 1: {
                return XmlSaver.createAxes(document, n, bl);
            }
        }
        return document.createElement("fake");
    }

    private static Element createAxes(Document document, Integer n, boolean bl) {
        GraphicController graphicController = GraphicController.getController();
        Axes axes = (Axes)graphicController.getObjectFromId(n);
        Element element = document.createElement("axes");
        XmlSaver.setAttribute(element, "tag", XmlSaver.createAttribute(axes.getTag()), XmlSaver.createAttribute(""));
        return element;
    }

    private static Element createBorder(Document document, Integer n) {
        return XmlSaver.createBorder(document, n, "border");
    }

    private static Element createBorder(Document document, Integer n, String string) {
        GraphicController graphicController = GraphicController.getController();
        FrameBorder frameBorder = (FrameBorder)graphicController.getObjectFromId(n);
        if (frameBorder == null || frameBorder.getStyleAsEnum() == FrameBorderType.NONE) {
            return null;
        }
        Element element = document.createElement(string);
        XmlSaver.setAttribute(element, "style", XmlSaver.createAttribute(frameBorder.getStyleAsEnum().toString().toLowerCase()), "");
        switch (frameBorder.getStyleAsEnum()) {
            case BEVEL: {
                XmlSaver.setAttribute(element, "type", XmlSaver.createAttribute(frameBorder.getBorderType()), XmlSaver.createAttribute(defaultBorder.getBorderType()));
                XmlSaver.setAttribute(element, "hlout", XmlSaver.createAttribute(frameBorder.getHlOut()), XmlSaver.createAttribute(defaultBorder.getHlOut()));
                XmlSaver.setAttribute(element, "hlin", XmlSaver.createAttribute(frameBorder.getHlIn()), XmlSaver.createAttribute(defaultBorder.getHlIn()));
                XmlSaver.setAttribute(element, "shadowout", XmlSaver.createAttribute(frameBorder.getShadowOut()), XmlSaver.createAttribute(defaultBorder.getShadowOut()));
                XmlSaver.setAttribute(element, "shadowin", XmlSaver.createAttribute(frameBorder.getShadowIn()), XmlSaver.createAttribute(defaultBorder.getShadowIn()));
                break;
            }
            case COMPOUND: {
                Element element2;
                Element element3 = XmlSaver.createBorder(document, frameBorder.getOutBorder(), "out");
                if (element3 != null) {
                    XmlSaver.appendChild(element, element3);
                }
                if ((element2 = XmlSaver.createBorder(document, frameBorder.getInBorder(), "in")) == null) break;
                XmlSaver.appendChild(element, element2);
                break;
            }
            case EMPTY: {
                XmlSaver.setAttribute(element, "position", XmlSaver.createAttribute(frameBorder.getPosition()), XmlSaver.createAttribute(defaultBorder.getPosition()));
                break;
            }
            case ETCHED: {
                XmlSaver.setAttribute(element, "type", XmlSaver.createAttribute(frameBorder.getBorderType()), XmlSaver.createAttribute(defaultBorder.getBorderType()));
                XmlSaver.setAttribute(element, "hl", XmlSaver.createAttribute(frameBorder.getHlOut()), XmlSaver.createAttribute(defaultBorder.getHlOut()));
                XmlSaver.setAttribute(element, "shadow", XmlSaver.createAttribute(frameBorder.getShadowOut()), XmlSaver.createAttribute(defaultBorder.getShadowOut()));
                break;
            }
            case LINE: {
                XmlSaver.setAttribute(element, "color", XmlSaver.createAttribute(frameBorder.getColor()), XmlSaver.createAttribute(defaultBorder.getColor()));
                XmlSaver.setAttribute(element, "thickness", XmlSaver.createAttribute(frameBorder.getThickness()), XmlSaver.createAttribute(defaultBorder.getThickness()));
                XmlSaver.setAttribute(element, "rounded", XmlSaver.createAttribute(frameBorder.getRounded()), XmlSaver.createAttribute(defaultBorder.getRounded()));
                break;
            }
            case MATTE: {
                XmlSaver.setAttribute(element, "position", XmlSaver.createAttribute(frameBorder.getPosition()), XmlSaver.createAttribute(defaultBorder.getPosition()));
                XmlSaver.setAttribute(element, "color", XmlSaver.createAttribute(frameBorder.getColor()), XmlSaver.createAttribute(defaultBorder.getColor()));
                break;
            }
            case SOFTBEVEL: {
                XmlSaver.setAttribute(element, "type", XmlSaver.createAttribute(frameBorder.getBorderType()), XmlSaver.createAttribute(defaultBorder.getBorderType()));
                XmlSaver.setAttribute(element, "hlout", XmlSaver.createAttribute(frameBorder.getHlOut()), XmlSaver.createAttribute(defaultBorder.getHlOut()));
                XmlSaver.setAttribute(element, "hlin", XmlSaver.createAttribute(frameBorder.getHlIn()), XmlSaver.createAttribute(defaultBorder.getHlIn()));
                XmlSaver.setAttribute(element, "shadowout", XmlSaver.createAttribute(frameBorder.getShadowOut()), XmlSaver.createAttribute(defaultBorder.getShadowOut()));
                XmlSaver.setAttribute(element, "shadowin", XmlSaver.createAttribute(frameBorder.getShadowIn()), XmlSaver.createAttribute(defaultBorder.getShadowIn()));
                break;
            }
            case TITLED: {
                XmlSaver.setAttribute(element, "title", XmlSaver.createAttribute(frameBorder.getTitle()), XmlSaver.createAttribute(defaultBorder.getTitle()));
                XmlSaver.setAttribute(element, "justification", XmlSaver.createAttribute(frameBorder.getJustification()), XmlSaver.createAttribute(defaultBorder.getJustification()));
                XmlSaver.setAttribute(element, "titleposition", XmlSaver.createAttribute(frameBorder.getTitlePosition()), XmlSaver.createAttribute(defaultBorder.getTitlePosition()));
                XmlSaver.setAttribute(element, "fontname", XmlSaver.createAttribute(frameBorder.getFontName()), XmlSaver.createAttribute(defaultBorder.getFontName()));
                XmlSaver.setAttribute(element, "fontangle", XmlSaver.createAttribute(frameBorder.getFontAngle()), XmlSaver.createAttribute(defaultBorder.getFontAngle()));
                XmlSaver.setAttribute(element, "fontsize", XmlSaver.createAttribute(frameBorder.getFontSize()), XmlSaver.createAttribute(defaultBorder.getFontSize()));
                XmlSaver.setAttribute(element, "fontweight", XmlSaver.createAttribute(frameBorder.getFontWeight()), XmlSaver.createAttribute(defaultBorder.getFontWeight()));
                XmlSaver.setAttribute(element, "color", XmlSaver.createAttribute(frameBorder.getColor()), XmlSaver.createAttribute(defaultBorder.getColor()));
                Element element4 = XmlSaver.createBorder(document, frameBorder.getTitleBorder(), "title");
                if (element4 == null) break;
                XmlSaver.appendChild(element, element4);
                break;
            }
        }
        return element;
    }

    private static Element createUicontrol(Document document, Integer n, boolean bl) {
        Integer[] integerArray;
        Object[] objectArray;
        Object[] objectArray2;
        GraphicController graphicController = GraphicController.getController();
        Uicontrol uicontrol = (Uicontrol)graphicController.getObjectFromId(n);
        Uicontrol uicontrol2 = XmlSaver.initDefaultui(uicontrol.getStyle());
        Element element = document.createElement(uicontrol.getStyleAsEnum().toString().toLowerCase());
        XmlSaver.setAttribute(element, "backgroundcolor", XmlSaver.createAttribute(uicontrol.getBackgroundColor()), XmlSaver.createAttribute(uicontrol2.getBackgroundColor()));
        XmlSaver.setAttribute(element, "enable", XmlSaver.createAttribute(uicontrol.getEnable()), XmlSaver.createAttribute(uicontrol2.getEnable()));
        XmlSaver.setAttribute(element, "fontangle", XmlSaver.createAttribute(uicontrol.getFontAngle()), XmlSaver.createAttribute(uicontrol2.getFontAngle()));
        XmlSaver.setAttribute(element, "fontname", XmlSaver.createAttribute(uicontrol.getFontName()), XmlSaver.createAttribute(uicontrol2.getFontName()));
        XmlSaver.setAttribute(element, "fontsize", XmlSaver.createAttribute(uicontrol.getFontSize()), XmlSaver.createAttribute(uicontrol2.getFontSize()));
        XmlSaver.setAttribute(element, "fontunits", XmlSaver.createAttribute(uicontrol.getFontUnits()), XmlSaver.createAttribute(uicontrol2.getFontUnits()));
        XmlSaver.setAttribute(element, "fontweight", XmlSaver.createAttribute(uicontrol.getFontWeight()), XmlSaver.createAttribute(uicontrol2.getFontWeight()));
        XmlSaver.setAttribute(element, "foregroundcolor", XmlSaver.createAttribute(uicontrol.getForegroundColor()), XmlSaver.createAttribute(uicontrol2.getForegroundColor()));
        XmlSaver.setAttribute(element, "horizontalalignment", XmlSaver.createAttribute(uicontrol.getHorizontalAlignment()), XmlSaver.createAttribute(uicontrol2.getHorizontalAlignment()));
        XmlSaver.setAttribute(element, "listboxtop", XmlSaver.createAttribute(uicontrol.getListboxTop()), XmlSaver.createAttribute(uicontrol2.getListboxTop()));
        XmlSaver.setAttribute(element, "max", XmlSaver.createAttribute(uicontrol.getMax()), XmlSaver.createAttribute(uicontrol2.getMax()));
        XmlSaver.setAttribute(element, "min", XmlSaver.createAttribute(uicontrol.getMin()), XmlSaver.createAttribute(uicontrol2.getMin()));
        XmlSaver.setAttribute(element, "relief", XmlSaver.createAttribute(uicontrol.getRelief()), XmlSaver.createAttribute(uicontrol2.getRelief()));
        XmlSaver.setAttribute(element, "sliderstep", XmlSaver.createAttribute(uicontrol.getSliderStep()), XmlSaver.createAttribute(uicontrol2.getSliderStep()));
        if (uicontrol.getStyle() != 372 && uicontrol.getStyle() != 293 && !Arrays.deepEquals(objectArray2 = uicontrol.getString(), objectArray = uicontrol2.getString())) {
            XmlSaver.createStringArray(document, element, "string", (String[])objectArray2, uicontrol.getStringColNb());
        }
        if (!Arrays.deepEquals(objectArray2 = uicontrol.getTooltipString(), objectArray = uicontrol2.getTooltipString())) {
            XmlSaver.createStringArray(document, element, "tooltipstring", (String[])objectArray2, 1);
        }
        XmlSaver.setAttribute(element, "units", XmlSaver.createAttribute(uicontrol.getUnits()), XmlSaver.createAttribute(uicontrol2.getUnits()));
        if (uicontrol.getStyle() != 372 && uicontrol.getStyle() != 293) {
            XmlSaver.setAttribute(element, "value", XmlSaver.createAttribute(uicontrol.getUiValue()), XmlSaver.createAttribute(uicontrol2.getUiValue()));
        }
        XmlSaver.setAttribute(element, "verticalalignment", XmlSaver.createAttribute(uicontrol.getVerticalAlignment()), XmlSaver.createAttribute(uicontrol2.getVerticalAlignment()));
        XmlSaver.setAttribute(element, "visible", XmlSaver.createAttribute(uicontrol.getVisible()), XmlSaver.createAttribute(uicontrol2.getVisible() == false));
        XmlSaver.setAttribute(element, "callback", XmlSaver.createAttribute(uicontrol.getCallbackString()), XmlSaver.createAttribute(uicontrol2.getCallbackString()));
        XmlSaver.setAttribute(element, "callback_type", XmlSaver.createAttribute(uicontrol.getCallbackType()), XmlSaver.createAttribute(uicontrol2.getCallbackType()));
        Integer n2 = (Integer)graphicController.getProperty(uicontrol.getIdentifier(), 24);
        Integer n3 = (Integer)graphicController.getProperty(n2, 370);
        LayoutType layoutType = LayoutType.intToEnum(n3);
        if (layoutType == LayoutType.GRIDBAG) {
            XmlSaver.setAttribute(element, "gridbaggrid", XmlSaver.createAttribute(uicontrol.getGridBagGrid()), XmlSaver.createAttribute(uicontrol2.getGridBagGrid()));
            XmlSaver.setAttribute(element, "gridbagweight", XmlSaver.createAttribute(uicontrol.getGridBagWeight()), XmlSaver.createAttribute(uicontrol2.getGridBagWeight()));
            XmlSaver.setAttribute(element, "gridbagfill", XmlSaver.createAttribute(Uicontrol.FillType.enumToString(uicontrol.getGridBagFillAsEnum())), XmlSaver.createAttribute(Uicontrol.FillType.enumToString(uicontrol2.getGridBagFillAsEnum())));
            XmlSaver.setAttribute(element, "gridbaganchor", XmlSaver.createAttribute(Uicontrol.AnchorType.enumToString(uicontrol.getGridBagAnchorAsEnum())), XmlSaver.createAttribute(Uicontrol.AnchorType.enumToString(uicontrol2.getGridBagAnchorAsEnum())));
            XmlSaver.setAttribute(element, "gridbagpadding", XmlSaver.createAttribute(uicontrol.getGridBagPadding()), XmlSaver.createAttribute(uicontrol2.getGridBagPadding()));
            XmlSaver.setAttribute(element, "gridbagpreferredsize", XmlSaver.createAttribute(uicontrol.getGridBagPreferredSize()), XmlSaver.createAttribute(uicontrol2.getGridBagPreferredSize()));
        } else if (layoutType == LayoutType.BORDER) {
            XmlSaver.setAttribute(element, "borderposition", XmlSaver.createAttribute(Uicontrol.BorderLayoutType.enumToString(uicontrol.getBorderPositionAsEnum())), XmlSaver.createAttribute(Uicontrol.BorderLayoutType.enumToString(uicontrol2.getBorderPositionAsEnum())));
            XmlSaver.setAttribute(element, "borderpreferredsize", XmlSaver.createAttribute(uicontrol.getBorderPreferredSize()), XmlSaver.createAttribute(uicontrol2.getBorderPreferredSize()));
        } else if (layoutType == LayoutType.NONE) {
            XmlSaver.setAttribute(element, "position", XmlSaver.createAttribute(uicontrol.getUiPosition()), XmlSaver.createAttribute(uicontrol2.getUiPosition()));
        }
        XmlSaver.setAttribute(element, "margins", XmlSaver.createAttribute(uicontrol.getMargins()), XmlSaver.createAttribute(uicontrol2.getMargins()));
        XmlSaver.setAttribute(element, "groupname", XmlSaver.createAttribute(uicontrol.getGroupName()), XmlSaver.createAttribute(uicontrol2.getGroupName()));
        XmlSaver.setAttribute(element, "icon", XmlSaver.createAttribute(uicontrol.getIcon()), XmlSaver.createAttribute(uicontrol2.getIcon()));
        XmlSaver.setAttribute(element, "tag", XmlSaver.createAttribute(uicontrol.getTag()), XmlSaver.createAttribute(uicontrol2.getTag()));
        if (uicontrol.getStyleAsEnum() == Uicontrol.UicontrolStyle.FRAME) {
            integerArray = uicontrol.getFrameBorder();
            Element element2 = XmlSaver.createBorder(document, (Integer)integerArray);
            if (element2 != null) {
                XmlSaver.appendChild(element, XmlSaver.createBorder(document, (Integer)integerArray));
            }
            XmlSaver.setAttribute(element, "layout", XmlSaver.createAttribute(LayoutType.enumToString(uicontrol.getLayoutAsEnum())), XmlSaver.createAttribute(LayoutType.enumToString(uicontrol2.getLayoutAsEnum())));
            if (uicontrol.getLayoutAsEnum() == LayoutType.GRID) {
                XmlSaver.setAttribute(element, "gridoptgrid", XmlSaver.createAttribute(uicontrol.getGridOptGrid()), XmlSaver.createAttribute(uicontrol2.getGridOptGrid()));
                XmlSaver.setAttribute(element, "gridoptpadding", XmlSaver.createAttribute(uicontrol.getGridOptPadding()), XmlSaver.createAttribute(uicontrol2.getGridOptPadding()));
            } else if (uicontrol.getLayoutAsEnum() == LayoutType.BORDER) {
                XmlSaver.setAttribute(element, "borderoptpadding", XmlSaver.createAttribute(uicontrol.getBorderOptPadding()), XmlSaver.createAttribute(uicontrol2.getBorderOptPadding()));
            }
        }
        if (uicontrol.getStyleAsEnum() == Uicontrol.UicontrolStyle.FRAME || uicontrol.getStyleAsEnum() == Uicontrol.UicontrolStyle.EDIT) {
            XmlSaver.setAttribute(element, "scrollable", XmlSaver.createAttribute(uicontrol.getScrollable()), XmlSaver.createAttribute(uicontrol2.getScrollable()));
        }
        graphicController.deleteObject(uicontrol2.getIdentifier());
        integerArray = uicontrol.getChildren();
        if (bl) {
            for (int i = integerArray.length - 1; i >= 0; --i) {
                if ((Integer)graphicController.getProperty(integerArray[i], 29) == 386) continue;
                XmlSaver.appendChild(element, XmlSaver.createElement(document, integerArray[i], bl));
            }
        } else {
            for (int i = 0; i < integerArray.length; ++i) {
                if ((Integer)graphicController.getProperty(integerArray[i], 29) == 386) continue;
                XmlSaver.appendChild(element, XmlSaver.createElement(document, integerArray[i], bl));
            }
        }
        return element;
    }

    private static Element createUimenu(Document document, Integer n, boolean bl) {
        GraphicController graphicController = GraphicController.getController();
        Uimenu uimenu = (Uimenu)graphicController.getObjectFromId(n);
        if (uimenu.isHidden().booleanValue()) {
            return null;
        }
        Uimenu uimenu2 = XmlSaver.initDefaultMenu();
        Element element = document.createElement("menu");
        XmlSaver.setAttribute(element, "enable", XmlSaver.createAttribute(uimenu.getEnable()), XmlSaver.createAttribute(uimenu2.getEnable()));
        XmlSaver.setAttribute(element, "foregroundcolor", XmlSaver.createAttribute(uimenu.getForegroundColor()), XmlSaver.createAttribute(uimenu2.getForegroundColor()));
        XmlSaver.setAttribute(element, "label", XmlSaver.createAttribute(uimenu.getLabel()), XmlSaver.createAttribute(uimenu2.getLabel()));
        XmlSaver.setAttribute(element, "hidden", XmlSaver.createAttribute(uimenu.isHidden()), XmlSaver.createAttribute(uimenu2.isHidden()));
        XmlSaver.setAttribute(element, "visible", XmlSaver.createAttribute(uimenu.getVisible()), XmlSaver.createAttribute(uimenu2.getVisible()));
        XmlSaver.setAttribute(element, "callback", XmlSaver.createAttribute(uimenu.getCallbackString()), XmlSaver.createAttribute(uimenu2.getCallbackString()));
        XmlSaver.setAttribute(element, "callback_type", XmlSaver.createAttribute(uimenu.getCallbackType()), XmlSaver.createAttribute(uimenu2.getCallbackType()));
        XmlSaver.setAttribute(element, "checked", XmlSaver.createAttribute(uimenu.getChecked()), XmlSaver.createAttribute(uimenu2.getChecked()));
        XmlSaver.setAttribute(element, "icon", XmlSaver.createAttribute(uimenu.getIcon()), XmlSaver.createAttribute(uimenu2.getIcon()));
        XmlSaver.setAttribute(element, "tag", XmlSaver.createAttribute(uimenu.getTag()), XmlSaver.createAttribute(uimenu2.getTag()));
        Integer[] integerArray = uimenu.getChildren();
        for (int i = 0; i < integerArray.length; ++i) {
            XmlSaver.appendChild(element, XmlSaver.createElement(document, integerArray[i], bl));
        }
        return element;
    }

    private static String createAttribute(Boolean bl) {
        if (bl == null) {
            return "off";
        }
        if (bl.booleanValue()) {
            return "on";
        }
        return "off";
    }

    private static String createAttribute(Integer n) {
        if (n == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    private static String createAttribute(String string) {
        if (string == null) {
            return null;
        }
        return string;
    }

    private static String createAttribute(Double d) {
        if (d == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(d);
        return stringBuilder.toString();
    }

    private static String createAttribute(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(XmlSaver.createAttribute(stringArray[0]));
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(XmlSaver.createAttribute(stringArray[i]));
        }
        return stringBuilder.toString();
    }

    private static String createAttribute(Double[] doubleArray) {
        if (doubleArray == null || doubleArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(XmlSaver.createAttribute(doubleArray[0]));
        for (int i = 1; i < doubleArray.length; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(XmlSaver.createAttribute(doubleArray[i]));
        }
        return stringBuilder.toString();
    }

    private static String createAttribute(Integer[] integerArray) {
        if (integerArray == null || integerArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(XmlSaver.createAttribute(integerArray[0]));
        for (int i = 1; i < integerArray.length; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(XmlSaver.createAttribute(integerArray[i]));
        }
        return stringBuilder.toString();
    }

    private static void setAttribute(Element element, String string, String string2, String string3) {
        if (string2 == null || string == null || element == null || string3 != null && string2.equals(string3)) {
            return;
        }
        element.setAttribute(string, string2);
    }

    private static Uicontrol initDefaultui(Integer n) {
        Integer n2 = GraphicController.getController().askObject(GraphicObject.getTypeFromName(n));
        return (Uicontrol)GraphicController.getController().getObjectFromId(n2);
    }

    private static Uimenu initDefaultMenu() {
        Integer n = GraphicController.getController().askObject(GraphicObject.getTypeFromName(20));
        return (Uimenu)GraphicController.getController().getObjectFromId(n);
    }

    private static void createStringArray(Document document, Element element, String string, String[] stringArray, Integer n) {
        Element element2 = document.createElement("string");
        Integer n2 = stringArray.length / n;
        XmlSaver.setAttribute(element2, "property", string, "");
        XmlSaver.setAttribute(element2, "rows", n2.toString(), "");
        XmlSaver.setAttribute(element2, "cols", n.toString(), "");
        for (int i = 0; i < n2 * n; ++i) {
            Element element3 = document.createElement("stringitem");
            XmlSaver.setAttribute(element3, "value", stringArray[i], null);
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }

    private static void createColorMap(Document document, Element element, Double[] doubleArray) {
        Element element2 = document.createElement("colormap");
        Integer n = doubleArray.length / 3;
        XmlSaver.setAttribute(element2, "size", n.toString(), "");
        for (int i = 0; i < n; ++i) {
            Element element3 = document.createElement("colormapitem");
            Color color = new Color(doubleArray[i].floatValue(), doubleArray[i + n].floatValue(), doubleArray[i + 2 * n].floatValue());
            Integer n2 = color.getRGB();
            XmlSaver.setAttribute(element3, "color", n2.toString(), null);
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }
}

