/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.BitBuffer;
import com.sun.java.help.search.IntegerArray;
import java.io.DataOutput;
import java.io.IOException;

class Compressor {
    private static final int NBits = 32;
    private static final int BeginK = 5;
    private BitBuffer _buffer = new BitBuffer();

    Compressor() {
    }

    public void write(DataOutput out) throws IOException {
        this._buffer.write(out);
    }

    public int byteCount() {
        return this._buffer.byteCount();
    }

    public void clear() {
        this._buffer.clear();
    }

    public void concatenate(Compressor other) {
        this._buffer.concatenate(other._buffer);
    }

    public void encode(IntegerArray pos, int k) {
        int power = 1 << k;
        int n1 = 0;
        for (int i = 0; i < pos.cardinality(); ++i) {
            int n2 = pos.at(i) >>> k;
            int rem = pos.at(i) % power;
            if (n2 != n1) {
                int min = n1;
                int a = n1;
                int lev = 0;
                int power2 = 1;
                if (n2 > n1) {
                    int max = n1;
                    while (max < n2) {
                        if ((a & 1) != 0) {
                            min -= power2;
                        } else {
                            max += power2;
                        }
                        a >>>= 1;
                        power2 <<= 1;
                        ++lev;
                    }
                } else {
                    while (min > n2) {
                        if ((a & 1) != 0) {
                            min -= power2;
                        }
                        a >>>= 1;
                        power2 <<= 1;
                        ++lev;
                    }
                }
                if (lev * 2 + 1 + k <= 32) {
                    this._buffer.append((1 << lev | n2 - min) << k | rem, lev * 2 + 1 + k);
                } else {
                    if (lev * 2 + 1 <= 32) {
                        this._buffer.append(1 << lev | n2 - min, lev * 2 + 1);
                    } else {
                        this._buffer.append(0, lev);
                        this._buffer.append(1 << lev | n2 - min, lev + 1);
                    }
                    this._buffer.append(rem, k);
                }
                n1 = n2;
                continue;
            }
            this._buffer.append(rem | power, k + 1);
        }
        this._buffer.append(2 | n1 & 1, 3);
        this._buffer.close();
    }

    public void encode(IntegerArray pos, IntegerArray len, int k, int k2) {
        int power = 1 << k;
        int n1 = 0;
        for (int i = 0; i < pos.cardinality(); ++i) {
            int n2 = pos.at(i) >>> k;
            int rem = pos.at(i) % power;
            if (n2 != n1) {
                int min = n1;
                int a = n1;
                int lev = 0;
                int power2 = 1;
                if (n2 > n1) {
                    int max = n1;
                    while (max < n2) {
                        if ((a & 1) != 0) {
                            min -= power2;
                        } else {
                            max += power2;
                        }
                        a >>>= 1;
                        power2 <<= 1;
                        ++lev;
                    }
                } else {
                    while (min > n2) {
                        if ((a & 1) != 0) {
                            min -= power2;
                        }
                        a >>>= 1;
                        power2 <<= 1;
                        ++lev;
                    }
                }
                if (lev * 2 + 1 + k <= 32) {
                    this._buffer.append((1 << lev | n2 - min) << k | rem, lev * 2 + 1 + k);
                } else {
                    if (lev * 2 + 1 <= 32) {
                        this._buffer.append(1 << lev | n2 - min, lev * 2 + 1);
                    } else {
                        this._buffer.append(0, lev);
                        this._buffer.append(1 << lev | n2 - min, lev + 1);
                    }
                    this._buffer.append(rem, k);
                }
                this._buffer.append(len.at(i), k2);
                n1 = n2;
                continue;
            }
            this._buffer.append((rem | power) << k2 | len.at(i), k + k2 + 1);
        }
        this._buffer.append(2 | n1 & 1, 3);
        this._buffer.close();
    }

    public int minimize(IntegerArray array, int startK) {
        BitBuffer saved = new BitBuffer();
        int minK = startK;
        this._buffer.clear();
        this.encode(array, startK);
        int min = this._buffer.bitCount();
        saved.setFrom(this._buffer);
        this._buffer.clear();
        this.encode(array, startK + 1);
        if (this._buffer.bitCount() < min) {
            int k = startK + 1;
            do {
                saved.setFrom(this._buffer);
                min = this._buffer.bitCount();
                minK = k++;
                this._buffer.clear();
                this.encode(array, k);
            } while (this._buffer.bitCount() < min);
        } else {
            int k = startK - 1;
            while (k > 0) {
                this._buffer.clear();
                this.encode(array, k);
                if (this._buffer.bitCount() >= min) break;
                saved.setFrom(this._buffer);
                min = this._buffer.bitCount();
                minK = k--;
            }
        }
        this._buffer.setFrom(saved);
        return minK;
    }

    public int compressAscending(IntegerArray array) {
        IntegerArray differences = new IntegerArray(array.cardinality());
        array.toDifferences(differences);
        return this.minimize(differences, 5);
    }
}

