/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Query;
import com.sun.java.help.search.RoleFiller;

class ConceptData {
    private final byte _query;
    private final byte _nColumns;
    private final byte _role;
    private final int _concept;
    private int _conceptLength;
    private final int _proximity;
    private final double _penalty;
    private ConceptData _next;
    private static final int ProxPerTerm = 100;

    public ConceptData(int id, int role, double score, int query, int nColumns) {
        this._query = (byte)query;
        this._nColumns = (byte)nColumns;
        this._concept = id;
        this._proximity = nColumns * 100;
        this._role = (byte)role;
        this._penalty = score;
        this._next = null;
    }

    public int getConcept() {
        return this._concept;
    }

    public double getPenalty() {
        return this._penalty;
    }

    public int getConceptLength() {
        return this._conceptLength;
    }

    public byte getRole() {
        return this._role;
    }

    public byte getQuery() {
        return this._query;
    }

    public byte getNColumns() {
        return this._nColumns;
    }

    public double getScore() {
        return this._penalty;
    }

    public ConceptData getNext() {
        return this._next;
    }

    public int getQueryMask() {
        return (this._next != null ? this._next.getQueryMask() : 0) | 1 << this._query;
    }

    public void setConceptLength(int length) {
        this._conceptLength = length;
        if (this._next != null) {
            this._next.setConceptLength(length);
        }
    }

    public void setNext(ConceptData next) {
        this._next = next;
    }

    boolean cEquals(ConceptData other) {
        return this._concept == other._concept;
    }

    boolean crEquals(ConceptData other) {
        return this._concept == other._concept && this._role == other._role;
    }

    boolean crqEquals(ConceptData other) {
        return this._concept == other._concept && this._role == other._role && this._query == other._query;
    }

    void addLast(ConceptData other) {
        if (this._next != null) {
            this._next.addLast(other);
        } else {
            this._next = other;
        }
    }

    boolean compareWith(ConceptData other) {
        return this._concept < other._concept || this.cEquals(other) && this._role < other._role || this.crEquals(other) && this._penalty < other._penalty;
    }

    public void runBy(Query[] queries) {
        ConceptData cd = this;
        do {
            queries[cd._query].updateEstimate(cd._role, cd._penalty);
        } while ((cd = cd._next) != null);
    }

    public void generateFillers(RoleFiller[] array, int pos) {
        if (array[this._query] != RoleFiller.STOP) {
            new RoleFiller(this._nColumns, this, this._role, pos, pos + this._proximity).use(array, this._query);
        }
        if (this._next != null) {
            this._next.generateFillers(array, pos);
        }
    }
}

