/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import java.io.IOException;
import java.io.Reader;
import java.text.BreakIterator;
import java.util.Locale;
import javax.help.search.ConfigFile;
import javax.help.search.IndexBuilder;
import javax.help.search.IndexerKit;

public class DefaultIndexerKit
extends IndexerKit {
    protected boolean documentStarted;
    private boolean debugFlag = false;

    public DefaultIndexerKit() {
        this.locale = Locale.getDefault();
    }

    public Object clone() {
        return new DefaultIndexerKit();
    }

    public String getContentType() {
        return "";
    }

    public void parse(Reader in, String file, boolean ignoreCharset, IndexBuilder builder, ConfigFile config) throws IOException {
        this.debug("parsing " + file);
    }

    public int parseIntoTokens(String source, int pos) {
        int currentPos = pos;
        try {
            BreakIterator boundary = BreakIterator.getWordInstance(this.locale);
            boundary.setText(source);
            int start = boundary.first();
            int end = boundary.next();
            while (end != -1) {
                int charType;
                String word = new String(source.substring(start, end));
                word = word.trim();
                if ((word = word.toLowerCase(this.locale)).length() > 1) {
                    this.storeToken(word, currentPos + start);
                } else if (word.length() == 1 && ((charType = Character.getType(word.charAt(0))) == 9 || charType == 10 || charType == 2 || charType == 5 || charType == 11 || charType == 3 || charType == 0 || charType == 1)) {
                    this.storeToken(word, currentPos + start);
                }
                start = end;
                end = boundary.next();
            }
            currentPos += source.length();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return currentPos;
    }

    protected void startStoreDocument(String file) throws Exception {
        if (this.config == null || this.builder == null) {
            throw new IllegalStateException("ConfigFile and/or IndexBuilder not set");
        }
        this.builder.openDocument(this.config.getURLString(file));
    }

    protected void endStoreDocument() throws Exception {
        if (this.config == null || this.builder == null) {
            throw new IllegalStateException("ConfigFile and/or IndexBuilder not set");
        }
        this.builder.closeDocument();
    }

    protected void storeToken(String token, int pos) throws Exception {
        if (this.config == null || this.builder == null) {
            throw new IllegalStateException("ConfigFile and/or IndexBuilder not set");
        }
        if (!this.documentStarted) {
            try {
                this.startStoreDocument(this.file);
                this.documentStarted = true;
            }
            catch (Exception e) {
                if (this.debugFlag) {
                    e.printStackTrace();
                }
                throw new IOException("Can't store Document");
            }
        }
        this.builder.storeLocation(token, pos);
    }

    protected void storeTitle(String title) throws Exception {
        if (this.config == null || this.builder == null) {
            throw new IllegalStateException("ConfigFile and/or IndexBuilder not set");
        }
        this.builder.storeTitle(title);
    }

    private void debug(String msg) {
        if (this.debugFlag) {
            System.err.println("DefaultIndexKit: " + msg);
        }
    }
}

