/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ConceptData;
import com.sun.java.help.search.Location;
import com.sun.java.help.search.Query;
import java.io.PrintStream;

class RoleFiller {
    static int Threshold = 300;
    private ConceptData _conceptData;
    private byte _fixedRole;
    private short _filled;
    private int _begin;
    private int _end;
    private int _limit;
    private RoleFiller _next;
    private RoleFiller[] _fillers;
    public static final RoleFiller STOP = new RoleFiller();

    private RoleFiller() {
    }

    public RoleFiller(int nColumns, ConceptData first, int role, int pos, int limit) {
        this._conceptData = first;
        this._fixedRole = (byte)role;
        this._filled = (short)(1 << this._fixedRole);
        this._begin = pos;
        this._end = this._begin + first.getConceptLength();
        this._limit = limit;
        this._next = null;
        this._fillers = new RoleFiller[nColumns];
        this._fillers[role] = this;
    }

    public void print(PrintStream out) {
        out.println(this._begin + ", " + this._end);
    }

    void makeQueryHit(Query q, int nColumns, int doc, double penalty) {
        if (q.goodEnough(penalty)) {
            int[] array = q.getConceptArrayOfNewHit(penalty, new Location(doc, this._begin, this._end));
            for (int i = 0; i < nColumns; ++i) {
                array[i] = (this._filled & 1 << i) != 0 ? this._fillers[i].getConcept() : 0;
            }
        }
    }

    boolean isHit() {
        return this._filled > 1 << this._fixedRole;
    }

    double getScore() {
        return this._conceptData.getScore();
    }

    int getConcept() {
        return this._conceptData.getConcept();
    }

    RoleFiller next() {
        return this._next;
    }

    void use(RoleFiller[] place, int index) {
        if (place[index] != null) {
            RoleFiller rf = place[index];
            place[index] = this;
            this._next = rf;
            while (rf._limit >= this._begin) {
                if (this._fixedRole != rf._fixedRole) {
                    if ((rf._filled & 1 << this._fixedRole) == 0) {
                        rf._filled = (short)(rf._filled | 1 << this._fixedRole);
                        rf._fillers[this._fixedRole] = this;
                        rf._end = this._end;
                    } else {
                        rf.considerReplacementWith(this);
                    }
                }
                if (rf._next != null) {
                    rf = rf._next;
                    continue;
                }
                return;
            }
        } else {
            place[index] = this;
        }
    }

    private void considerReplacementWith(RoleFiller replacement) {
        byte role = replacement._fixedRole;
        if (replacement.getScore() > this._fillers[role].getScore()) {
            this._fillers[role] = replacement;
        }
    }

    private double penalty(Query query, int nColumns) {
        int length = this._end - this._begin + 1;
        double penalty = query.lookupPenalty(this._filled);
        for (int i = 0; i < nColumns; ++i) {
            if ((this._filled & 1 << i) == 0) continue;
            penalty += this._fillers[i]._conceptData.getPenalty();
            length -= this._fillers[i]._conceptData.getConceptLength() + 1;
            if (this._filled >> i + 1 == 0) continue;
            for (int j = i + 1; j < nColumns; ++j) {
                if ((this._filled & 1 << j) == 0 || this._fillers[j]._begin >= this._begin) continue;
                penalty += query.getOutOufOrderPenalty();
            }
        }
        return penalty + (double)length * query.getGapPenalty();
    }

    public void scoreList(Query query, int document) {
        int nColumns = query.getNColumns();
        RoleFiller candidateHit = this;
        double penalty = candidateHit.penalty(query, nColumns);
        RoleFiller next = candidateHit._next;
        while (next != null) {
            if (next._end < candidateHit._begin) {
                candidateHit.makeQueryHit(query, nColumns, document, penalty);
                candidateHit = next;
                penalty = candidateHit.penalty(query, nColumns);
            } else {
                double penalty2 = next.penalty(query, nColumns);
                if (penalty2 <= penalty) {
                    penalty = penalty2;
                    candidateHit = next;
                }
            }
            next = next._next;
        }
        candidateHit.makeQueryHit(query, nColumns, document, penalty);
    }
}

