/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import javax.help.HelpAction;

public abstract class AbstractHelpAction
implements HelpAction {
    private boolean enabled = true;
    private Object control;
    private Hashtable table;
    private PropertyChangeSupport propertyChangeSupport;

    AbstractHelpAction(Object control, String name) {
        this.control = control;
        this.putValue("name", name);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.enabled;
        this.enabled = enabled;
        this.firePropertyChange("enabled", new Boolean(oldEnabled), new Boolean(enabled));
    }

    public Object getControl() {
        return this.control;
    }

    public Object getValue(String key) {
        if (this.table == null) {
            return null;
        }
        return this.table.get(key);
    }

    public void putValue(String key, Object newValue) {
        if (this.table == null) {
            this.table = new Hashtable();
        }
        Object oldValue = newValue == null ? this.table.remove(key) : this.table.put(key, newValue);
        this.firePropertyChange(key, oldValue, newValue);
    }
}

