/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.RuleBasedCollator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.help.BadIDException;
import javax.help.FavoritesItem;
import javax.help.FavoritesNode;
import javax.help.FavoritesView;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpFavoritesNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.SwingHelpUtilities;
import javax.help.TreeItem;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.event.HelpSetEvent;
import javax.help.event.HelpSetListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicFavoritesCellRenderer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicFavoritesNavigatorUI
extends HelpNavigatorUI
implements HelpModelListener,
TreeSelectionListener,
HelpSetListener,
PropertyChangeListener,
TreeModelListener,
Serializable {
    protected JHelpFavoritesNavigator favorites;
    protected JScrollPane sp;
    protected FavoritesNode topNode;
    protected JTree tree;
    private String contentTitle;
    protected RuleBasedCollator rbc;
    protected String oldText;
    protected DefaultMutableTreeNode currentFindNode;
    protected Action addAction;
    protected Action removeAction;
    protected Action cutAction;
    protected Action pasteAction;
    protected Action copyAction;
    protected Action folderAction;
    protected JPopupMenu popup;
    private HashMap dataMap = new HashMap();
    private FavoritesNode favNode = null;
    private FavoritesNode rootNode = null;
    private Locale locale = null;
    private FavoritesNode selectedNode = null;
    private FavoritesItem selectedItem = null;
    private TreePath selectedTreePath = null;
    private Map.ID selectedID = null;
    private JMenuItem newFolderMI = null;
    private JMenuItem addMI = null;
    private JSeparator separatorMI = null;
    private JMenuItem cutMI = null;
    private JMenuItem copyMI = null;
    private JMenuItem pasteMI = null;
    private JMenuItem removeMI = null;
    private HashMap hsMap = null;
    private HashMap connections = new HashMap();
    private Vector nodeClipboard = new Vector();
    private static boolean on1dot3 = false;
    private static boolean debug;
    static /* synthetic */ Class class$javax$help$plaf$basic$BasicFavoritesNavigatorUI;

    public static ComponentUI createUI(JComponent x) {
        return new BasicFavoritesNavigatorUI((JHelpFavoritesNavigator)x);
    }

    public BasicFavoritesNavigatorUI(JHelpFavoritesNavigator b) {
        ImageIcon icon = this.getImageIcon(b.getNavigatorView());
        if (icon != null) {
            this.setIcon(icon);
        } else {
            this.setIcon(UIManager.getIcon("FavoritesNav.icon"));
        }
    }

    public void installUI(JComponent c) {
        BasicFavoritesNavigatorUI.debug("installUI");
        this.locale = HelpUtilities.getLocale(c);
        this.addAction = new AddAction();
        this.removeAction = new RemoveAction();
        this.folderAction = new FolderAction();
        this.favorites = (JHelpFavoritesNavigator)c;
        HelpModel model = this.favorites.getModel();
        this.favorites.setLayout(new BorderLayout());
        this.favorites.addPropertyChangeListener(this);
        if (model != null) {
            model.addHelpModelListener(this);
            model.addPropertyChangeListener(this);
            HelpSet helpSet = model.getHelpSet();
            if (helpSet != null) {
                helpSet.addHelpSetListener(this);
            }
        }
        this.topNode = new FavoritesNode(new FavoritesItem("Favorites"));
        this.tree = on1dot3 ? new FavoritesTree(this.topNode) : new JTree(this.topNode);
        this.tree.setEditable(true);
        this.tree.addMouseListener(new PopupListener());
        this.cutAction = new CutAction();
        this.copyAction = new CopyAction();
        this.pasteAction = new PasteAction();
        this.popup = new JPopupMenu();
        this.newFolderMI = new JMenuItem((String)this.folderAction.getValue("Name"));
        this.newFolderMI.addActionListener(this.folderAction);
        this.popup.add(this.newFolderMI);
        this.addMI = new JMenuItem((String)this.addAction.getValue("Name"));
        this.addMI.addActionListener(this.addAction);
        this.popup.add(this.addMI);
        this.separatorMI = new JSeparator();
        this.popup.add(this.separatorMI);
        this.cutMI = new JMenuItem((String)this.cutAction.getValue("Name"));
        this.cutMI.addActionListener(this.cutAction);
        this.cutMI.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.popup.add(this.cutMI);
        this.copyMI = new JMenuItem((String)this.copyAction.getValue("Name"));
        this.copyMI.addActionListener(this.copyAction);
        this.copyMI.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.popup.add(this.copyMI);
        this.pasteMI = new JMenuItem((String)this.pasteAction.getValue("Name"));
        this.pasteMI.addActionListener(this.pasteAction);
        this.pasteMI.setEnabled(false);
        this.pasteMI.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.popup.add(this.pasteMI);
        this.removeMI = new JMenuItem((String)this.removeAction.getValue("Name"));
        this.removeMI.addActionListener(this.removeAction);
        this.popup.add(this.removeMI);
        this.tree.getModel().addTreeModelListener(this);
        this.tree.addTreeSelectionListener(this);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.setCellRenderer(this.favorites.getNavigatorView(), this.tree);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.favorites.add("Center", this.sp);
        this.reloadData();
    }

    protected void setCellRenderer(NavigatorView view, JTree tree) {
        tree.setCellRenderer(new BasicFavoritesCellRenderer());
    }

    public void uninstallUI(JComponent c) {
        BasicFavoritesNavigatorUI.debug("uninstallUI");
        HelpModel model = this.favorites.getModel();
        this.favorites.removePropertyChangeListener(this);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.removeTreeSelectionListener(this);
        this.favorites.setLayout(null);
        this.favorites.removeAll();
        if (model != null) {
            model.removeHelpModelListener(this);
        }
        this.favorites = null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(200, 100);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(100, 100);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void reloadData() {
        BasicFavoritesNavigatorUI.debug("reloadData");
        if (this.favorites.getModel() == null) {
            return;
        }
        this.topNode.removeAllChildren();
        FavoritesView view = (FavoritesView)this.favorites.getNavigatorView();
        if (view == null) {
            return;
        }
        this.favNode = view.getDataAsTree();
        this.rootNode = this.favNode.getDeepCopy();
        this.classifyNode(this.favNode);
        while (this.favNode.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)this.favNode.getFirstChild());
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
    }

    private void classifyNode(FavoritesNode node) {
        BasicFavoritesNavigatorUI.debug("classifyNode");
        if (node == null) {
            return;
        }
        HelpModel model = this.favorites.getModel();
        if (model == null) {
            node.removeAllChildren();
            return;
        }
        HelpSet masterHelpSet = model.getHelpSet();
        if (masterHelpSet == null) {
            node.removeAllChildren();
            return;
        }
        this.hsMap = new HashMap();
        this.hsMap.put(masterHelpSet.getTitle(), masterHelpSet);
        this.fillHelpSetTitles(masterHelpSet);
        this.classifyChildren(node);
    }

    private void fillHelpSetTitles(HelpSet masterHelpSet) {
        Enumeration helpSets = masterHelpSet.getHelpSets();
        while (helpSets.hasMoreElements()) {
            HelpSet hs = (HelpSet)helpSets.nextElement();
            if (hs == null) continue;
            this.hsMap.put(hs.getTitle(), hs);
            BasicFavoritesNavigatorUI.debug(" fill title: " + hs.getTitle());
            this.fillHelpSetTitles(hs);
        }
    }

    private void classifyChildren(FavoritesNode node) {
        BasicFavoritesNavigatorUI.debug("classifyChildren: " + node);
        if (node == null) {
            return;
        }
        boolean skipChild = true;
        Enumeration<TreeNode> children = node.preorderEnumeration();
        while (children.hasMoreElements()) {
            FavoritesNode chnode = (FavoritesNode)children.nextElement();
            if (skipChild) {
                skipChild = false;
                continue;
            }
            FavoritesNode copy = chnode.getDeepCopy();
            this.connections.put(chnode, copy);
            FavoritesNode rootParent = (FavoritesNode)this.connections.get(chnode.getParent());
            if (rootParent == null) {
                rootParent = this.rootNode;
            }
            rootParent.add(copy);
            FavoritesItem item = (FavoritesItem)chnode.getUserObject();
            BasicFavoritesNavigatorUI.debug("classify item: " + item);
            if (item == null) {
                BasicFavoritesNavigatorUI.debug("item is null : fillDataMap");
                continue;
            }
            String target = item.getTarget();
            String hsTitle = item.getHelpSetTitle();
            if (!this.hsMap.containsKey(hsTitle) && chnode.getVisibleChildCount() == 0) {
                if (item.emptyInitState() && item.isFolder()) {
                    BasicFavoritesNavigatorUI.debug("empty init state");
                    continue;
                }
                item.setVisible(false);
                continue;
            }
            if (target == null) {
                BasicFavoritesNavigatorUI.debug("target is null:fillDataMap");
                continue;
            }
            Map.ID id = null;
            try {
                id = Map.ID.create(target, (HelpSet)this.hsMap.get(hsTitle));
            }
            catch (BadIDException ep) {
                BasicFavoritesNavigatorUI.debug(ep.getMessage());
                continue;
            }
            BasicFavoritesNavigatorUI.debug("put to the dataMap: " + item);
            this.dataMap.put(item, id);
        }
        Vector<FavoritesNode> toRemove = new Vector<FavoritesNode>();
        Enumeration<TreeNode> nodesToRem = node.breadthFirstEnumeration();
        while (nodesToRem.hasMoreElements()) {
            FavoritesNode fn = (FavoritesNode)nodesToRem.nextElement();
            if (fn.isVisible()) continue;
            BasicFavoritesNavigatorUI.debug("remove node:" + (FavoritesItem)fn.getUserObject());
            toRemove.addElement(fn);
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            BasicFavoritesNavigatorUI.debug("removing " + toRemove.elementAt(i));
            try {
                node.remove((DefaultMutableTreeNode)toRemove.elementAt(i));
                continue;
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
    }

    private void expand(String target) {
        BasicFavoritesNavigatorUI.debug("expand called");
        Enumeration nodes = this.findNodes(target).elements();
        DefaultMutableTreeNode node = null;
        while (nodes.hasMoreElements()) {
            TreePath path;
            node = (DefaultMutableTreeNode)nodes.nextElement();
            BasicFavoritesNavigatorUI.debug("expandPath :" + node);
            if (node.getChildCount() > 0) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
                path = new TreePath(child.getPath());
                this.tree.makeVisible(path);
                continue;
            }
            Object[] treeNode = node.getPath();
            path = new TreePath(treeNode);
            this.tree.makeVisible(path);
        }
    }

    private Vector findNodes(String target) {
        Enumeration<TreeNode> nodes = this.topNode.preorderEnumeration();
        DefaultMutableTreeNode node = null;
        Vector<DefaultMutableTreeNode> nodeFound = new Vector<DefaultMutableTreeNode>();
        while (nodes.hasMoreElements()) {
            node = (DefaultMutableTreeNode)nodes.nextElement();
            BasicFavoritesNavigatorUI.debug(" node :" + node.toString());
            if (node == null) continue;
            FavoritesItem favoritesItem = (FavoritesItem)node.getUserObject();
            if (favoritesItem == null) {
                BasicFavoritesNavigatorUI.debug("favoritesItem is null");
                continue;
            }
            Map.ID id = (Map.ID)this.dataMap.get(favoritesItem);
            if (id == null) continue;
            BasicFavoritesNavigatorUI.debug("id name :" + id.id);
            BasicFavoritesNavigatorUI.debug("target :" + target);
            Map.ID itemID = null;
            try {
                itemID = Map.ID.create(target, this.favorites.getModel().getHelpSet());
            }
            catch (BadIDException exp) {
                System.err.println("Not valid ID :" + target);
                break;
            }
            if (!id.equals(itemID)) continue;
            nodeFound.addElement(node);
        }
        return nodeFound;
    }

    private void collapse(String target) {
        Enumeration nodes = this.findNodes(target).elements();
        DefaultMutableTreeNode node = null;
        BasicFavoritesNavigatorUI.debug("collapse called");
        while (nodes.hasMoreElements()) {
            TreePath path;
            node = (DefaultMutableTreeNode)nodes.nextElement();
            if (node.getChildCount() > 0) {
                Object[] treeNode = node.getPath();
                path = new TreePath(treeNode);
                this.tree.collapsePath(path);
                this.tree.collapseRow(this.tree.getRowForPath(path));
                continue;
            }
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            path = new TreePath(parent.getPath());
            this.tree.collapseRow(this.tree.getRowForPath(path));
        }
    }

    private void setVisibility(DefaultMutableTreeNode node) {
        this.tree.expandPath(new TreePath(node.getPath()));
        if (!node.isLeaf()) {
            int max = node.getChildCount();
            for (int i = 0; i < max; ++i) {
                this.setVisibility((DefaultMutableTreeNode)node.getChildAt(i));
            }
        }
    }

    public void idChanged(HelpModelEvent e) {
        Object o;
        BasicFavoritesNavigatorUI.debug("idChanged(" + e + ")");
        Map.ID id = e.getID();
        this.contentTitle = e.getHistoryName();
        URL nurl = e.getURL();
        String nURL = null;
        if (nurl != null) {
            nURL = nurl.toExternalForm();
        }
        Map.ID currentID = null;
        String currentURL = null;
        String currentName = null;
        FavoritesItem item = null;
        HelpModel helpModel = this.favorites.getModel();
        if (e.getSource() != helpModel) {
            BasicFavoritesNavigatorUI.debug("Internal inconsistency!");
            BasicFavoritesNavigatorUI.debug("  " + e.getSource() + " != " + helpModel);
            throw new Error("Internal error");
        }
        TreePath s = this.tree.getSelectionPath();
        if (s != null && (o = s.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)o;
            item = (FavoritesItem)tn.getUserObject();
            if (item != null) {
                currentID = (Map.ID)this.dataMap.get(item);
                currentURL = item.getURLSpec();
                currentName = item.getName();
            }
            if (currentName != null && currentName.equals(this.contentTitle)) {
                if (currentID != null && currentID.equals(id)) {
                    return;
                }
                if (currentURL != null && currentURL.equals(nURL)) {
                    return;
                }
            }
        }
        DefaultMutableTreeNode node = null;
        node = this.findID(this.topNode, id);
        if (node == null) {
            node = this.findURL(this.topNode, nURL);
        }
        if (node == null) {
            this.tree.clearSelection();
            return;
        }
        TreePath path = new TreePath(node.getPath());
        this.tree.expandPath(path);
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    private DefaultMutableTreeNode findID(DefaultMutableTreeNode node, Map.ID id) {
        BasicFavoritesNavigatorUI.debug("findID: (" + id + ")");
        BasicFavoritesNavigatorUI.debug("  node: " + node);
        if (id == null) {
            return null;
        }
        FavoritesItem item = (FavoritesItem)node.getUserObject();
        Map.ID itemID = (Map.ID)this.dataMap.get(item);
        if (itemID != null) {
            Map.ID testID = itemID;
            BasicFavoritesNavigatorUI.debug("  testID: " + testID);
            if (testID != null && testID.equals(id)) {
                return node;
            }
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode test = this.findID(tmp, id);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    private DefaultMutableTreeNode findURL(DefaultMutableTreeNode node, String urlSpec) {
        BasicFavoritesNavigatorUI.debug(" findURL: " + urlSpec);
        if (urlSpec == null) {
            return null;
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            FavoritesItem childItem = (FavoritesItem)child.getUserObject();
            String childName = childItem.getName();
            String childURL = childItem.getURLSpec();
            if (urlSpec.equals(childURL)) {
                return child;
            }
            this.findURL(child, urlSpec);
        }
        return null;
    }

    public void valueChanged(TreeSelectionEvent e) {
        FavoritesItem item;
        this.selectedTreePath = e.getNewLeadSelectionPath();
        if (this.selectedTreePath == null) {
            this.selectedNode = null;
            return;
        }
        this.selectedNode = (FavoritesNode)this.selectedTreePath.getLastPathComponent();
        if (this.selectedNode != null) {
            this.selectedItem = (FavoritesItem)this.selectedNode.getUserObject();
            this.selectedID = (Map.ID)this.dataMap.get(this.selectedItem);
        }
        HelpModel helpModel = this.favorites.getModel();
        HelpSet hs = helpModel.getHelpSet();
        BasicFavoritesNavigatorUI.debug("ValueChanged: " + e);
        BasicFavoritesNavigatorUI.debug("  model: " + helpModel);
        if (helpModel == null) {
            return;
        }
        TreeItem[] items = null;
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            this.removeAction.setEnabled(true);
            items = new TreeItem[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i] == null) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                FavoritesItem favItem = (FavoritesItem)node.getUserObject();
                try {
                    String target = favItem.getTarget();
                    if (target != null) {
                        Map.ID id = Map.ID.create(favItem.getTarget(), hs);
                        favItem.setID(id);
                    }
                }
                catch (BadIDException ee) {
                    // empty catch block
                }
                items[i] = favItem;
            }
        } else {
            this.removeAction.setEnabled(false);
            this.pasteAction.setEnabled(false);
            this.pasteMI.setEnabled(false);
            return;
        }
        this.favorites.setSelectedItems(items);
        if (items != null && items.length == 1 && (item = (FavoritesItem)items[0]) != null) {
            Map.ID itemID = (Map.ID)this.dataMap.get(item);
            if (itemID != null) {
                BasicFavoritesNavigatorUI.debug("itemID: " + itemID);
                try {
                    helpModel.setCurrentID(itemID, item.getName(), this.favorites);
                }
                catch (InvalidHelpSetContextException ex) {
                    System.err.println("BadID: " + item.getID());
                    return;
                }
            }
            if (item.getURLSpec() != null) {
                try {
                    URL url = new URL(item.getURLSpec());
                    helpModel.setCurrentURL(url, item.getName(), this.favorites);
                }
                catch (MalformedURLException ep) {
                    System.err.println(ep);
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String changeName;
        BasicFavoritesNavigatorUI.debug("propertyChange: " + event.getSource() + " " + event.getPropertyName());
        if (event.getSource() == this.favorites) {
            String changeName2 = event.getPropertyName();
            if (changeName2.equals("helpModel")) {
                BasicFavoritesNavigatorUI.debug("model changed");
                this.reloadData();
            } else if (changeName2.equals("font")) {
                BasicFavoritesNavigatorUI.debug("Font change");
                Font newFont = (Font)event.getNewValue();
                this.tree.setFont(newFont);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            } else if (changeName2.equals("expand")) {
                BasicFavoritesNavigatorUI.debug("Expand change");
                this.expand((String)event.getNewValue());
            } else if (changeName2.equals("collapse")) {
                BasicFavoritesNavigatorUI.debug("Collapse change");
                this.collapse((String)event.getNewValue());
            } else if (changeName2.equals("navigatorChange")) {
                BasicFavoritesNavigatorUI.debug("Navigator change");
                this.tree.clearSelection();
            }
        } else if (this.favorites != null && event.getSource() == this.favorites.getModel() && (changeName = event.getPropertyName()).equals("helpSet")) {
            this.reloadData();
        }
    }

    public void helpSetAdded(HelpSetEvent ev) {
        BasicFavoritesNavigatorUI.debug("HelpSet added");
        this.reloadData();
    }

    public void helpSetRemoved(HelpSetEvent ev) {
        BasicFavoritesNavigatorUI.debug("HelpSet removed");
        this.reloadData();
    }

    public void saveFavorites() {
        FavoritesView view = (FavoritesView)this.favorites.getNavigatorView();
        view.saveFavorites(this.rootNode);
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        BasicFavoritesNavigatorUI.debug("tree structure changed");
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        block8: {
            FavoritesNode rootParent;
            int firstIndex;
            Object[] nodes;
            FavoritesNode parent;
            int place;
            block7: {
                BasicFavoritesNavigatorUI.debug("node inserted");
                place = -1;
                parent = (FavoritesNode)treeModelEvent.getTreePath().getLastPathComponent();
                nodes = treeModelEvent.getChildren();
                int[] indices = treeModelEvent.getChildIndices();
                firstIndex = indices[0];
                BasicFavoritesNavigatorUI.debug("index first " + firstIndex);
                int lastIndex = indices.length + firstIndex - 1;
                rootParent = (FavoritesNode)this.connections.get(parent);
                if (rootParent == null) {
                    rootParent = this.rootNode;
                }
                BasicFavoritesNavigatorUI.debug("root parent " + rootParent);
                if (firstIndex != 0) break block7;
                if (rootParent.getChildCount() == 0) {
                    place = 0;
                } else {
                    Enumeration<TreeNode> en = rootParent.children();
                    while (en.hasMoreElements()) {
                        FavoritesNode node = (FavoritesNode)en.nextElement();
                        if (!node.isVisible()) continue;
                        BasicFavoritesNavigatorUI.debug("is visible : " + node);
                        place = rootParent.getIndex(node);
                        break;
                    }
                }
                if (place < 0) break block8;
                for (int j = nodes.length - 1; j >= 0; --j) {
                    FavoritesNode copy = ((FavoritesNode)nodes[j]).getDeepCopy();
                    rootParent.insert(copy, place);
                    this.connections.put((FavoritesNode)nodes[j], copy);
                }
                break block8;
            }
            if (firstIndex > 0) {
                FavoritesNode nodeBefore = (FavoritesNode)parent.getChildAt(firstIndex - 1);
                FavoritesNode rootNode = (FavoritesNode)this.connections.get(nodeBefore);
                place = rootParent.getIndex(rootNode) + 1;
                for (int k = nodes.length - 1; k >= 0; --k) {
                    FavoritesNode copyNode = ((FavoritesNode)nodes[k]).getDeepCopy();
                    rootParent.insert(copyNode, place);
                    this.connections.put((FavoritesNode)nodes[k], copyNode);
                }
            }
        }
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        BasicFavoritesNavigatorUI.debug("nodes removed");
        Object[] nodes = treeModelEvent.getChildren();
        for (int i = 0; i < nodes.length; ++i) {
            FavoritesNode originalNode = (FavoritesNode)nodes[i];
            FavoritesNode remNode = (FavoritesNode)this.connections.get(originalNode);
            if (remNode == null) continue;
            remNode.removeFromParent();
        }
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        BasicFavoritesNavigatorUI.debug("node changed");
        TreeCellEditor editor = this.tree.getCellEditor();
        Object newName = editor.getCellEditorValue();
        if (newName instanceof String && this.selectedItem != null) {
            BasicFavoritesNavigatorUI.debug("new name");
            Map.ID itemID = (Map.ID)this.dataMap.get(this.selectedItem);
            this.dataMap.remove(this.selectedItem);
            FavoritesNode fromRootNode = (FavoritesNode)this.connections.get(this.getSelectedNode());
            this.selectedItem.setName((String)newName);
            this.selectedNode.setUserObject(this.selectedItem);
            if (fromRootNode != null) {
                FavoritesItem fromRootItem = (FavoritesItem)fromRootNode.getUserObject();
                fromRootItem.setName((String)newName);
            }
            this.dataMap.put(this.selectedItem, itemID);
            this.saveFavorites();
        }
    }

    public FavoritesNode getSelectedNode() {
        return this.selectedNode;
    }

    public Action getAddAction() {
        return this.addAction;
    }

    public Action getRemoveAction() {
        return this.removeAction;
    }

    public Action getFolderAction() {
        return this.folderAction;
    }

    public Action getCutAction() {
        return this.cutAction;
    }

    public Action getPasteAction() {
        return this.pasteAction;
    }

    public Action getCopyAction() {
        return this.copyAction;
    }

    private static void debug(String str) {
        if (debug) {
            System.out.println("BasicFavoritesNavigatorUI: " + str);
        }
    }

    static {
        try {
            Class<?> klass = Class.forName("javax.swing.InputVerifier");
            on1dot3 = klass != null;
        }
        catch (ClassNotFoundException e) {
            on1dot3 = false;
        }
        debug = false;
    }

    public class FavoritesTree
    extends JTree
    implements DragGestureListener,
    DropTargetListener,
    DragSourceListener {
        protected Map.ID selectedID;
        private DragSource dragSource;
        private DragSourceContext dragSourceContext;
        private Point cursorLocation;
        private TreePath pathSource;
        private BufferedImage ghostImage;
        private Point offset;
        private Point ptLast;
        private Rectangle2D ghostRect;
        private Map.ID hashCandidate;
        private Cursor dndCursor;

        public FavoritesTree(FavoritesNode root) {
            super(root);
            this.selectedID = null;
            this.dragSource = null;
            this.dragSourceContext = null;
            this.cursorLocation = null;
            this.offset = new Point();
            this.ptLast = new Point();
            this.ghostRect = new Rectangle2D.Float();
            this.setEditable(true);
            this.dragSource = DragSource.getDefaultDragSource();
            DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
            dgr.setSourceActions(dgr.getSourceActions() & 0xFFFFFFFB);
            DropTarget dropTarget = new DropTarget(this, this);
            Toolkit tk = this.getToolkit();
            if (tk.getBestCursorSize(16, 16).equals(new Dimension(64, 64))) {
                this.dndCursor = (Cursor)UIManager.get("HelpDnDCursor");
            }
            if (this.dndCursor == null) {
                BasicFavoritesNavigatorUI.debug("cursor is null");
            }
            this.putClientProperty("JTree.lineStyle", "None");
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            FavoritesNode dragNode = BasicFavoritesNavigatorUI.this.getSelectedNode();
            if (dragNode != null) {
                this.ghostImage = this.createGhostImage(e);
                Transferable transferable = (Transferable)dragNode.getUserObject();
                this.hashCandidate = (Map.ID)BasicFavoritesNavigatorUI.this.dataMap.get((FavoritesItem)transferable);
                Cursor cursor = DragSource.DefaultCopyDrop;
                int action = e.getDragAction();
                if (action == 2) {
                    BasicFavoritesNavigatorUI.debug("action move");
                    cursor = DragSource.DefaultMoveDrop;
                }
                this.dragSource.startDrag(e, this.dndCursor, this.ghostImage, new Point(5, 5), transferable, this);
            }
        }

        private BufferedImage createGhostImage(DragGestureEvent e) {
            BasicFavoritesNavigatorUI.debug("createGhostImage");
            BufferedImage ghostImage = null;
            Point ptDragOrigin = e.getDragOrigin();
            TreePath path = this.getPathForLocation(ptDragOrigin.x, ptDragOrigin.y);
            if (path == null) {
                return ghostImage;
            }
            Rectangle raPath = this.getPathBounds(path);
            this.offset.setLocation(ptDragOrigin.x - raPath.x, ptDragOrigin.y - raPath.y);
            JLabel lbl = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, path.getLastPathComponent(), false, this.isExpanded(path), this.getModel().isLeaf(path.getLastPathComponent()), 0, false);
            lbl.setSize((int)raPath.getWidth(), (int)raPath.getHeight());
            ghostImage = new BufferedImage((int)raPath.getWidth(), (int)raPath.getHeight(), 3);
            Graphics2D g2 = ghostImage.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
            lbl.paint(g2);
            Icon icon = lbl.getIcon();
            int nStartOfText = icon == null ? 0 : icon.getIconWidth() + lbl.getIconTextGap();
            g2.setComposite(AlphaComposite.getInstance(4, 0.5f));
            g2.setPaint(new GradientPaint(nStartOfText, 0.0f, SystemColor.controlShadow, this.getWidth(), 0.0f, new Color(255, 255, 255, 0)));
            g2.fillRect(nStartOfText, 0, this.getWidth(), ghostImage.getHeight());
            g2.dispose();
            return ghostImage;
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            BasicFavoritesNavigatorUI.debug("dragDropEnd");
        }

        public void dragEnter(DragSourceDragEvent dsde) {
            BasicFavoritesNavigatorUI.debug("dragEnter");
            this.setCursor(dsde);
        }

        public void dragOver(DragSourceDragEvent dsde) {
            BasicFavoritesNavigatorUI.debug("drag over");
            this.setCursor(dsde);
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
            BasicFavoritesNavigatorUI.debug("dropActionChanged");
            this.setCursor(dsde);
        }

        public void dragExit(DragSourceEvent dsde) {
            BasicFavoritesNavigatorUI.debug("dragExit");
        }

        private void setCursor(DragSourceDragEvent dsde) {
            if (this.cursorLocation == null) {
                return;
            }
            TreePath destinationPath = this.getPathForLocation(this.cursorLocation.x, this.cursorLocation.y);
            DragSourceContext dsc = dsde.getDragSourceContext();
            if (this.testDropTarget(destinationPath, BasicFavoritesNavigatorUI.this.selectedTreePath) == null) {
                dsc.setCursor(DragSource.DefaultCopyDrop);
            } else {
                dsc.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        public void drop(DropTargetDropEvent e) {
            BasicFavoritesNavigatorUI.debug("drop");
            try {
                Transferable tr = e.getTransferable();
                if (!tr.isDataFlavorSupported(FavoritesItem.FAVORITES_FLAVOR)) {
                    BasicFavoritesNavigatorUI.debug("drop rejected not data flavor");
                    e.rejectDrop();
                }
                FavoritesItem childInfo = (FavoritesItem)tr.getTransferData(FavoritesItem.FAVORITES_FLAVOR);
                Point loc = e.getLocation();
                TreePath destinationPath = this.getPathForLocation(loc.x, loc.y);
                String msg = this.testDropTarget(destinationPath, BasicFavoritesNavigatorUI.this.selectedTreePath);
                if (msg != null) {
                    e.rejectDrop();
                    BasicFavoritesNavigatorUI.debug("Error : " + msg);
                    return;
                }
                FavoritesNode newParent = (FavoritesNode)destinationPath.getLastPathComponent();
                BasicFavoritesNavigatorUI.debug("new parent: " + newParent);
                FavoritesNode oldParent = (FavoritesNode)BasicFavoritesNavigatorUI.this.getSelectedNode().getParent();
                FavoritesNode selNode = BasicFavoritesNavigatorUI.this.getSelectedNode();
                FavoritesItem selItem = (FavoritesItem)selNode.getUserObject();
                FavoritesNode newNode = selNode.getDeepCopy();
                int action = e.getDropAction();
                boolean copyAction = action == 1;
                BasicFavoritesNavigatorUI.debug("copy action: " + copyAction);
                FavoritesNode newChild = new FavoritesNode(childInfo);
                BasicFavoritesNavigatorUI.debug("new child: " + newChild);
                try {
                    if (!copyAction) {
                        FavoritesNode fromRootNode = (FavoritesNode)BasicFavoritesNavigatorUI.this.connections.get(BasicFavoritesNavigatorUI.this.getSelectedNode());
                        if (fromRootNode != null) {
                            fromRootNode.removeFromParent();
                        }
                        oldParent.remove(BasicFavoritesNavigatorUI.this.getSelectedNode());
                    }
                    DefaultTreeModel model = (DefaultTreeModel)this.getModel();
                    if (!newParent.getAllowsChildren()) {
                        TreeNode parent = newParent.getParent();
                        if (parent != null) {
                            int index = parent.getIndex(newParent);
                            model.insertNodeInto(newNode, (DefaultMutableTreeNode)parent, index + 1);
                        }
                    } else {
                        model.insertNodeInto(newNode, newParent, newParent.getChildCount());
                    }
                    if (copyAction) {
                        e.acceptDrop(1);
                    } else {
                        e.acceptDrop(2);
                    }
                }
                catch (IllegalStateException ils) {
                    BasicFavoritesNavigatorUI.debug("drop ejected");
                    e.rejectDrop();
                }
                e.getDropTargetContext().dropComplete(true);
                FavoritesItem newItem = (FavoritesItem)newNode.getUserObject();
                BasicFavoritesNavigatorUI.this.dataMap.put(newItem, this.hashCandidate);
                DefaultTreeModel model = (DefaultTreeModel)this.getModel();
                model.reload(oldParent);
                model.reload(newParent);
                TreePath parentPath = new TreePath(newParent.getPath());
                this.expandPath(parentPath);
                BasicFavoritesNavigatorUI.this.saveFavorites();
            }
            catch (IOException io) {
                e.rejectDrop();
                BasicFavoritesNavigatorUI.debug("drop rejected" + io);
            }
            catch (UnsupportedFlavorException ufe) {
                e.rejectDrop();
                BasicFavoritesNavigatorUI.debug("drop rejected: " + ufe);
            }
        }

        public void dragEnter(DropTargetDragEvent e) {
        }

        public void dragExit(DropTargetEvent e) {
            if (!DragSource.isDragImageSupported()) {
                this.repaint(this.ghostRect.getBounds());
            }
        }

        public void dragOver(DropTargetDragEvent e) {
            Point pt = e.getLocation();
            if (pt.equals(this.ptLast)) {
                return;
            }
            this.ptLast = pt;
            Point cursorLocationBis = e.getLocation();
            TreePath destinationPath = this.getPathForLocation(cursorLocationBis.x, cursorLocationBis.y);
            Graphics2D g2 = (Graphics2D)this.getGraphics();
            if (this.testDropTarget(destinationPath, BasicFavoritesNavigatorUI.this.selectedTreePath) == null) {
                e.acceptDrag(3);
                if (!DragSource.isDragImageSupported()) {
                    this.paintImmediately(this.ghostRect.getBounds());
                    this.ghostRect.setRect(pt.x - this.offset.x, pt.y - this.offset.y, this.ghostImage.getWidth(), this.ghostImage.getHeight());
                    g2.drawImage(this.ghostImage, AffineTransform.getTranslateInstance(this.ghostRect.getX(), this.ghostRect.getY()), null);
                }
            } else {
                e.rejectDrag();
            }
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }

        private String testDropTarget(TreePath destination, TreePath dropper) {
            boolean destinationPathIsNull;
            boolean bl = destinationPathIsNull = destination == null;
            if (destinationPathIsNull) {
                return "Invalid drop location.";
            }
            FavoritesNode node = (FavoritesNode)destination.getLastPathComponent();
            if (destination.equals(dropper)) {
                return "Destination cannot be same as source";
            }
            if (dropper.isDescendant(destination)) {
                return "Destination node cannot be a descendant.";
            }
            if (dropper.getParentPath().equals(destination)) {
                return "Destination node cannot be a parent.";
            }
            return null;
        }
    }

    public class PopupListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            TreePath path = BasicFavoritesNavigatorUI.this.tree.getSelectionPath();
            TreePath clickPath = BasicFavoritesNavigatorUI.this.tree.getPathForLocation(e.getX(), e.getY());
            if (e.isPopupTrigger()) {
                if (path != null && path.equals(clickPath)) {
                    BasicFavoritesNavigatorUI.this.separatorMI.setVisible(true);
                    BasicFavoritesNavigatorUI.this.cutMI.setVisible(true);
                    BasicFavoritesNavigatorUI.this.copyMI.setVisible(true);
                    BasicFavoritesNavigatorUI.this.pasteMI.setVisible(true);
                    BasicFavoritesNavigatorUI.this.removeMI.setVisible(true);
                } else {
                    BasicFavoritesNavigatorUI.this.separatorMI.setVisible(false);
                    BasicFavoritesNavigatorUI.this.cutMI.setVisible(false);
                    BasicFavoritesNavigatorUI.this.copyMI.setVisible(false);
                    BasicFavoritesNavigatorUI.this.pasteMI.setVisible(false);
                    BasicFavoritesNavigatorUI.this.removeMI.setVisible(false);
                }
                BasicFavoritesNavigatorUI.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super(HelpUtilities.getString(BasicFavoritesNavigatorUI.this.locale, "favorites.copy"));
        }

        public void actionPerformed(ActionEvent ev) {
            BasicFavoritesNavigatorUI.debug("paste");
            DefaultMutableTreeNode node = null;
            BasicFavoritesNavigatorUI.this.nodeClipboard.removeAllElements();
            DefaultTreeModel model = (DefaultTreeModel)BasicFavoritesNavigatorUI.this.tree.getModel();
            TreePath[] paths = BasicFavoritesNavigatorUI.this.tree.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i] == null || (node = (DefaultMutableTreeNode)paths[i].getLastPathComponent()) == null) continue;
                FavoritesItem item = (FavoritesItem)node.getUserObject();
                FavoritesNode copy = ((FavoritesNode)node).getDeepCopy();
                BasicFavoritesNavigatorUI.this.nodeClipboard.add(copy);
            }
            BasicFavoritesNavigatorUI.this.saveFavorites();
            BasicFavoritesNavigatorUI.this.pasteMI.setEnabled(true);
        }
    }

    public class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super(HelpUtilities.getString(BasicFavoritesNavigatorUI.this.locale, "favorites.paste"));
        }

        public void actionPerformed(ActionEvent ev) {
            BasicFavoritesNavigatorUI.debug("paste");
            DefaultTreeModel model = (DefaultTreeModel)BasicFavoritesNavigatorUI.this.tree.getModel();
            TreePath path = BasicFavoritesNavigatorUI.this.tree.getSelectionPath();
            FavoritesNode node = (FavoritesNode)path.getLastPathComponent();
            if (node != null) {
                if (node.getAllowsChildren()) {
                    Enumeration nodes = BasicFavoritesNavigatorUI.this.nodeClipboard.elements();
                    while (nodes.hasMoreElements()) {
                        model.insertNodeInto((DefaultMutableTreeNode)nodes.nextElement(), node, node.getChildCount());
                    }
                } else {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    if (parent == null) {
                        return;
                    }
                    int index = parent.getIndex(node);
                    Enumeration en = BasicFavoritesNavigatorUI.this.nodeClipboard.elements();
                    while (en.hasMoreElements()) {
                        model.insertNodeInto((DefaultMutableTreeNode)en.nextElement(), parent, index);
                        ++index;
                    }
                }
                BasicFavoritesNavigatorUI.this.saveFavorites();
            }
        }
    }

    public class CutAction
    extends AbstractAction {
        public CutAction() {
            super(HelpUtilities.getString(BasicFavoritesNavigatorUI.this.locale, "favorites.cut"));
        }

        public void actionPerformed(ActionEvent ev) {
            BasicFavoritesNavigatorUI.debug("cut");
            DefaultMutableTreeNode node = null;
            BasicFavoritesNavigatorUI.this.nodeClipboard.removeAllElements();
            DefaultTreeModel model = (DefaultTreeModel)BasicFavoritesNavigatorUI.this.tree.getModel();
            TreePath[] paths = BasicFavoritesNavigatorUI.this.tree.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i] == null) continue;
                node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                if (node != null) {
                    FavoritesItem item = (FavoritesItem)node.getUserObject();
                    BasicFavoritesNavigatorUI.this.nodeClipboard.add(node);
                }
                model.removeNodeFromParent(node);
            }
            BasicFavoritesNavigatorUI.this.saveFavorites();
            BasicFavoritesNavigatorUI.this.pasteMI.setEnabled(true);
        }
    }

    public class FolderAction
    extends AbstractAction {
        public FolderAction() {
            super(HelpUtilities.getString(BasicFavoritesNavigatorUI.this.locale, "favorites.folder"), SwingHelpUtilities.getImageIcon(class$javax$help$plaf$basic$BasicFavoritesNavigatorUI == null ? (class$javax$help$plaf$basic$BasicFavoritesNavigatorUI = BasicFavoritesNavigatorUI.class$("javax.help.plaf.basic.BasicFavoritesNavigatorUI")) : class$javax$help$plaf$basic$BasicFavoritesNavigatorUI, "images/folder.gif"));
        }

        public void actionPerformed(ActionEvent ev) {
            FavoritesItem favoriteFolder = new FavoritesItem(HelpUtilities.getString(BasicFavoritesNavigatorUI.this.locale, "favorites.folder"));
            favoriteFolder.setAsFolder();
            FavoritesNode node = new FavoritesNode(favoriteFolder);
            TreePath nodePath = BasicFavoritesNavigatorUI.this.tree.getSelectionPath();
            TreeNode parent = null;
            if (nodePath == null) {
                parent = BasicFavoritesNavigatorUI.this.topNode;
            } else {
                FavoritesNode selNode = (FavoritesNode)nodePath.getLastPathComponent();
                parent = selNode.getParent();
            }
            DefaultTreeModel model = (DefaultTreeModel)BasicFavoritesNavigatorUI.this.tree.getModel();
            model.insertNodeInto(node, (DefaultMutableTreeNode)parent, parent.getChildCount());
            TreePath path = new TreePath(node.getPath());
            BasicFavoritesNavigatorUI.this.tree.expandPath(path);
            BasicFavoritesNavigatorUI.this.tree.setSelectionPath(path);
            BasicFavoritesNavigatorUI.this.tree.scrollPathToVisible(path);
            BasicFavoritesNavigatorUI.this.saveFavorites();
        }
    }

    public class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super(HelpUtilities.getString(BasicFavoritesNavigatorUI.this.locale, "favorites.remove"), SwingHelpUtilities.getImageIcon(class$javax$help$plaf$basic$BasicFavoritesNavigatorUI == null ? (class$javax$help$plaf$basic$BasicFavoritesNavigatorUI = BasicFavoritesNavigatorUI.class$("javax.help.plaf.basic.BasicFavoritesNavigatorUI")) : class$javax$help$plaf$basic$BasicFavoritesNavigatorUI, "images/remove.gif"));
        }

        public void actionPerformed(ActionEvent ev) {
            BasicFavoritesNavigatorUI.debug("remove");
            DefaultMutableTreeNode node = null;
            DefaultTreeModel model = (DefaultTreeModel)BasicFavoritesNavigatorUI.this.tree.getModel();
            TreePath[] paths = BasicFavoritesNavigatorUI.this.tree.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i] != null) {
                    node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                    model.removeNodeFromParent(node);
                    if (node != null) {
                        FavoritesItem item = (FavoritesItem)node.getUserObject();
                        BasicFavoritesNavigatorUI.this.dataMap.remove(item);
                    }
                }
                BasicFavoritesNavigatorUI.this.saveFavorites();
            }
        }
    }

    public class AddAction
    extends AbstractAction {
        public AddAction() {
            super(HelpUtilities.getString(BasicFavoritesNavigatorUI.this.locale, "favorites.add"), SwingHelpUtilities.getImageIcon(class$javax$help$plaf$basic$BasicFavoritesNavigatorUI == null ? (class$javax$help$plaf$basic$BasicFavoritesNavigatorUI = BasicFavoritesNavigatorUI.class$("javax.help.plaf.basic.BasicFavoritesNavigatorUI")) : class$javax$help$plaf$basic$BasicFavoritesNavigatorUI, "images/addToFav.gif"));
        }

        public void actionPerformed(ActionEvent ev) {
            BasicFavoritesNavigatorUI.debug("add");
            String target = null;
            String hstitle = null;
            FavoritesItem favorite = null;
            HelpModel helpModel = BasicFavoritesNavigatorUI.this.favorites.getModel();
            HelpSet hs = helpModel.getHelpSet();
            Map.ID ID2 = helpModel.getCurrentID();
            URL url = helpModel.getCurrentURL();
            if (ID2 != null) {
                target = ID2.id;
                hstitle = ID2.hs.getTitle();
            }
            if (hstitle == null && (hstitle = this.getHelpSetTitle(hs, url)) == null) {
                hstitle = hs.getTitle();
            }
            String urlSpec = null;
            if (target == null) {
                urlSpec = url.toExternalForm();
            }
            favorite = new FavoritesItem(BasicFavoritesNavigatorUI.this.contentTitle, target, urlSpec, hstitle, Locale.getDefault());
            BasicFavoritesNavigatorUI.this.dataMap.put(favorite, ID2);
            FavoritesNode node = new FavoritesNode(favorite);
            DefaultTreeModel model = (DefaultTreeModel)BasicFavoritesNavigatorUI.this.tree.getModel();
            model.insertNodeInto(node, BasicFavoritesNavigatorUI.this.topNode, BasicFavoritesNavigatorUI.this.topNode.getChildCount());
            TreePath path = new TreePath(node.getPath());
            BasicFavoritesNavigatorUI.this.tree.expandPath(path);
            BasicFavoritesNavigatorUI.this.tree.setSelectionPath(path);
            BasicFavoritesNavigatorUI.this.tree.scrollPathToVisible(path);
            BasicFavoritesNavigatorUI.this.saveFavorites();
        }

        private String getHelpSetTitle(HelpSet hs, URL url) {
            HelpSet testHS;
            String baseURLExternal;
            URL baseURL = hs.getHelpSetURL();
            String urlExternal = url.toExternalForm();
            if (urlExternal.startsWith(baseURLExternal = baseURL.toExternalForm())) {
                return hs.getTitle();
            }
            Enumeration helpsets = hs.getHelpSets();
            String title = null;
            while (helpsets.hasMoreElements() && (title = this.getHelpSetTitle(testHS = (HelpSet)helpsets.nextElement(), url)) == null) {
            }
            return title;
        }
    }
}

