/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.console;

import com.artenum.rosetta.interfaces.core.ConsoleAction;
import com.artenum.rosetta.interfaces.core.InputParsingManager;
import com.artenum.rosetta.interfaces.ui.InputCommandView;
import com.artenum.rosetta.interfaces.ui.OutputView;
import com.artenum.rosetta.interfaces.ui.PromptView;
import com.artenum.rosetta.ui.Console;
import com.artenum.rosetta.util.ConfigurationBuilder;
import com.artenum.rosetta.util.ConsoleBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.ParserConfigurationException;
import org.scilab.modules.commons.xml.ScilabXMLUtilities;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.commons.xml.XConfigurationListener;
import org.scilab.modules.console.ConsoleConfiguration;
import org.scilab.modules.console.ConsoleOptions;
import org.scilab.modules.console.GuiManagement;
import org.scilab.modules.console.SciCompletionWindow;
import org.scilab.modules.console.SciHistoryManager;
import org.scilab.modules.console.SciInputCommandView;
import org.scilab.modules.console.SciInputParsingManager;
import org.scilab.modules.console.SciOutputView;
import org.scilab.modules.console.SciPromptView;
import org.scilab.modules.console.SmartScroller;
import org.scilab.modules.localization.Messages;
import org.xml.sax.SAXException;

public abstract class SciConsole
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int LINE_NUMBER_IN_PROMPT = 2;
    private static final String BACKSLASH_R = "\r";
    private static final String XPATH_CONSOLE_KEY = "//general/shortcuts/body/actions/action-folder[@name='Console']/action";
    private static final String XPATH_CONSOLE_ACTION = "/map/console/entry";
    private static final int MAX_CMD_LENGTH = 4096;
    private static Map<KeyStroke, String> actionKeys;
    private static final Map<String, String> actionToName;
    private com.artenum.rosetta.interfaces.core.ConsoleConfiguration config;
    private JScrollPane jSP;
    private Console sciConsole;
    private int userInputValue;
    private Semaphore canReadUserInputValue = new Semaphore(1);
    private boolean workDone;
    private boolean atBottom;
    private boolean isToHome;
    private Object searchField;

    public SciConsole(String string) {
        super(new BorderLayout());
        Object object;
        try {
            this.config = ConfigurationBuilder.buildConfiguration((String)string);
            this.config.setActiveProfile("scilab");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        this.sciConsole = ConsoleBuilder.buildConsole((com.artenum.rosetta.interfaces.core.ConsoleConfiguration)this.config, (Component)this);
        try {
            object = Class.forName("org.scilab.modules.gui.utils.HelpSearchField");
            Constructor<?> constructor = ((Class)object).getConstructor(JPanel.class, JTextComponent.class);
            this.searchField = constructor.newInstance(this, (SciOutputView)this.config.getOutputView());
        }
        catch (Exception exception) {
            // empty catch block
        }
        XConfiguration.addXConfigurationListener((XConfigurationListener)new ConsoleConfiguration(this));
        this.sciConsole.setForeground(ConsoleOptions.getConsoleColor().foreground);
        this.sciConsole.setBackground(ConsoleOptions.getConsoleColor().background);
        this.setCaretColor(ConsoleOptions.getConsoleColor().cursor);
        this.sciConsole.setFont(ConsoleOptions.getConsoleFont().font);
        this.setKeyStrokeAction();
        this.jSP = new JScrollPane((Component)this.sciConsole);
        object = this.jSP.getVerticalScrollBar().getModel();
        this.jSP.getVerticalScrollBar().setModel(new DefaultBoundedRangeModel(object.getValue(), object.getExtent(), object.getMinimum(), object.getMaximum()){

            @Override
            public void setRangeProperties(int n, int n2, int n3, int n4, boolean bl) {
                if (n4 != this.getMaximum()) {
                    if (!bl) {
                        if (SciConsole.this.atBottom) {
                            super.setRangeProperties(n4 - n2, n2, n3, n4, false);
                        } else {
                            super.setRangeProperties(n, n2, n3, n4, false);
                        }
                    } else {
                        double d = (double)Math.abs(n4 - n - n2) / (double)n4;
                        if (SciConsole.this.atBottom && d <= 0.03) {
                            super.setRangeProperties(n4 - n2, n2, n3, n4, true);
                        } else {
                            super.setRangeProperties(n, n2, n3, n4, true);
                            SciConsole.this.atBottom = d <= 0.01;
                        }
                    }
                } else {
                    super.setRangeProperties(n, n2, n3, n4, bl);
                }
            }
        });
        this.add((Component)this.jSP, "Center");
        ((SciOutputView)this.config.getOutputView()).setConsole(this);
        ((SciInputCommandView)this.config.getInputCommandView()).setConsole(this);
        ((SciCompletionWindow)this.config.getCompletionWindow()).setConsole(this);
        ((SciCompletionWindow)this.config.getCompletionWindow()).setGraphicalContext(this);
        ((SciInputParsingManager)this.config.getInputParsingManager()).setPromptView(this.getConfiguration().getPromptView());
        ((SciHistoryManager)this.config.getHistoryManager()).setInHistory(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SciConsole.this.scilabLinesUpdate();
                        SciConsole.this.jSP.getVerticalScrollBar().setBlockIncrement(SciConsole.this.jSP.getViewport().getExtentSize().height);
                        SciConsole.this.jSP.getHorizontalScrollBar().setBlockIncrement(SciConsole.this.jSP.getViewport().getExtentSize().width);
                    }
                });
            }
        });
        new SmartScroller(this.jSP);
        this.sciConsole.invalidate();
        this.sciConsole.doLayout();
    }

    public void configurationChanged(ConsoleConfiguration.Conf conf) {
        if (conf.color) {
            this.sciConsole.setForeground(ConsoleOptions.getConsoleColor().foreground);
            this.sciConsole.setBackground(ConsoleOptions.getConsoleColor().background);
            this.setCaretColor(ConsoleOptions.getConsoleColor().cursor);
        }
        if (conf.font) {
            this.sciConsole.setFont(ConsoleOptions.getConsoleFont().font);
        }
        if (conf.display) {
            ((SciOutputView)this.config.getOutputView()).setMaxSize(ConsoleOptions.getConsoleDisplay().maxOutputLines);
            this.scilabLinesUpdate();
        }
        if (conf.keymap) {
            actionKeys = null;
            this.setKeyStrokeAction();
        }
    }

    public static Map<KeyStroke, String> getActionKeys() {
        if (actionKeys == null) {
            org.w3c.dom.Document document = XConfiguration.getXConfigurationDocument();
            actionKeys = XConfiguration.get((org.w3c.dom.Document)document, (String)"key", KeyStroke.class, (String)"name", String.class, (String)XPATH_CONSOLE_KEY);
        }
        return actionKeys;
    }

    public static Map<String, String> getActionName() {
        return actionToName;
    }

    private void setKeyStrokeAction() {
        Map<KeyStroke, String> map = SciConsole.getActionKeys();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        for (Map.Entry<KeyStroke, String> entry : map.entrySet()) {
            Object object;
            KeyStroke keyStroke = entry.getKey();
            String string = entry.getValue();
            if (string.equals("console-search-field") && this.searchField != null) {
                try {
                    object = this.searchField.getClass().getMethod("setKeyStroke", KeyStroke.class);
                    ((Method)object).invoke(this.searchField, keyStroke);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((object = actionToName.get(string)) == null) continue;
            try {
                Class<?> clazz = classLoader.loadClass((String)object);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                Object obj = constructor.newInstance(new Object[0]);
                ((ConsoleAction)obj).setConfiguration(this.config);
                ((SciInputCommandView)this.config.getInputCommandView()).getInputMap().put(keyStroke, obj);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("No action: " + (String)object);
            }
            catch (InstantiationException instantiationException) {
                System.err.println("Problem to instantiate in action: " + (String)object);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("No valid constructor in action: " + (String)object);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("The constructor must be public: " + (String)object);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("The constructor in " + (String)object + " threw an exception :");
                invocationTargetException.printStackTrace();
            }
        }
    }

    public com.artenum.rosetta.interfaces.core.ConsoleConfiguration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(com.artenum.rosetta.interfaces.core.ConsoleConfiguration consoleConfiguration) {
        this.config = consoleConfiguration;
    }

    public void scilabLinesUpdate() {
        if (ConsoleOptions.getConsoleDisplay().adaptToDisplay) {
            int n;
            int n2 = this.jSP.getViewport().getExtentSize().width;
            OutputView outputView = this.getConfiguration().getOutputView();
            int[] nArray = ((JEditorPane)outputView).getFontMetrics(((JEditorPane)outputView).getFont()).getWidths();
            int n3 = nArray[33];
            for (n = 34; n < 126; ++n) {
                if (nArray[n] <= n3) continue;
                n3 = nArray[n];
            }
            n = this.getNumberOfLines();
            int n4 = ((JPanel)this.getConfiguration().getPromptView()).getPreferredSize().width;
            int n5 = (n2 - n4) / n3 - 1;
            if (n > 0 && n5 > 0) {
                GuiManagement.setScilabLines(Math.max(1, n), n5);
            }
        } else {
            GuiManagement.forceScilabLines(ConsoleOptions.getConsoleDisplay().nbLines, ConsoleOptions.getConsoleDisplay().nbColumns);
        }
    }

    public int getNumberOfLines() {
        int n = this.jSP.getViewport().getExtentSize().height;
        OutputView outputView = this.getConfiguration().getOutputView();
        int n2 = ((JEditorPane)outputView).getFontMetrics(((JEditorPane)outputView).getFont()).getHeight();
        int[] nArray = ((JEditorPane)outputView).getFontMetrics(((JEditorPane)outputView).getFont()).getWidths();
        int n3 = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= n3) continue;
            n3 = nArray[i];
        }
        return n / n2 - 1;
    }

    public void updateScrollPosition() {
        this.jSP.getVerticalScrollBar().setBlockIncrement(this.jSP.getViewport().getExtentSize().height);
        this.jSP.getHorizontalScrollBar().setBlockIncrement(this.jSP.getViewport().getExtentSize().width);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SciConsole.this.jSP.getVerticalScrollBar().getModel().setValue(SciConsole.this.jSP.getVerticalScrollBar().getModel().getMaximum() - SciConsole.this.jSP.getVerticalScrollBar().getModel().getExtent());
            }
        });
    }

    public void clear() {
        if (this.sciConsole.isPreferredSizeSet()) {
            this.sciConsole.setPreferredSize(null);
            this.sciConsole.invalidate();
            this.sciConsole.doLayout();
        }
        try {
            this.config.getInputCommandViewStyledDocument().remove(0, this.config.getInputCommandViewStyledDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.config.getOutputView().reset();
    }

    public void clear(int n) {
        if (this.sciConsole.isPreferredSizeSet()) {
            this.sciConsole.setPreferredSize(null);
            this.sciConsole.invalidate();
            this.sciConsole.doLayout();
        }
        try {
            int n2 = n + 2;
            this.config.getOutputView().append(" ");
            Document document = ((JEditorPane)this.config.getOutputView()).getDocument();
            String string = document.getText(0, document.getLength());
            String[] stringArray = string.split("\n");
            if (stringArray.length < n2) {
                this.config.getOutputView().reset();
                this.config.getOutputView().append(Messages.gettext((String)"Out of Screen"));
            } else {
                for (int i = 0; i < n2; ++i) {
                    string = document.getText(0, document.getLength());
                    int n3 = string.lastIndexOf("\n");
                    if (n3 == -1) continue;
                    document.remove(n3, document.getLength() - n3);
                }
            }
            this.config.getOutputView().append(BACKSLASH_R);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void toHome() {
        this.isToHome = true;
    }

    public void setToHome() {
        if (this.isToHome) {
            Dimension dimension = this.jSP.getViewport().getExtentSize();
            int n = ((SciInputCommandView)this.config.getInputCommandView()).getCaretHeight();
            int n2 = dimension.height + ((SciPromptView)this.config.getPromptView()).getParent().getBounds().y - n;
            Dimension dimension2 = new Dimension(this.sciConsole.getSize().width, n2);
            this.sciConsole.setPreferredSize(dimension2);
            this.sciConsole.invalidate();
            this.sciConsole.doLayout();
            ((SciOutputView)this.config.getOutputView()).addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    if (componentEvent.getComponent().getSize().height >= SciConsole.this.sciConsole.getSize().height) {
                        componentEvent.getComponent().removeComponentListener(this);
                        SciConsole.this.sciConsole.setPreferredSize(null);
                        SciConsole.this.sciConsole.invalidate();
                        SciConsole.this.sciConsole.doLayout();
                    }
                }
            });
            this.isToHome = false;
            this.jSP.getVerticalScrollBar().getModel().setValue(this.jSP.getVerticalScrollBar().getModel().getMaximum() - this.jSP.getVerticalScrollBar().getModel().getExtent());
        }
    }

    public int getUserInputValue() {
        try {
            this.canReadUserInputValue.acquire();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return this.userInputValue;
    }

    public void setUserInputValue(int n) {
        this.userInputValue = n;
        this.canReadUserInputValue.release();
    }

    public Semaphore getCanReadUserInputValue() {
        return this.canReadUserInputValue;
    }

    public void sendCommandsToScilab(String string, boolean bl, boolean bl2) {
        String[] stringArray = string.split("\n");
        this.atBottom = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (int i = 0; i < stringArray.length; ++i) {
            InputParsingManager inputParsingManager = this.config.getInputParsingManager();
            PromptView promptView = this.config.getPromptView();
            inputParsingManager.reset();
            this.config.getHistoryManager().setInHistory(false);
            this.config.getInputCommandView().setEditable(false);
            ((SciInputCommandView)this.config.getInputCommandView()).getCaret().setVisible(false);
            this.config.getPromptView().setVisible(false);
            if (stringArray[i].length() > 4096) {
                this.config.getOutputView().append(String.format(Messages.gettext((String)"Command is too long (more than %d characters long): could not send it to Scilab\n"), 4096));
                ((SciInputCommandView)this.config.getInputCommandView()).setCmdBuffer("", false);
                return;
            }
            ((SciInputCommandView)this.config.getInputCommandView()).setCmdBuffer(stringArray[i].replace(BACKSLASH_R, ""), bl);
            if (!bl2) continue;
            ((SciHistoryManager)this.config.getHistoryManager()).addEntry(stringArray[i].replace(BACKSLASH_R, ""));
        }
    }

    public JScrollPane getJScrollPane() {
        return this.jSP;
    }

    public Console getSciConsole() {
        return this.sciConsole;
    }

    public boolean isWaitingForInput() {
        return ((JTextPane)this.config.getInputCommandView()).isEditable();
    }

    public String readLine() {
        InputCommandView inputCommandView = this.getConfiguration().getInputCommandView();
        this.getConfiguration().getOutputView().setCaretPositionToEnd();
        this.displayPrompt();
        this.setCursor(Cursor.getPredefinedCursor(0));
        return ((SciInputCommandView)inputCommandView).getCmdBuffer();
    }

    public abstract void displayPrompt();

    public boolean isWorkDone() {
        return this.workDone;
    }

    @Override
    public void setFont(Font font) {
        if (this.sciConsole != null && !font.equals(this.getFont())) {
            this.sciConsole.setFont(font);
            try {
                Document document = ((JEditorPane)this.config.getOutputView()).getDocument();
                String string = document.getText(0, document.getLength());
                document.remove(0, document.getLength());
                this.config.getOutputView().append(string);
            }
            catch (BadLocationException badLocationException) {
                System.err.println(Messages.gettext((String)"Could not change the Console Font."));
                return;
            }
            ((SciPromptView)this.config.getPromptView()).getPromptUI().setFont(font);
            this.config.getPromptView().updatePrompt();
            this.scilabLinesUpdate();
        }
    }

    @Override
    public Font getFont() {
        if (this.sciConsole != null) {
            return ((SciPromptView)this.config.getPromptView()).getPromptUI().getFont();
        }
        return null;
    }

    @Override
    public Color getForeground() {
        if (this.sciConsole != null) {
            return this.sciConsole.getForeground();
        }
        return null;
    }

    @Override
    public Color getBackground() {
        if (this.sciConsole != null) {
            return this.sciConsole.getBackground();
        }
        return null;
    }

    @Override
    public void setForeground(Color color) {
        if (this.sciConsole != null) {
            this.sciConsole.setForeground(color);
            try {
                Document document = ((JEditorPane)this.config.getOutputView()).getDocument();
                String string = document.getText(0, document.getLength());
                document.remove(0, document.getLength());
                this.config.getOutputView().append(string);
            }
            catch (BadLocationException badLocationException) {
                System.out.println(Messages.gettext((String)"Could not change the Console Foreground."));
                return;
            }
            ((SciPromptView)this.config.getPromptView()).getPromptUI().setForeground(color);
            this.config.getPromptView().updatePrompt();
        }
    }

    @Override
    public void setBackground(Color color) {
        if (this.sciConsole != null) {
            this.sciConsole.setBackground(color);
        }
    }

    public void setCaretColor(Color color) {
        if (this.sciConsole != null) {
            ((SciInputCommandView)this.config.getInputCommandView()).setCaretColor(color);
        }
    }

    static {
        org.w3c.dom.Document document = ScilabXMLUtilities.readDocument((String)(System.getenv("SCI") + "/modules/console/etc/Actions-Configuration.xml"));
        actionToName = XConfiguration.get((org.w3c.dom.Document)document, (String)"name", String.class, (String)"action", String.class, (String)XPATH_CONSOLE_ACTION);
    }
}

