/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.console;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.scilab.modules.console.DropFiles;
import org.scilab.modules.console.SciConsole;
import org.scilab.modules.console.SciInputCommandView;
import org.scilab.modules.console.SciOutputView;

public class SciDropTargetListener
implements DropTargetListener {
    private SciConsole associatedConsole;

    public SciDropTargetListener(SciConsole sciConsole) {
        this.associatedConsole = sciConsole;
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(3);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
        }
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                String[] stringArray = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    File file = (File)list.get(i);
                    stringArray[i] = file.toString();
                }
                DropFiles.dropFiles(stringArray);
                ((SciOutputView)this.associatedConsole.getConfiguration().getOutputView()).getConsole().sendCommandsToScilab("", false, false);
            } else if (transferable.isDataFlavorSupported(dataFlavor)) {
                String string = (String)transferable.getTransferData(dataFlavor);
                ArrayList<String> arrayList = new ArrayList<String>(1);
                String[] stringArray = new StringTokenizer(string, "\r\n");
                while (stringArray.hasMoreTokens()) {
                    String string2 = stringArray.nextToken();
                    if (string2.length() <= 1) continue;
                    arrayList.add(string2);
                }
                stringArray = new String[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
                DropFiles.dropFiles(stringArray);
                ((SciInputCommandView)this.associatedConsole.getConfiguration().getInputCommandView()).setCmdBuffer("", false);
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                ((SciInputCommandView)this.associatedConsole.getConfiguration().getInputCommandView()).append(string);
            }
            dropTargetDropEvent.dropComplete(true);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }
}

