/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.console;

import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class SmartScroller
implements AdjustmentListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int START = 0;
    public static final int END = 1;
    private int viewportPosition;
    private JScrollBar scrollBar;
    private boolean adjustScrollBar = true;
    private int previousValue = -1;
    private int previousMaximum = -1;

    public SmartScroller(JScrollPane jScrollPane) {
        this(jScrollPane, 1, 1);
    }

    public SmartScroller(JScrollPane jScrollPane, int n) {
        this(jScrollPane, 1, n);
    }

    public SmartScroller(JScrollPane jScrollPane, int n, int n2) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("invalid scroll direction specified");
        }
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("invalid viewport position specified");
        }
        this.viewportPosition = n2;
        this.scrollBar = n == 0 ? jScrollPane.getHorizontalScrollBar() : jScrollPane.getVerticalScrollBar();
        this.scrollBar.addAdjustmentListener(this);
        Component component = jScrollPane.getViewport().getView();
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            DefaultCaret defaultCaret = (DefaultCaret)jTextComponent.getCaret();
            defaultCaret.setUpdatePolicy(1);
        }
    }

    @Override
    public void adjustmentValueChanged(final AdjustmentEvent adjustmentEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SmartScroller.this.checkScrollBar(adjustmentEvent);
            }
        });
    }

    private void checkScrollBar(AdjustmentEvent adjustmentEvent) {
        boolean bl;
        JScrollBar jScrollBar = (JScrollBar)adjustmentEvent.getSource();
        BoundedRangeModel boundedRangeModel = jScrollBar.getModel();
        int n = boundedRangeModel.getValue();
        int n2 = boundedRangeModel.getExtent();
        int n3 = boundedRangeModel.getMaximum();
        boolean bl2 = this.previousValue != n;
        boolean bl3 = bl = this.previousMaximum != n3;
        if (bl2 && !bl) {
            if (this.viewportPosition == 0) {
                this.adjustScrollBar = n != 0;
            } else {
                boolean bl4 = this.adjustScrollBar = n + n2 >= n3;
            }
        }
        if (this.adjustScrollBar && this.viewportPosition == 1) {
            jScrollBar.removeAdjustmentListener(this);
            n = n3 - n2;
            jScrollBar.setValue(n);
            jScrollBar.addAdjustmentListener(this);
        }
        if (this.adjustScrollBar && this.viewportPosition == 0) {
            jScrollBar.removeAdjustmentListener(this);
            n = n + n3 - this.previousMaximum;
            jScrollBar.setValue(n);
            jScrollBar.addAdjustmentListener(this);
        }
        this.previousValue = n;
        this.previousMaximum = n3;
    }
}

