/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.console.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.MathMLParserSupport;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.layout.JEuclidView;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.modules.jvm.LoadClassPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class ScilabSpecialTextUtilities {
    private static boolean loadedLaTeX;
    private static boolean loadedMathML;
    private static Thread loadJLM;

    public static boolean setText(JComponent jComponent, String string) {
        Icon icon = null;
        if (string != null && string.length() > 1) {
            if (string.startsWith("$") && string.endsWith("$")) {
                icon = ScilabSpecialTextUtilities.compileLaTeXExpression(string.substring(1, string.length() - 1), jComponent.getFont().getSize());
            } else if (string.startsWith("<") && string.endsWith(">")) {
                icon = ScilabSpecialTextUtilities.compileMathMLExpression(string, jComponent.getFont().getSize());
            }
        }
        if (icon == null) {
            try {
                ScilabSpecialTextUtilities.setIcon(jComponent, icon);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            return false;
        }
        try {
            ScilabSpecialTextUtilities.setIcon(jComponent, icon);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return icon != null;
    }

    public static Icon compileLaTeXExpression(String string, int n) {
        if (!loadedLaTeX) {
            LoadClassPath.loadOnUse((String)"graphics_latex_textrendering");
            loadedLaTeX = true;
        }
        return LaTeXCompiler.compile(string, n);
    }

    public static Icon compilePartialLaTeXExpression(String string, int n) {
        if (!loadedLaTeX) {
            if (loadJLM == null) {
                loadJLM = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        LoadClassPath.loadOnUse((String)"graphics_latex_textrendering");
                        LaTeXCompiler.compilePartial("", 0);
                        loadedLaTeX = true;
                        loadJLM = null;
                    }
                });
                loadJLM.setPriority(1);
                loadJLM.start();
            }
            return null;
        }
        return LaTeXCompiler.compilePartial(string, n);
    }

    public static Icon compileMathMLExpression(String string, int n) {
        return ScilabSpecialTextUtilities.compileMathMLExpression(string, n, Color.BLACK);
    }

    public static Icon compileMathMLExpression(String string, int n, Color color) {
        if (!loadedMathML) {
            LoadClassPath.loadOnUse((String)"graphics_mathml_textrendering");
            loadedMathML = true;
        }
        return MathMLCompiler.compile(string, n, color);
    }

    private static void setIcon(JComponent jComponent, Icon icon) throws InvocationTargetException {
        try {
            Class<?> clazz = jComponent.getClass();
            Method method = clazz.getMethod("getIcon", new Class[0]);
            Object object = method.invoke((Object)jComponent, new Object[0]);
            if (icon != null || object != null && object instanceof SpecialIcon) {
                method = clazz.getMethod("setIcon", Icon.class);
                method.invoke((Object)jComponent, icon);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvocationTargetException(noSuchMethodException, "No valid method setIcon");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvocationTargetException(illegalAccessException, "The method setIcon must be public");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InvocationTargetException(invocationTargetException, "The method setIcon threw an exception");
        }
    }

    private static final class LaTeXCompiler {
        private LaTeXCompiler() {
        }

        static Icon compile(String string, int n) {
            TeXFormula.setDefaultDPI();
            TeXIcon teXIcon = null;
            try {
                TeXFormula teXFormula = new TeXFormula(string);
                teXIcon = teXFormula.createTeXIcon(0, (float)n);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return new SpecialIcon((Icon)teXIcon);
        }

        static Icon compilePartial(String string, int n) {
            TeXIcon teXIcon = null;
            try {
                TeXFormula teXFormula = TeXFormula.getPartialTeXFormula((String)string);
                teXIcon = teXFormula.createTeXIcon(0, (float)n);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return teXIcon;
        }
    }

    private static final class MathMLCompiler {
        private static final Graphics2D TEMPGRAPHIC = new BufferedImage(1, 1, 2).createGraphics();

        private MathMLCompiler() {
        }

        static Icon compile(String object, int n, Color color) {
            LayoutContextImpl layoutContextImpl = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());
            layoutContextImpl.setParameter(Parameter.MATHSIZE, (Object)n);
            layoutContextImpl.setParameter(Parameter.MATHCOLOR, (Object)color);
            if (!((String)object).startsWith("<mathml>")) {
                object = "<mathml>" + (String)object + "</mathml>";
            }
            Document document = null;
            try {
                document = MathMLParserSupport.parseString((String)object);
            }
            catch (SAXException sAXException) {
                return null;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            JEuclidView jEuclidView = new JEuclidView((Node)document, (LayoutContext)layoutContextImpl, TEMPGRAPHIC);
            int n2 = (int)Math.ceil(jEuclidView.getWidth());
            int n3 = (int)Math.ceil(jEuclidView.getAscentHeight());
            int n4 = (int)Math.ceil(jEuclidView.getDescentHeight()) + n3;
            if (n2 <= 0 || n4 <= 0) {
                return null;
            }
            BufferedImage bufferedImage = new BufferedImage(n2 + 2, n4, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(new Color(255, 255, 255, 0));
            graphics2D.fillRect(0, 0, n2, n4);
            jEuclidView.draw(graphics2D, 0.0f, (float)n3);
            graphics2D.dispose();
            return new SpecialIcon(new ImageIcon(bufferedImage), (int)Math.ceil(jEuclidView.getDescentHeight()));
        }
    }

    public static class SpecialIcon
    implements Icon {
        Icon icon;
        int depth;

        SpecialIcon(Icon icon) {
            this.icon = icon;
        }

        SpecialIcon(Icon icon, int n) {
            this.icon = icon;
            this.depth = n;
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        public int getIconDepth() {
            return this.depth;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon.paintIcon(component, graphics, n, n2);
        }
    }
}

