/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

@FileStatefulCheck
public final class NestedIfDepthCheck
extends AbstractCheck {
    public static final String MSG_KEY = "nested.if.depth";
    private int max = 1;
    private int depth;

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{83};
    }

    @Override
    public void visitToken(DetailAST literalIf) {
        if (!NestedIfDepthCheck.isElseIf(literalIf)) {
            if (this.depth > this.max) {
                this.log(literalIf, MSG_KEY, this.depth, this.max);
            }
            ++this.depth;
        }
    }

    @Override
    public void leaveToken(DetailAST literalIf) {
        if (!NestedIfDepthCheck.isElseIf(literalIf)) {
            --this.depth;
        }
    }

    private static boolean isElseIf(DetailAST ast) {
        DetailAST parentAST = ast.getParent();
        return NestedIfDepthCheck.isElse(parentAST) || NestedIfDepthCheck.isElseWithCurlyBraces(parentAST);
    }

    private static boolean isElse(DetailAST ast) {
        return ast.getType() == 92;
    }

    private static boolean isElseWithCurlyBraces(DetailAST ast) {
        return ast.getChildCount() == 2 && NestedIfDepthCheck.isElse(ast.getParent());
    }
}

