/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.clipping;

import org.scilab.forge.scirenderer.clipping.ClippingPlane;
import org.scilab.forge.scirenderer.implementation.g2d.G2DDrawingTools;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.tranformations.Vector4d;

public class G2DClippingPlane
implements ClippingPlane {
    private final int index;
    private boolean isEnable = false;
    private G2DDrawingTools drawingTools;
    private Vector4d equation = new Vector4d(0.0, 0.0, 0.0, 0.0);
    private Vector4d projectedEquation = new Vector4d(0.0, 0.0, 0.0, 0.0);
    private Transformation transformation = TransformationFactory.getIdentity();
    private Transformation projectionTransf;
    private boolean updated;

    public G2DClippingPlane(int n, G2DDrawingTools g2DDrawingTools) {
        this.index = n;
        this.drawingTools = g2DDrawingTools;
    }

    @Override
    public boolean isEnable() {
        return this.isEnable;
    }

    @Override
    public void setEnable(boolean bl) {
        this.isEnable = bl;
    }

    @Override
    public void setEquation(Vector4d vector4d) {
        Transformation transformation = this.drawingTools.getTransformationManager().getModelViewStack().peek();
        if (transformation != null) {
            this.equation = G2DClippingPlane.getTransformedEquation(vector4d, transformation);
        }
    }

    @Override
    public Vector4d getEquation() {
        Transformation transformation = this.drawingTools.getMotor3D().getCurrentSingleTransformation();
        if (transformation != null && this.projectionTransf != transformation) {
            this.projectionTransf = transformation;
            this.projectedEquation = G2DClippingPlane.getTransformedEquation(this.equation, transformation);
        }
        return this.projectedEquation;
    }

    @Override
    public void setTransformation(Transformation transformation) {
    }

    @Override
    public Transformation getTransformation() {
        return this.transformation;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    private static final Vector4d getTransformedEquation(Vector4d vector4d, Transformation transformation) {
        double[] dArray = transformation.getInverseTransformation().getMatrix();
        double[] dArray2 = vector4d.getData();
        double d = dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2] + dArray[3] * dArray2[3];
        double d2 = dArray[4] * dArray2[0] + dArray[5] * dArray2[1] + dArray[6] * dArray2[2] + dArray[7] * dArray2[3];
        double d3 = dArray[8] * dArray2[0] + dArray[9] * dArray2[1] + dArray[10] * dArray2[2] + dArray[11] * dArray2[3];
        double d4 = dArray[12] * dArray2[0] + dArray[13] * dArray2[1] + dArray[14] * dArray2[2] + dArray[15] * dArray2[3];
        return new Vector4d(d, d2, d3, d4);
    }
}

