/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.texture;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.scilab.forge.scirenderer.implementation.g2d.motor.G2DStroke;
import org.scilab.forge.scirenderer.implementation.g2d.texture.G2DTextureManager;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.texture.TextEntity;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.forge.scirenderer.texture.TextureDrawingTools;

public class G2DTextureDrawingTools
implements TextureDrawingTools {
    private Graphics2D g2d;
    private int width;
    private int height;
    private Color fillColor;
    private Color borderColor;

    public G2DTextureDrawingTools(Graphics2D graphics2D) {
        this.g2d = graphics2D;
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.g2d = graphics2D;
    }

    public void accept(Texture texture) {
        this.accept(texture, null, null);
    }

    public void accept(Texture texture, Color color, Color color2) {
        G2DTextureManager.G2DTexture g2DTexture = (G2DTextureManager.G2DTexture)texture;
        TextureDrawer textureDrawer = g2DTexture.getDrawer();
        Dimension dimension = textureDrawer.getTextureSize();
        this.width = (int)dimension.getWidth();
        this.height = (int)dimension.getHeight();
        this.accept(textureDrawer, this.width, this.height, color, color2);
    }

    public void accept(TextureDrawer textureDrawer, int n, int n2, Color color, Color color2) {
        boolean bl;
        if (textureDrawer.getOriginPosition() == TextureDrawer.OriginPosition.CENTER) {
            this.g2d.translate((double)n / 2.0, (double)n2 / 2.0);
        }
        boolean bl2 = bl = this.g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON;
        if (!bl) {
            this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.fillColor = color2;
        this.borderColor = color;
        textureDrawer.draw(this);
        this.borderColor = null;
        this.fillColor = null;
        if (!bl) {
            this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    @Override
    public void drawPlus(int n, Appearance appearance) {
        if (n > 1) {
            int n2 = n / 2;
            int[] nArray = new int[]{-n2, 0, n2, 0};
            int[] nArray2 = new int[]{0, -n2, 0, n2};
            this.drawPolyline(nArray, appearance);
            this.drawPolyline(nArray2, appearance);
        } else {
            this.fillDisc(0, 0, 1, appearance.getLineColor());
        }
    }

    @Override
    public void drawMinus(int n, Appearance appearance) {
        if (n > 1) {
            int n2 = n / 2;
            int[] nArray = new int[]{-n2, 0, n2, 0};
            this.drawPolyline(nArray, appearance);
        } else {
            this.fillDisc(0, 0, 1, appearance.getLineColor());
        }
    }

    @Override
    public void drawVerticalLine(int n, Appearance appearance) {
        if (n > 1) {
            int n2 = n / 2;
            int[] nArray = new int[]{0, -n2, 0, n2};
            this.drawPolyline(nArray, appearance);
        } else {
            this.fillDisc(0, 0, 1, appearance.getLineColor());
        }
    }

    @Override
    public void drawPolyline(int[] nArray, Appearance appearance) {
        if (nArray.length == 2) {
            // empty if block
        }
        int n = nArray.length / 2;
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; i += 2) {
            nArray2[n2] = nArray[i];
            nArray3[n2] = nArray[i + 1];
            ++n2;
        }
        this.g2d.setColor(this.getColor(appearance.getLineColor()));
        this.g2d.setStroke(G2DStroke.getStroke(appearance, 0.0));
        this.g2d.drawPolyline(nArray2, nArray3, n);
    }

    @Override
    public void fillPolygon(int[] nArray, Appearance appearance) {
        int n;
        int n2 = nArray.length / 2;
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int n3 = 0;
        for (n = 0; n < nArray.length; n += 2) {
            nArray2[n3] = nArray[n];
            nArray3[n3] = nArray[n + 1];
            ++n3;
        }
        if (appearance.getFillColor().getAlphaAsFloat() != 0.0f) {
            this.g2d.setColor(this.getColor(appearance.getFillColor()));
            this.g2d.fillPolygon(nArray2, nArray3, n2);
        }
        if (!appearance.getLineColor().equals(appearance.getFillColor())) {
            n = nArray.length - nArray.length % 2;
            int[] nArray4 = new int[n + 2];
            System.arraycopy(nArray, 0, nArray4, 0, n);
            nArray4[n] = nArray[0];
            nArray4[n + 1] = nArray[1];
            this.drawPolyline(nArray4, appearance);
        }
    }

    @Override
    public void drawCircle(int n, int n2, int n3, Appearance appearance) {
        this.g2d.setColor(this.getColor(appearance.getLineColor()));
        this.g2d.setStroke(G2DStroke.getStroke(appearance, 0.0));
        double d = (double)n3 / 2.0;
        this.g2d.draw(new Ellipse2D.Double((double)n - d, (double)n2 - d, n3, n3));
    }

    @Override
    public void fillDisc(int n, int n2, int n3, org.scilab.forge.scirenderer.shapes.appearance.Color color) {
        if (color.getAlphaAsFloat() != 0.0f) {
            this.g2d.setColor(this.getColor(color));
            double d = (double)n3 / 2.0;
            this.g2d.fill(new Ellipse2D.Double((double)n - d, (double)n2 - d, n3, n3));
        }
    }

    @Override
    public void draw(TextEntity textEntity, int n, int n2) {
        if (textEntity != null && textEntity.isValid()) {
            Object object;
            Object object2;
            if (textEntity.isTextAntiAliased()) {
                this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                object2 = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
                if (object2 != null && (object = object2.get(RenderingHints.KEY_TEXT_ANTIALIASING)) != null) {
                    this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
                }
            } else {
                this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
            if (textEntity.isTextUseFractionalMetrics()) {
                this.g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            } else {
                this.g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            }
            this.g2d.setColor(this.getColor(textEntity.getTextColor()));
            object2 = new TextLayout(textEntity.getText(), textEntity.getFont(), this.g2d.getFontRenderContext());
            object = ((TextLayout)object2).getBounds();
            this.g2d.setFont(textEntity.getFont());
            this.g2d.drawString(textEntity.getText(), (float)((double)n - ((RectangularShape)object).getX()), (float)n2 + ((TextLayout)object2).getAscent());
        }
    }

    @Override
    public void draw(Icon icon, int n, int n2) {
        icon.paintIcon(new JLabel(), this.g2d, n, n2);
    }

    @Override
    public void clear(org.scilab.forge.scirenderer.shapes.appearance.Color color) {
        this.g2d.setColor(this.getColor(color));
        this.g2d.fillRect(0, 0, this.width, this.height);
    }

    public Color getColor(org.scilab.forge.scirenderer.shapes.appearance.Color color) {
        if (color.equals(org.scilab.forge.scirenderer.shapes.appearance.Color.BLACK)) {
            if (this.fillColor == null) {
                return color;
            }
            return this.fillColor;
        }
        if (color.equals(org.scilab.forge.scirenderer.shapes.appearance.Color.WHITE)) {
            if (this.borderColor == null) {
                return color;
            }
            return this.borderColor;
        }
        return color;
    }
}

