/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl;

import com.jogamp.opengl.GL2;
import java.awt.Color;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.clipping.ClippingManager;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvas;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCapacity;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLPixelDrawingMode;
import org.scilab.forge.scirenderer.implementation.jogl.clipping.JoGLClippingManager;
import org.scilab.forge.scirenderer.implementation.jogl.drawer.JoGLShapeDrawer;
import org.scilab.forge.scirenderer.implementation.jogl.lightning.JoGLLightManager;
import org.scilab.forge.scirenderer.lightning.LightManager;
import org.scilab.forge.scirenderer.renderer.Renderer;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.tranformations.TransformationManager;
import org.scilab.forge.scirenderer.tranformations.TransformationManagerImpl;
import org.scilab.forge.scirenderer.tranformations.TransformationManagerListener;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public class JoGLDrawingTools
implements DrawingTools {
    private final JoGLCapacity capacity = new JoGLCapacity();
    private final TransformationManager transformationManager;
    private final JoGLLightManager lightManager;
    private final JoGLClippingManager clippingManager;
    private final JoGLCanvas canvas;
    private GL2 gl;
    private int PixelDrawingMode;

    JoGLDrawingTools(JoGLCanvas joGLCanvas) {
        this.transformationManager = new TransformationManagerImpl(joGLCanvas);
        this.lightManager = new JoGLLightManager(this);
        this.clippingManager = new JoGLClippingManager(this);
        this.canvas = joGLCanvas;
        this.PixelDrawingMode = 5379;
        this.transformationManager.addListener(new TransformationManagerListener(){

            @Override
            public void transformationChanged(TransformationManager transformationManager) {
                JoGLDrawingTools.this.gl.glMatrixMode(5888);
                if (transformationManager.isUsingSceneCoordinate()) {
                    JoGLDrawingTools.this.gl.glLoadMatrixd(transformationManager.getTransformation().getMatrix(), 0);
                } else {
                    JoGLDrawingTools.this.gl.glLoadMatrixd(transformationManager.getWindowTransformation().getMatrix(), 0);
                }
            }
        });
    }

    void glSynchronize(GL2 gL2) {
        this.gl = gL2;
        this.transformationManager.reset();
        this.capacity.glReload(gL2);
        this.lightManager.reload();
        this.clippingManager.reload();
    }

    @Override
    public JoGLCanvas getCanvas() {
        return this.canvas;
    }

    public GL2 getGl() {
        return this.gl;
    }

    public JoGLCapacity getGLCapacity() {
        return this.capacity;
    }

    @Override
    public TransformationManager getTransformationManager() {
        return this.transformationManager;
    }

    @Override
    public LightManager getLightManager() {
        return this.lightManager;
    }

    @Override
    public ClippingManager getClippingManager() {
        return this.clippingManager;
    }

    public void setPixelDrawingMode(JoGLPixelDrawingMode joGLPixelDrawingMode) {
        switch (joGLPixelDrawingMode) {
            case CLEAR: {
                this.PixelDrawingMode = 5376;
                break;
            }
            case AND: {
                this.PixelDrawingMode = 5377;
                break;
            }
            case AND_REVERSE: {
                this.PixelDrawingMode = 5378;
                break;
            }
            case COPY: {
                this.PixelDrawingMode = 5379;
                break;
            }
            case AND_INVERTED: {
                this.PixelDrawingMode = 5380;
                break;
            }
            case NOOP: {
                this.PixelDrawingMode = 5381;
                break;
            }
            case XOR: {
                this.PixelDrawingMode = 5382;
                break;
            }
            case OR: {
                this.PixelDrawingMode = 5383;
                break;
            }
            case NOR: {
                this.PixelDrawingMode = 5384;
                break;
            }
            case EQUIV: {
                this.PixelDrawingMode = 5385;
                break;
            }
            case INVERT: {
                this.PixelDrawingMode = 5386;
                break;
            }
            case OR_REVERSE: {
                this.PixelDrawingMode = 5387;
                break;
            }
            case COPY_INVERTED: {
                this.PixelDrawingMode = 5388;
                break;
            }
            case OR_INVERTED: {
                this.PixelDrawingMode = 5389;
                break;
            }
            case NAND: {
                this.PixelDrawingMode = 5390;
                break;
            }
            case SET: {
                this.PixelDrawingMode = 5391;
                break;
            }
            default: {
                this.PixelDrawingMode = 5379;
            }
        }
    }

    public int getGLPixelDrawingMode() {
        return this.PixelDrawingMode;
    }

    @Override
    public void clear(org.scilab.forge.scirenderer.shapes.appearance.Color color) {
        this.gl.glClearColor(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), 1.0f);
        this.gl.glClear(16384);
    }

    @Override
    public void clear(Color color) {
        float[] fArray = color.getRGBColorComponents(null);
        this.gl.glClearColor(fArray[0], fArray[1], fArray[2], 1.0f);
        this.gl.glClear(16384);
    }

    @Override
    public void clearDepthBuffer() {
        this.gl.glClear(256);
    }

    @Override
    public void draw(Renderer renderer) {
        this.canvas.getRendererManager().draw(this, renderer);
    }

    @Override
    public void draw(Geometry geometry) throws SciRendererException {
        JoGLShapeDrawer.getDrawer().draw(this, geometry, Appearance.getDefault(), JoGLShapeDrawer.AntiAliasing.ON);
    }

    @Override
    public void draw(Geometry geometry, JoGLShapeDrawer.AntiAliasing antiAliasing) throws SciRendererException {
        JoGLShapeDrawer.getDrawer().draw(this, geometry, Appearance.getDefault(), antiAliasing);
    }

    @Override
    public void draw(Geometry geometry, Appearance appearance) throws SciRendererException {
        JoGLShapeDrawer.getDrawer().draw(this, geometry, appearance);
    }

    @Override
    public void draw(Geometry geometry, Appearance appearance, JoGLShapeDrawer.AntiAliasing antiAliasing) throws SciRendererException {
        JoGLShapeDrawer.getDrawer().draw(this, geometry, appearance, antiAliasing);
    }

    @Override
    public void draw(Texture texture) throws SciRendererException {
        this.canvas.getTextureManager().draw(this, texture);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, ElementsBuffer elementsBuffer) throws SciRendererException {
        this.canvas.getTextureManager().draw(this, texture, anchorPosition, elementsBuffer, 0, 1, 0.0, null, null);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, ElementsBuffer elementsBuffer, double d) throws SciRendererException {
        this.canvas.getTextureManager().draw(this, texture, anchorPosition, elementsBuffer, 0, 1, d, null, null);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, ElementsBuffer elementsBuffer, org.scilab.forge.scirenderer.shapes.appearance.Color color, ElementsBuffer elementsBuffer2) throws SciRendererException {
        this.canvas.getTextureManager().draw(this, texture, anchorPosition, elementsBuffer, 0, 1, 0.0, color, elementsBuffer2);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, ElementsBuffer elementsBuffer, double d, org.scilab.forge.scirenderer.shapes.appearance.Color color, ElementsBuffer elementsBuffer2) throws SciRendererException {
        this.canvas.getTextureManager().draw(this, texture, anchorPosition, elementsBuffer, 0, 1, d, color, elementsBuffer2);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, ElementsBuffer elementsBuffer, int n, int n2, double d) throws SciRendererException {
        this.canvas.getTextureManager().draw(this, texture, anchorPosition, elementsBuffer, n, n2, d, null, null);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, ElementsBuffer elementsBuffer, int n, int n2, double d, org.scilab.forge.scirenderer.shapes.appearance.Color color, ElementsBuffer elementsBuffer2) throws SciRendererException {
        this.canvas.getTextureManager().draw(this, texture, anchorPosition, elementsBuffer, n, n2, d, color, elementsBuffer2);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, Vector3d vector3d) throws SciRendererException {
        this.canvas.getTextureManager().draw(this, texture, anchorPosition, vector3d, 0.0);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, Vector3d vector3d, double d) throws SciRendererException {
        this.canvas.getTextureManager().draw(this, texture, anchorPosition, vector3d, d);
    }

    public void bind(Texture texture) throws SciRendererException {
        this.canvas.getTextureManager().bind(this, texture);
    }
}

