/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.picking;

import com.jogamp.opengl.GL2;
import java.awt.Point;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.picking.PickingTools;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public class JoGLPickingTools
implements PickingTools {
    private final JoGLDrawingTools drawingTools;

    public JoGLPickingTools(JoGLDrawingTools joGLDrawingTools) {
        this.drawingTools = joGLDrawingTools;
    }

    @Override
    public Vector3d getUnderlyingPoint(Point point) {
        GL2 gL2 = this.drawingTools.getGl().getGL2();
        int n = point.x;
        int n2 = this.drawingTools.getCanvas().getHeight() - point.y - 1;
        FloatBuffer floatBuffer = FloatBuffer.allocate(1);
        floatBuffer.rewind();
        gL2.glReadPixels(n, n2, 1, 1, 6402, 5126, (Buffer)floatBuffer);
        floatBuffer.rewind();
        float f = 2.0f * floatBuffer.get() - 1.0f;
        float f2 = 2.0f * (float)n / (float)this.drawingTools.getCanvas().getWidth() - 1.0f;
        float f3 = 2.0f * (float)n2 / (float)this.drawingTools.getCanvas().getHeight() - 1.0f;
        return new Vector3d(f2, f3, f);
    }

    @Override
    public Canvas getCanvas() {
        return this.drawingTools.getCanvas();
    }
}

