/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.ruler;

import org.scilab.forge.scirenderer.ruler.RulerModel;
import org.scilab.forge.scirenderer.ruler.graduations.Graduations;
import org.scilab.forge.scirenderer.ruler.graduations.LinearGraduations;
import org.scilab.forge.scirenderer.ruler.graduations.LogarithmicGraduations;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public final class DefaultRulerModel
implements RulerModel {
    private double firstValue = 0.0;
    private double secondValue = 1.0;
    private Vector3d firstPoint = DEFAULT_FIRST_POINT;
    private Vector3d secondPoint = DEFAULT_SECOND_POINT;
    private Vector3d ticksDirection = DEFAULT_TICKS_DIRECTION;
    private int ticksLength = 10;
    private int subTicksLength = 5;
    private double minimalSubTicksDistance = 8.0;
    private int spriteDistance = 12;
    private Graduations graduations;
    private double margin = 12.0;
    private boolean lineVisible = true;
    private boolean isAutoTicks = true;
    private boolean isLogarithmic = false;
    private Color color = DEFAULT_COLOR;
    private Graduations userGraduation;
    private double lineWidth = 1.0;
    private int subticksNumber = -1;
    private String format = "";
    private double scale;
    private double translate;

    @Override
    public double getFirstValue() {
        return this.firstValue;
    }

    public void setFirstValue(double d) {
        this.graduations = null;
        this.firstValue = Double.isInfinite(d) ? Double.MAX_VALUE : d;
    }

    @Override
    public double getSecondValue() {
        return this.secondValue;
    }

    public void setSecondValue(double d) {
        this.graduations = null;
        this.secondValue = Double.isInfinite(d) ? Double.MAX_VALUE : d;
    }

    public void setValues(double d, double d2) {
        this.setFirstValue(d);
        this.setSecondValue(d2);
    }

    @Override
    public Vector3d getFirstPoint() {
        return this.firstPoint;
    }

    public void setFirstPoint(Vector3d vector3d) {
        this.firstPoint = vector3d;
    }

    @Override
    public Vector3d getSecondPoint() {
        return this.secondPoint;
    }

    public void setSecondPoint(Vector3d vector3d) {
        this.secondPoint = vector3d;
    }

    public void setPoints(Vector3d vector3d, Vector3d vector3d2) {
        this.firstPoint = vector3d;
        this.secondPoint = vector3d2;
    }

    @Override
    public Vector3d getTicksDirection() {
        return this.ticksDirection;
    }

    public void setTicksDirection(Vector3d vector3d) {
        this.ticksDirection = vector3d;
    }

    @Override
    public int getTicksLength() {
        return this.ticksLength;
    }

    public void setTicksLength(int n) {
        this.ticksLength = n;
    }

    @Override
    public int getSubTicksLength() {
        return this.subTicksLength;
    }

    public void setSubTicksLength(int n) {
        this.subTicksLength = n;
    }

    @Override
    public Graduations getGraduations() {
        if (this.isAutoTicks) {
            if (this.graduations == null) {
                this.graduations = this.isLogarithmic ? LogarithmicGraduations.create(this.getFirstValue(), this.getSecondValue()) : LinearGraduations.create(this.getFirstValue(), this.getSecondValue());
            }
            return this.graduations;
        }
        return this.userGraduation;
    }

    public void setUserGraduation(Graduations graduations) {
        this.userGraduation = graduations;
    }

    @Override
    public Vector3d getPosition(double d) {
        if (this.firstPoint != null && this.secondPoint != null) {
            if (this.isLogarithmic()) {
                double d2 = Math.log10(d);
                double d3 = Math.log10(this.firstValue);
                double d4 = Math.log10(this.secondValue);
                double d5 = d4 - d3;
                double d6 = (d2 - d3) / d5;
                double d7 = (d4 - d2) / d5;
                return this.firstPoint.times(d7).plus(this.secondPoint.times(d6));
            }
            double d8 = this.secondValue - this.firstValue;
            return this.firstPoint.times((this.secondValue - d) / d8).plus(this.secondPoint.times((d - this.firstValue) / d8));
        }
        return null;
    }

    @Override
    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double d) {
        this.margin = d;
    }

    @Override
    public boolean isLineVisible() {
        return this.lineVisible;
    }

    public void setLineVisible(boolean bl) {
        this.lineVisible = bl;
    }

    @Override
    public boolean isAutoTicks() {
        return this.isAutoTicks;
    }

    public void setAutoTicks(boolean bl) {
        this.isAutoTicks = bl;
    }

    @Override
    public boolean isLogarithmic() {
        return this.isLogarithmic;
    }

    public void setLogarithmic(boolean bl) {
        if (bl != this.isLogarithmic) {
            this.isLogarithmic = bl;
            this.graduations = null;
        }
    }

    @Override
    public int getSpriteDistance() {
        return this.spriteDistance;
    }

    public void setSpriteDistance(int n) {
        this.spriteDistance = n;
    }

    @Override
    public double getMinimalSubTicksDistance() {
        return this.minimalSubTicksDistance;
    }

    public void setMinimalSubTicksDistance(double d) {
        this.minimalSubTicksDistance = d;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double d) {
        this.lineWidth = d;
    }

    @Override
    public int getSubticksNumber() {
        return this.subticksNumber;
    }

    public void setSubticksNumber(int n) {
        this.subticksNumber = n;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public double getTranslate() {
        return this.translate;
    }

    public void setSTFactors(Double[] doubleArray) {
        this.scale = doubleArray[0];
        this.translate = doubleArray[1];
    }
}

