/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.tranformations;

import org.scilab.forge.scirenderer.tranformations.Vector3d;

public class Vector3f {
    private final float x;
    private final float y;
    private final float z;

    public Vector3f(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public Vector3d asDouble() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public Vector3f plus(Vector3f vector3f) {
        return new Vector3f(this.x + vector3f.x, this.y + vector3f.y, this.z + vector3f.z);
    }

    public Vector3f minus(Vector3f vector3f) {
        return new Vector3f(this.x - vector3f.x, this.y - vector3f.y, this.z - vector3f.z);
    }

    public Vector3f negate() {
        return new Vector3f(-this.x, -this.y, -this.z);
    }

    public Vector3f times(float f) {
        return new Vector3f(this.x * f, this.y * f, this.z * f);
    }

    public Vector3f getNormalized() {
        float f = this.getNorm();
        if (f == 0.0f) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        return this.times(1.0f / this.getNorm());
    }

    public float getNorm() {
        return (float)Math.sqrt(this.getNorm2());
    }

    public float getNorm2() {
        return this.scalar(this);
    }

    public float scalar(Vector3f vector3f) {
        return this.x * vector3f.x + this.y * vector3f.y + this.z * vector3f.z;
    }

    public static Vector3f product(Vector3f vector3f, Vector3f vector3f2) {
        return new Vector3f(vector3f.y * vector3f2.z - vector3f.z * vector3f2.y, vector3f.z * vector3f2.x - vector3f.x * vector3f2.z, vector3f.x * vector3f2.y - vector3f.y * vector3f2.x);
    }

    public static final float det(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        return vector3f.x * (vector3f2.y * vector3f3.z - vector3f2.z * vector3f3.y) + vector3f.y * (vector3f2.z * vector3f3.x - vector3f2.x * vector3f3.z) + vector3f.z * (vector3f2.x * vector3f3.y - vector3f2.y * vector3f3.x);
    }

    public static final Vector3f getBarycenter(Vector3f vector3f, Vector3f vector3f2, float f, float f2) {
        return new Vector3f(vector3f.x * f + vector3f2.x * f2, vector3f.y * f + vector3f2.y * f2, vector3f.z * f + vector3f2.z * f2);
    }
}

